/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.ukulele;

import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentThemeLoader;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.ukulele.UkuleleNoteButton;
import com.google.gson.JsonObject;
import java.awt.Color;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class UkuleleThemeLoader
extends InstrumentThemeLoader {
    private Color topColumnNoteReleasedColor = Color.BLACK;
    private Color topColumnLabelReleasedColor = Color.BLACK;
    private Color topColumnNotePressedColor = Color.BLACK;
    private Color topColumnLabelPressedColor = Color.BLACK;

    public UkuleleThemeLoader(class_2960 instrumentId) {
        super(instrumentId);
        this.addListener(this::loadColorTheme);
    }

    private void loadColorTheme(JsonObject theme) {
        this.topColumnNoteReleasedColor = this.getRawNotePressed();
        this.topColumnNotePressedColor = this.getRawNotePressed();
        this.topColumnLabelPressedColor = this.getRawLabelPressed();
        this.topColumnLabelReleasedColor = this.getRawLabelPressed();
        if (!theme.has("ukulele")) {
            return;
        }
        JsonObject ukuleleMeta = theme.getAsJsonObject("ukulele");
        JsonObject noteMeta = ukuleleMeta.getAsJsonObject("note");
        this.topColumnNoteReleasedColor = this.getTheme(noteMeta, "released", this.topColumnNoteReleasedColor);
        this.topColumnNotePressedColor = this.getTheme(noteMeta, "pressed", this.topColumnNotePressedColor);
        JsonObject labelMeta = ukuleleMeta.getAsJsonObject("label");
        this.topColumnLabelReleasedColor = this.getTheme(labelMeta, "released", this.topColumnLabelReleasedColor);
        this.topColumnLabelPressedColor = this.getTheme(labelMeta, "pressed", this.topColumnLabelPressedColor);
    }

    public Color topColumnNoteReleasedColor(NoteButton noteButton) {
        return this.topColumnNoteReleasedColor;
    }

    public Color topColumnLabelReleasedColor(NoteButton noteButton) {
        return this.topColumnLabelReleasedColor;
    }

    public Color topColumnNotePressedColor(NoteButton noteButton) {
        return this.topColumnNotePressedColor;
    }

    public Color topColumnLabelPressedColor(NoteButton noteButton) {
        return this.topColumnLabelPressedColor;
    }

    @Override
    public Color noteReleased(NoteButton noteButton) {
        return this.overrideTopColumn(noteButton, this.topColumnNoteReleasedColor(noteButton), super.noteReleased(noteButton));
    }

    @Override
    public Color notePressed(NoteButton noteButton) {
        return this.overrideTopColumn(noteButton, this.topColumnNotePressedColor(noteButton), super.notePressed(noteButton));
    }

    @Override
    public Color labelReleased(NoteButton noteButton) {
        return this.overrideTopColumn(noteButton, this.topColumnLabelReleasedColor(noteButton), super.labelReleased(noteButton));
    }

    @Override
    public Color labelPressed(NoteButton noteButton) {
        return this.overrideTopColumn(noteButton, this.topColumnLabelPressedColor(noteButton), super.labelPressed(noteButton));
    }

    private Color overrideTopColumn(NoteButton noteButton, Color newColor, Color superColor) {
        UkuleleNoteButton unb = (UkuleleNoteButton)noteButton;
        if (unb.ukuleleScreen().isTopRegular()) {
            return superColor;
        }
        if (unb.column == 0) {
            return newColor;
        }
        return superColor;
    }
}

