/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.partial.note;

import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentThemeLoader;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.animation.RingAnimationController;
import com.cstav.genshinstrument.client.util.ClientUtil;
import java.awt.Point;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class NoteRing {
    public static final String RING_GLOB_FILENAME = "note/ring.png";
    protected final RingAnimationController ringAnimation;
    public final NoteButton noteButton;
    public int size;
    public float alpha;
    protected boolean isForeign;

    public NoteRing(NoteButton noteButton, boolean isForeign) {
        this.noteButton = noteButton;
        this.ringAnimation = new RingAnimationController(0.3, 40.0, this);
    }

    public void playAnim() {
        if (this.isForeign) {
            this.ringAnimation.play(-0.4f);
        } else {
            this.ringAnimation.play();
        }
    }

    public void render(class_332 gui, InstrumentThemeLoader themeLoader) {
        if (!this.ringAnimation.isPlaying()) {
            return;
        }
        this.ringAnimation.update();
        Point ringCenter = ClientUtil.getInitCenter(this.noteButton.getInitX(), this.noteButton.getInitY(), this.noteButton.instrumentScreen.getNoteSize(), this.size);
        ClientUtil.setShaderColor(themeLoader.noteRing(this.noteButton), this.alpha);
        gui.method_25290(InstrumentScreen.getInternalResourceFromGlob(RING_GLOB_FILENAME), ringCenter.x, ringCenter.y, 0.0f, 0.0f, this.size, this.size, this.size, this.size);
        ClientUtil.resetShaderColor();
    }

    public boolean isPlaying() {
        return this.ringAnimation.isPlaying();
    }
}

