/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.partial.note;

import com.cstav.genshinstrument.GInstrumentMod;
import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButtonRenderer;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteNotation;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.label.NoteLabelSupplier;
import com.cstav.genshinstrument.client.util.ClientUtil;
import com.cstav.genshinstrument.networking.GIPacketHandler;
import com.cstav.genshinstrument.networking.buttonidentifier.NoteButtonIdentifier;
import com.cstav.genshinstrument.networking.packet.instrument.c2s.C2SNoteSoundPacket;
import com.cstav.genshinstrument.sound.NoteSound;
import com.cstav.genshinstrument.util.InstrumentEntityData;
import com.cstav.genshinstrument.util.LabelUtil;
import java.awt.Point;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1144;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4264;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class NoteButton
extends class_4264 {
    public final InstrumentScreen instrumentScreen;
    protected final class_310 minecraft = class_310.method_1551();
    private NoteSound sound;
    private NoteLabelSupplier labelSupplier;
    protected NoteButtonRenderer noteRenderer;
    private int initX;
    private int initY;
    private int initWidth;
    private int initHeight;
    private int pitch;
    private boolean locked = false;

    @Nullable
    public NoteButtonIdentifier getIdentifier() {
        return null;
    }

    protected abstract NoteButtonRenderer initNoteRenderer();

    public NoteButton(NoteSound sound, NoteLabelSupplier labelSupplier, InstrumentScreen instrumentScreen, int pitch) {
        super(0, 0, 42, 42, (class_2561)class_2561.method_43473());
        this.field_22758 = this.field_22759 = instrumentScreen.getNoteSize();
        this.sound = sound;
        this.labelSupplier = labelSupplier;
        this.instrumentScreen = instrumentScreen;
        this.pitch = pitch;
    }

    public NoteButton(NoteSound sound, NoteLabelSupplier labelSupplier, InstrumentScreen instrumentScreen) {
        this(sound, labelSupplier, instrumentScreen, instrumentScreen.getPitch());
    }

    public NoteButtonRenderer getRenderer() {
        return this.noteRenderer;
    }

    public void setLabelSupplier(NoteLabelSupplier labelSupplier) {
        this.labelSupplier = labelSupplier;
        this.updateNoteLabel();
    }

    public NoteLabelSupplier getLabelSupplier() {
        return this.labelSupplier;
    }

    public void updateNoteLabel() {
        this.method_25355(this.getLabelSupplier().get(this));
    }

    public NoteSound getSound() {
        return this.sound;
    }

    public void setSound(NoteSound sound) {
        this.sound = sound;
    }

    public class_2338 getSoundSourcePos() {
        class_746 player = class_310.method_1551().field_1724;
        return InstrumentEntityData.isItem((class_1657)player) ? player.method_24515() : InstrumentEntityData.getBlockPos((class_1657)player);
    }

    public void initPos() {
        this.initX = this.method_46426();
        this.initY = this.method_46427();
        this.initWidth = this.method_25368();
        this.initHeight = this.method_25364();
    }

    public int getInitX() {
        return this.initX;
    }

    public int getInitY() {
        return this.initY;
    }

    public int getInitWidth() {
        return this.initWidth;
    }

    public int getInitHeight() {
        return this.initHeight;
    }

    public Point getCenter() {
        return ClientUtil.getInitCenter(this.initX, this.initY, this.instrumentScreen.getNoteSize(), this.field_22758);
    }

    public void moveToCenter() {
        Point center = this.getCenter();
        this.method_48229(center.x, center.y);
    }

    public int getPitch() {
        return this.pitch;
    }

    public void setPitch(int pitch) {
        this.pitch = NoteSound.clampPitch(pitch);
        this.updateNoteLabel();
    }

    public int soundIndex() {
        return this.getSound().index;
    }

    public NoteNotation getNotation() {
        return (Boolean)ModClientConfigs.ACCURATE_NOTES.get() != false ? NoteNotation.getNotation(this.getNoteName()) : NoteNotation.NONE;
    }

    public String getFormattedNoteName() {
        return LabelUtil.formatNoteName(this.getNoteName(), true);
    }

    public String getNoteName() {
        if (this.instrumentScreen.noteLayout() == null) {
            return "";
        }
        return LabelUtil.getNoteName(this.instrumentScreen.getPitch(), this.instrumentScreen.noteLayout(), this.getNoteOffset());
    }

    public abstract int getNoteOffset();

    public void init() {
        this.noteRenderer = this.initNoteRenderer();
        this.initPos();
        this.setLabelSupplier(this.labelSupplier);
    }

    public boolean isPlaying() {
        return this.noteRenderer.noteAnimation.isPlaying();
    }

    public void method_48579(class_332 gui, int mouseX, int mouseY, float partialTick) {
        this.noteRenderer.render(gui, mouseX, mouseY, partialTick, this.instrumentScreen.getThemeLoader());
    }

    public void release() {
        this.unlockInput();
    }

    protected void lockInput() {
        this.locked = true;
    }

    public void unlockInput() {
        this.locked = false;
    }

    public boolean play(NoteSound sound, int pitch) {
        if (this.locked) {
            return false;
        }
        this.playLocalSound(sound, pitch);
        this.sendNotePlayPacket(sound, pitch);
        this.playNoteAnimation(false);
        this.lockInput();
        return true;
    }

    public boolean play() {
        return this.play(this.getSound(), this.getPitch());
    }

    public void method_25306() {
        this.play();
    }

    protected void playLocalSound(NoteSound sound, int pitch) {
        sound.playLocally(pitch, this.instrumentScreen.volume(), this.getSoundSourcePos());
    }

    protected void sendNotePlayPacket(NoteSound sound, int pitch) {
        GIPacketHandler.sendToServer(new C2SNoteSoundPacket(this, sound, pitch));
    }

    public void playNoteAnimation(boolean isForeign) {
        if (this.instrumentScreen.instrumentRenders()) {
            this.noteRenderer.playNoteAnimation(isForeign);
        }
    }

    public int getABCOffset() {
        class_2960 instrumentId = this.instrumentScreen.getInstrumentId();
        String noteName = this.getNoteName();
        if (noteName.isEmpty()) {
            GInstrumentMod.LOGGER.warn("Cannot get ABC offset for an instrument without a note layout! (" + String.valueOf(instrumentId) + ")");
            return 0;
        }
        char note = noteName.charAt(0);
        for (int i = 0; i < LabelUtil.ABC.length; ++i) {
            if (note != LabelUtil.ABC[i]) continue;
            return i;
        }
        GInstrumentMod.LOGGER.warn("Could not get note " + note + " for instrument " + String.valueOf(this.instrumentScreen.getInstrumentId()) + "!");
        return 0;
    }

    public boolean method_25406(double pMouseX, double pMouseY, int pButton) {
        this.method_25365(false);
        return super.method_25406(pMouseX, pMouseY, pButton);
    }

    public void method_25354(class_1144 pHandler) {
    }

    protected void method_47399(class_6382 neo) {
        neo.method_37034(class_6381.field_33788, this.method_25369());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof NoteButton)) return false;
        NoteButton btn = (NoteButton)((Object)obj);
        if (!this.getIdentifier().matches(btn)) return false;
        return true;
    }

    public void method_53533(int height) {
        this.field_22759 = height;
    }
}

