/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.partial;

import com.cstav.genshinstrument.GInstrumentMod;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public class InstrumentThemeLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String JSON_STYLER_NAME = "instrument_style.json";
    public static final class_2960 INSTRUMENTS_META_LOC = InstrumentScreen.getInternalResourceFromGlob("instruments.meta.json");
    public static final class_2960 GLOBAL_LOC = InstrumentScreen.getInternalResourceFromGlob("instrument/global");
    private static boolean isGlobalThemed;
    private static final HashMap<class_2960, JsonObject> CACHES;
    private static final ArrayList<InstrumentThemeLoader> LOADERS;
    private static final Color DEF_PRESSED_THEME;
    public final class_2960 resourcesRootDir;
    public final class_2960 instrumentId;
    public final class_2960 subjectInstrumentId;
    private final boolean ignoreGlobal;
    private Color rawLabelPressed = Color.BLACK;
    private Color rawLabelReleased = Color.BLACK;
    private Color rawNotePressed = Color.BLACK;
    private Color rawNoteReleased = Color.BLACK;
    private Color rawNoteRing = Color.BLACK;
    private final ArrayList<Consumer<JsonObject>> listeners = new ArrayList();

    public static boolean isGlobalThemed() {
        return isGlobalThemed;
    }

    public InstrumentThemeLoader(class_2960 resourceRootDir, class_2960 instrumentId, class_2960 subjectInstrumentId, boolean ignoreGlobal) {
        this.resourcesRootDir = resourceRootDir;
        this.instrumentId = instrumentId;
        this.subjectInstrumentId = subjectInstrumentId;
        this.ignoreGlobal = ignoreGlobal;
        LOADERS.add(this);
        this.addListener(this::loadColorTheme);
    }

    public InstrumentThemeLoader(class_2960 resourceRootDir, class_2960 instrumentId, boolean ignoreGlobal) {
        this(resourceRootDir, instrumentId, instrumentId, ignoreGlobal);
    }

    public InstrumentThemeLoader(class_2960 resourceRootDir, class_2960 instrumentId) {
        this(resourceRootDir, instrumentId, false);
    }

    public InstrumentThemeLoader(class_2960 instrumentId) {
        this(InstrumentScreen.getInstrumentRootPath(instrumentId), instrumentId);
    }

    public static InstrumentThemeLoader fromOther(InstrumentThemeLoader other, class_2960 instrumentId) {
        return new InstrumentThemeLoader(other.resourcesRootDir, instrumentId, other.subjectInstrumentId, other.ignoreGlobal);
    }

    public void addListener(Consumer<JsonObject> themeLoader) {
        this.listeners.add(themeLoader);
    }

    private void loadColorTheme(JsonObject theme) {
        if (!theme.has("label") || !theme.has("note")) {
            this.loadLegacyTheme(theme);
            return;
        }
        this.setPressStatedTheme(theme, "note", this::setRawNotePressed, this::setNoteReleased, DEF_PRESSED_THEME, Color.BLACK);
        this.setPressStatedTheme(theme, "label", this::setLabelPressed, this::setLabelReleased, this.rawNotePressed, Color.BLACK);
        this.setRawNoteRing(this.getTheme(theme, "note_ring", this.rawLabelReleased));
    }

    public void setPressStatedTheme(JsonObject theme, String propName, Consumer<Color> pressConsumer, Consumer<Color> releaseConsumer, Color defPress, Color defRelease) {
        JsonObject pressThemes = theme.getAsJsonObject(propName);
        if (pressThemes == null) {
            pressConsumer.accept(defPress);
            releaseConsumer.accept(defRelease);
            return;
        }
        pressConsumer.accept(this.getTheme(pressThemes, "pressed", defPress));
        releaseConsumer.accept(this.getTheme(pressThemes, "released", defRelease));
    }

    @Deprecated(forRemoval=true)
    private void loadLegacyTheme(JsonObject theme) {
        LOGGER.warn("The active resourcepack is using the legacy instrument styler format on instrument " + String.valueOf(this.instrumentId) + "!");
        LOGGER.warn("The format is deprecated and will be left unsupported, and should be migrated to the new format.");
        LOGGER.warn("Please update your pack, contact the author of it, or visit the Genshin Instruments GitHub repository to learn more.");
        this.setNoteTheme(this.getTheme(theme, "note_theme", Color.BLACK));
        this.setLabelTheme(this.getTheme(theme, "label_theme", Color.BLACK));
        this.setPressedNoteTheme(this.getTheme(theme, "note_pressed_theme", DEF_PRESSED_THEME));
        this.setNoteRingTheme(this.getTheme(theme, "note_ring_theme", this.rawLabelReleased));
        this.setLabelPressed(this.rawNotePressed);
    }

    public Color getTheme(JsonObject theme, String propertyName, Color def) {
        JsonElement rgbArray = theme.get(propertyName);
        if (rgbArray == null || !rgbArray.isJsonArray()) {
            return def;
        }
        return this.tryGetProperty(rgbArray.getAsJsonArray(), rgb -> new Color(rgb.get(0).getAsInt(), rgb.get(1).getAsInt(), rgb.get(2).getAsInt()), def);
    }

    protected <T, J extends JsonElement> T tryGetProperty(J element, Function<J, T> getter, T def) {
        try {
            return getter.apply(element);
        }
        catch (Exception e) {
            LOGGER.error("Error retrieving JSON property for " + String.valueOf(this.instrumentId), (Throwable)e);
            return def;
        }
    }

    private static void subscribeResourcesReloadEvent() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return GInstrumentMod.loc("instrument_theme_loaders");
            }

            public void method_14491(class_3300 resourceManager) {
                InstrumentThemeLoader.reload(resourceManager);
            }
        });
    }

    private static void reload(class_3300 resourceManager) {
        InstrumentThemeLoader.updateIsGlobalThemed(resourceManager);
        for (InstrumentThemeLoader instrumentLoader : LOADERS) {
            instrumentLoader.performReload(resourceManager);
        }
        CACHES.clear();
    }

    private static void updateIsGlobalThemed(class_3300 resourceManager) {
        isGlobalThemed = false;
        Optional instrumentsMeta = resourceManager.method_14486(INSTRUMENTS_META_LOC);
        if (instrumentsMeta.isEmpty()) {
            LOGGER.warn("No instrument meta found for " + String.valueOf(INSTRUMENTS_META_LOC) + "!");
            return;
        }
        try (BufferedReader reader = ((class_3298)instrumentsMeta.get()).method_43039();){
            isGlobalThemed = JsonParser.parseReader((Reader)reader).getAsJsonObject().get("is_global_pack").getAsBoolean();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (isGlobalThemed) {
            LOGGER.info("Instrument global themes enabled; loading all instrument resources from " + String.valueOf(GLOBAL_LOC));
        }
    }

    private void performReload(class_3300 resourceManager) {
        String logSuffix = " for " + String.valueOf(this.instrumentId);
        class_2960 styleLocation = this.getStylerLocation();
        try {
            if (CACHES.containsKey(styleLocation)) {
                JsonObject styleInfo = CACHES.get(styleLocation);
                for (Consumer<JsonObject> listener : this.listeners) {
                    listener.accept(styleInfo);
                }
                LOGGER.info("Loaded instrument style from already cached " + String.valueOf(styleLocation) + logSuffix);
                return;
            }
        }
        catch (Exception e) {
            LOGGER.error("Met an exception upon loading the instrument styler from " + String.valueOf(styleLocation) + logSuffix, (Throwable)e);
        }
        Optional styler = resourceManager.method_14486(styleLocation);
        if (styler.isEmpty()) {
            LOGGER.error("Could not retrieve styler information from " + String.valueOf(styleLocation) + "!");
            return;
        }
        try (BufferedReader reader = ((class_3298)styler.get()).method_43039();){
            JsonObject styleInfo = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            for (Consumer<JsonObject> listener : this.listeners) {
                listener.accept(styleInfo);
            }
            CACHES.put(styleLocation, styleInfo);
        }
        catch (Exception e) {
            LOGGER.error("Met an exception upon loading the instrument styler from " + String.valueOf(styleLocation) + logSuffix, (Throwable)e);
        }
        LOGGER.info("Loaded and cached instrument style from " + String.valueOf(styleLocation) + logSuffix);
    }

    public class_2960 getResourcesRootDir() {
        return this.resourcesRootDir;
    }

    public class_2960 getStylerLocation() {
        return (!this.ignoreGlobal && isGlobalThemed ? GLOBAL_LOC : this.getResourcesRootDir()).method_48331("/instrument_style.json");
    }

    public Color getRawLabelPressed() {
        return this.rawLabelPressed;
    }

    public Color getRawLabelReleased() {
        return this.rawLabelReleased;
    }

    public Color getRawNotePressed() {
        return this.rawNotePressed;
    }

    public Color getRawNoteReleased() {
        return this.rawNoteReleased;
    }

    public Color getRawNoteRing() {
        return this.rawNoteRing;
    }

    public Color labelPressed(NoteButton noteButton) {
        return this.rawLabelPressed;
    }

    public void setLabelPressed(Color labelPressed) {
        this.rawLabelPressed = labelPressed;
    }

    public Color labelReleased(NoteButton noteButton) {
        return this.rawLabelReleased;
    }

    public void setLabelReleased(Color labelReleased) {
        this.rawLabelReleased = labelReleased;
    }

    public Color notePressed(NoteButton noteButton) {
        return this.rawNotePressed;
    }

    public void setRawNotePressed(Color rawNotePressed) {
        this.rawNotePressed = rawNotePressed;
    }

    public Color noteReleased(NoteButton noteButton) {
        return this.rawNoteReleased;
    }

    public void setNoteReleased(Color noteReleased) {
        this.rawNoteReleased = noteReleased;
    }

    public Color noteRing(NoteButton noteButton) {
        return this.rawNoteRing;
    }

    public void setRawNoteRing(Color noteRingTheme) {
        this.rawNoteRing = noteRingTheme;
    }

    @Deprecated(forRemoval=true)
    public Color getNoteTheme(NoteButton noteButton) {
        return this.getColorTheme(noteButton, this.rawLabelReleased);
    }

    @Deprecated(forRemoval=true)
    public void setNoteTheme(Color noteTheme) {
        this.rawLabelReleased = noteTheme;
    }

    @Deprecated(forRemoval=true)
    public Color getPressedNoteTheme(NoteButton noteButton) {
        return this.getColorTheme(noteButton, this.rawNotePressed);
    }

    @Deprecated(forRemoval=true)
    public void setPressedNoteTheme(Color pressedNoteTheme) {
        this.rawNotePressed = pressedNoteTheme;
    }

    @Deprecated(forRemoval=true)
    public Color getLabelTheme(NoteButton noteButton) {
        return this.getColorTheme(noteButton, this.rawNoteReleased);
    }

    @Deprecated(forRemoval=true)
    public void setLabelTheme(Color labelTheme) {
        this.rawNoteReleased = labelTheme;
    }

    @Deprecated(forRemoval=true)
    public Color getNoteRingTheme(NoteButton noteButton) {
        return this.getColorTheme(noteButton, this.rawNoteRing);
    }

    @Deprecated(forRemoval=true)
    public void setNoteRingTheme(Color noteRingTheme) {
        this.rawNoteRing = noteRingTheme;
    }

    @Deprecated(forRemoval=true)
    protected Color getColorTheme(NoteButton noteButton, Color theme) {
        return this.getTheme(theme, Color.BLACK);
    }

    @Deprecated(forRemoval=true)
    protected <T> T getTheme(T theme, T def) {
        return theme == null ? def : theme;
    }

    static {
        InstrumentThemeLoader.subscribeResourcesReloadEvent();
        CACHES = new HashMap();
        LOADERS = new ArrayList();
        DEF_PRESSED_THEME = new Color(255, 249, 239);
    }
}

