/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.partial;

import com.cstav.genshinstrument.GInstrumentMod;
import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.gui.screen.instrument.GenshinConsentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentThemeLoader;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.label.NoteLabelSupplier;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.partial.AbstractInstrumentOptionsScreen;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.partial.InstrumentOptionsScreen;
import com.cstav.genshinstrument.client.gui.widget.IconToggleButton;
import com.cstav.genshinstrument.client.keyMaps.InstrumentKeyMappings;
import com.cstav.genshinstrument.client.midi.InstrumentMidiReceiver;
import com.cstav.genshinstrument.event.InstrumentPlayedEvent;
import com.cstav.genshinstrument.event.NoteSoundPlayedEvent;
import com.cstav.genshinstrument.networking.GIPacketHandler;
import com.cstav.genshinstrument.networking.buttonidentifier.NoteButtonIdentifier;
import com.cstav.genshinstrument.networking.packet.instrument.c2s.CloseInstrumentPacket;
import com.cstav.genshinstrument.sound.NoteSound;
import com.cstav.genshinstrument.util.InstrumentEntityData;
import com.mojang.logging.LogUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;

@Environment(value=EnvType.CLIENT)
public abstract class InstrumentScreen
extends class_437 {
    private static final int VISIBILITY_BUTTON_MARGIN = 6;
    private static final String VISIBILITY_SPRITE_LOC = "textures/gui/sprites/icon/visibility/";
    private int pitch;
    public int volume = (int)((Double)ModClientConfigs.VOLUME.get() * 100.0);
    private NoteLabelSupplier noteLabelSupplier;
    public final InstrumentMidiReceiver midiReceiver;
    public final InstrumentOptionsScreen optionsScreen = this.initInstrumentOptionsScreen();
    protected IconToggleButton visibilityButton;
    private boolean pitchChanged;
    private boolean isOptionsScreenActive;
    private boolean closed = false;

    public int getNoteSize() {
        return switch ((Integer)class_310.method_1551().field_1690.method_42474().method_41753()) {
            case 1 -> 36;
            case 2 -> 46;
            case 3 -> 48;
            case 4 -> 40;
            case 5 -> 35;
            case 6 -> 30;
            default -> 35;
        };
    }

    public int getPitch() {
        return this.pitch;
    }

    public void setPitch(int pitch) {
        this.pitch = NoteSound.clampPitch(pitch);
        this.notesIterable().forEach(note -> note.setPitch(this.pitch));
    }

    protected void initPitch(Consumer<Integer> pitchConsumer) {
        pitchConsumer.accept((Integer)ModClientConfigs.PITCH.get());
    }

    public void resetPitch() {
        this.initPitch(this::setPitch);
    }

    public float volume() {
        return (float)this.volume / 100.0f;
    }

    public void setVolume(float volume) {
        this.volume = (int)(volume * 100.0f);
    }

    public void setNoteSounds(NoteSound[] sounds) {
        Iterator<NoteButton> noteIterator = this.notesIterable().iterator();
        int i = 0;
        while (noteIterator.hasNext() && i < sounds.length) {
            noteIterator.next().setSound(sounds[i++]);
        }
        if (noteIterator.hasNext() || i < sounds.length) {
            LogUtils.getLogger().warn("Not all sounds were set for instrument " + String.valueOf(this.getInstrumentId()) + "!");
        }
    }

    public void setLabelSupplier(NoteLabelSupplier supplier) {
        this.noteLabelSupplier = supplier;
        this.notesIterable().forEach(note -> note.setLabelSupplier(supplier));
    }

    public NoteLabelSupplier getNoteLabelSupplier() {
        return this.noteLabelSupplier;
    }

    public abstract InstrumentThemeLoader getThemeLoader();

    public abstract class_2960 getInstrumentId();

    protected abstract InstrumentOptionsScreen initInstrumentOptionsScreen();

    public String[] noteLayout() {
        return null;
    }

    public void handleAbruptClosing() {
        if (!InstrumentEntityData.isOpen((class_1657)this.field_22787.field_1724)) {
            this.onClose(false);
        }
    }

    public boolean isGenshinInstrument() {
        return true;
    }

    public InstrumentMidiReceiver initMidiReceiver() {
        return null;
    }

    public boolean isMidiInstrument() {
        return this.midiReceiver != null;
    }

    public NoteButton getNoteButton(Optional<NoteButtonIdentifier> noteIdentifier, NoteSound noteSound, int pitch) throws NoSuchElementException {
        if (noteIdentifier.isEmpty()) {
            return this.getNoteButton(noteSound, pitch);
        }
        return this.getNoteButton(noteIdentifier.get());
    }

    public NoteButton getNoteButton(NoteButtonIdentifier noteIdentifier) {
        for (NoteButton note : this.notesIterable()) {
            if (!noteIdentifier.matches(note)) continue;
            return note;
        }
        throw new NoSuchElementException("Could not find a note in " + String.valueOf(this.getInstrumentId()) + " based on the given identifier");
    }

    public NoteButton getNoteButton(NoteSound noteSound, int pitch) {
        for (NoteButton note : this.notesIterable()) {
            NoteSound sound = note.getSound();
            if (!noteSound.equals(sound) || this.identifyByPitch() && note.getPitch() != pitch) continue;
            return note;
        }
        throw new NoSuchElementException("Could not find a note in " + String.valueOf(this.getInstrumentId()) + " based on the given identifier");
    }

    protected boolean identifyByPitch() {
        return false;
    }

    public abstract Map<class_3675.class_306, NoteButton> noteMap();

    public Iterable<NoteButton> notesIterable() {
        return this.noteMap().values();
    }

    public static String getGlobalRootPath() {
        return "textures/gui/genshinstrument/";
    }

    public class_2960 getResourceFromGlob(String path) {
        return this.getSourcePath().method_45136(InstrumentScreen.getGlobalRootPath() + "instrument/" + path);
    }

    public static class_2960 getInternalResourceFromGlob(String path) {
        return GInstrumentMod.loc(InstrumentScreen.getGlobalRootPath() + path);
    }

    public static class_2960 getInstrumentRootPath(class_2960 instrumentId) {
        return instrumentId.method_45136(InstrumentScreen.getGlobalRootPath() + "instrument/" + instrumentId.method_12832());
    }

    protected String getPath() {
        return InstrumentScreen.getGlobalRootPath() + "instrument/" + this.getSourcePath().method_12832() + "/";
    }

    public class_2960 getSourcePath() {
        return this.getThemeLoader().subjectInstrumentId;
    }

    public String getModId() {
        return this.getInstrumentId().method_12836();
    }

    public class_2960 getResourceFromRoot(String path, boolean considerGlobal) {
        return considerGlobal && InstrumentThemeLoader.isGlobalThemed() ? InstrumentThemeLoader.GLOBAL_LOC.method_48331("/" + path) : this.getSourcePath().method_45136(this.getPath() + path);
    }

    public class_2960 getResourceFromRoot(String path) {
        return this.getResourceFromRoot(path, true);
    }

    public InstrumentScreen() {
        super(class_5244.field_39003);
        this.midiReceiver = this.initMidiReceiver();
    }

    protected void method_25426() {
        this.resetPitch();
        this.optionsScreen.method_25423(this.field_22787, this.field_22789, this.field_22790);
        boolean wasEnabled = false;
        if (this.visibilityButton != null) {
            wasEnabled = this.visibilityButton.enabled();
        }
        this.visibilityButton = this.initVisibilityButton();
        this.method_37063((class_364)this.visibilityButton);
        this.visibilityButton.setEnabled(wasEnabled);
        if (this.isGenshinInstrument() && !((Boolean)ModClientConfigs.ACCEPTED_GENSHIN_CONSENT.get()).booleanValue()) {
            this.field_22787.method_1507((class_437)new GenshinConsentScreen(this));
        }
    }

    protected class_4185 initOptionsButton(int vertOffset) {
        class_4185 button = class_4185.method_46430((class_2561)class_2561.method_43471((String)"button.genshinstrument.instrumentOptions").method_27693("..."), btn -> this.onOptionsOpen()).method_46432(150).method_46431();
        button.method_48229((this.field_22789 - button.method_25368()) / 2, vertOffset - button.method_25364() / 2);
        this.method_37063((class_364)button);
        return button;
    }

    protected IconToggleButton initVisibilityButton() {
        return new IconToggleButton(6, 6, GInstrumentMod.loc("textures/gui/sprites/icon/visibility/enabled.png"), GInstrumentMod.loc("textures/gui/sprites/icon/visibility/disabled.png"), btn -> this.onInstrumentRenderStateChanged(this.instrumentRenders()));
    }

    public void foreignPlay(InstrumentPlayedEvent.InstrumentPlayedEventArgs<?> event) {
        if (!(event instanceof NoteSoundPlayedEvent.NoteSoundPlayedEventArgs)) {
            return;
        }
        NoteSoundPlayedEvent.NoteSoundPlayedEventArgs e = (NoteSoundPlayedEvent.NoteSoundPlayedEventArgs)event;
        try {
            this.getNoteButton(event.soundMeta().noteIdentifier(), (NoteSound)e.sound(), event.soundMeta().pitch()).playNoteAnimation(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean instrumentRenders() {
        return !this.visibilityButton.enabled();
    }

    protected void onInstrumentRenderStateChanged(boolean isVisible) {
        if (!isVisible) {
            this.notesIterable().forEach(note -> note.getRenderer().resetAnimations());
        }
        this.method_25396().forEach(renderable -> {
            if (renderable instanceof class_339) {
                class_339 widget = (class_339)renderable;
                widget.field_22763 = isVisible;
            }
        });
        this.visibilityButton.field_22763 = true;
    }

    public void method_25394(class_332 pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (!this.instrumentRenders()) {
            this.visibilityButton.method_25394(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
            return;
        }
        this.renderInstrument(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    public void renderInstrument(class_332 pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        for (class_4068 renderable : Screens.getButtons((class_437)this)) {
            renderable.method_25394(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        }
    }

    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.checkPitchTransposeUp(pKeyCode, pScanCode)) {
            return true;
        }
        NoteButton note = this.getNoteByKey(pKeyCode);
        if (note != null) {
            note.play();
            return true;
        }
        return super.method_25404(pKeyCode, pScanCode, pModifiers);
    }

    public boolean method_16803(int pKeyCode, int pScanCode, int pModifiers) {
        class_364 class_3642;
        if (this.checkTransposeDown(pKeyCode, pScanCode)) {
            return true;
        }
        if (this.method_25370() && (class_3642 = this.method_25399()) instanceof NoteButton) {
            NoteButton btn = (NoteButton)class_3642;
            btn.release();
        }
        if (!this.isKeyConsumed(pKeyCode, pScanCode)) {
            return false;
        }
        this.unlockFocused();
        NoteButton note = this.getNoteByKey(pKeyCode);
        if (note != null) {
            note.release();
        }
        return super.method_16803(pKeyCode, pScanCode, pModifiers);
    }

    protected boolean checkPitchTransposeUp(int pKeyCode, int pScanCode) {
        if (this.pitchChanged) {
            return false;
        }
        if (this.checkTransposeUpKey(pKeyCode, pScanCode)) {
            this.transposeUp();
            return true;
        }
        if (this.checkTransposeDownKey(pKeyCode, pScanCode)) {
            this.transposeDown();
            return true;
        }
        return false;
    }

    protected boolean checkTransposeDown(int pKeyCode, int pScanCode) {
        if (!this.pitchChanged) {
            return false;
        }
        if (this.checkTransposeUpKey(pKeyCode, pScanCode) || this.checkTransposeDownKey(pKeyCode, pScanCode)) {
            this.resetTransposition();
            return true;
        }
        return false;
    }

    public void transposeUp() {
        this.setPitch(this.getPitch() + 1);
        this.pitchChanged = true;
    }

    public void transposeDown() {
        this.setPitch(this.getPitch() - 1);
        this.pitchChanged = true;
    }

    public void resetTransposition() {
        this.resetPitch();
        this.pitchChanged = false;
    }

    public boolean isTransposed() {
        return this.pitchChanged;
    }

    public boolean isKeyConsumed(int keyCode, int scanCode) {
        return this.getNoteByKey(keyCode) != null || this.checkTransposeDownKey(keyCode, scanCode) || this.checkTransposeUpKey(keyCode, scanCode);
    }

    protected boolean checkTransposeDownKey(int keyCode, int scanCode) {
        return InstrumentKeyMappings.TRANSPOSE_DOWN_MODIFIER.method_1417(keyCode, scanCode);
    }

    protected boolean checkTransposeUpKey(int keyCode, int scanCode) {
        return InstrumentKeyMappings.TRANSPOSE_UP_MODIFIER.method_1417(keyCode, scanCode);
    }

    public boolean method_25406(double pMouseX, double pMouseY, int pButton) {
        this.unlockFocused();
        return super.method_25406(pMouseX, pMouseY, pButton);
    }

    public NoteButton getNoteByKey(int keyCode) {
        class_3675.class_306 key = class_3675.class_307.field_1668.method_1447(keyCode);
        return this.noteMap().getOrDefault(key, null);
    }

    private void unlockFocused() {
        if (this.method_25399() != null && this.method_25399() instanceof NoteButton) {
            ((NoteButton)this.method_25399()).release();
            this.method_25395(null);
        }
    }

    public boolean isOptionsScreenActive() {
        return this.isOptionsScreenActive;
    }

    public void onOptionsOpen() {
        this.isOptionsScreenActive = true;
        this.method_25395(null);
        this.field_22787.method_1507((class_437)this.optionsScreen);
        this.resetPitch();
    }

    public void onOptionsClose() {
        this.isOptionsScreenActive = false;
        this.field_22787.method_1507((class_437)this);
    }

    public final void method_25419() {
        this.onClose(true);
    }

    public void onClose(boolean notify) {
        if (!this.closed) {
            if (notify) {
                this.notifyClosed();
            }
            if (this.isOptionsScreenActive) {
                this.optionsScreen.method_25419();
            }
            this.closed = true;
        }
        super.method_25419();
    }

    public void method_25432() {
        if (this.isOptionsScreenActive) {
            return;
        }
        if (!this.closed) {
            this.notifyClosed();
            this.closed = true;
        }
        super.method_25432();
    }

    private void notifyClosed() {
        InstrumentEntityData.setClosed((class_1657)this.field_22787.field_1724);
        GIPacketHandler.sendToServer(CloseInstrumentPacket.INSTANCE);
    }

    public static Optional<InstrumentScreen> getCurrentScreen(class_310 minecraft) {
        if (minecraft.field_1755 instanceof InstrumentScreen) {
            return Optional.of((InstrumentScreen)minecraft.field_1755);
        }
        class_437 class_4372 = minecraft.field_1755;
        if (class_4372 instanceof AbstractInstrumentOptionsScreen) {
            AbstractInstrumentOptionsScreen instrumentOptionsScreen = (AbstractInstrumentOptionsScreen)class_4372;
            return instrumentOptionsScreen.instrumentScreen;
        }
        return Optional.empty();
    }

    public static Optional<InstrumentScreen> getCurrentScreen() {
        return InstrumentScreen.getCurrentScreen(class_310.method_1551());
    }

    public boolean method_25421() {
        return false;
    }
}

