/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui.misc;

import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.NordTheme;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.PanelScrollBar;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.apache.commons.lang3.tuple.Pair;

public class KeyReferenceScreen
extends BaseScreen {
    private static final int SCROLLBAR_WIDTH = 16;
    private static final int GUTTER_SIZE = 2;
    private final Panel textPanel;
    private final PanelScrollBar scrollBar;
    private final SimpleTextButton closeButton;
    private final String[] translationKeys;

    public KeyReferenceScreen(String ... translationKeys) {
        this.translationKeys = translationKeys;
        this.textPanel = new TextPanel(this);
        this.closeButton = new SimpleTextButton(this, (class_2561)class_2561.method_43471((String)"gui.close"), Icons.CANCEL){

            @Override
            public void onClicked(MouseButton button) {
                KeyReferenceScreen.this.onBack();
            }
        };
        this.scrollBar = new PanelScrollBar(this, this.textPanel);
    }

    private static List<Pair<class_2561, class_2561>> buildText(String ... translationKeys) {
        ArrayList<Pair<class_2561, class_2561>> res = new ArrayList<Pair<class_2561, class_2561>>();
        for (String translationKey : translationKeys) {
            block5: for (String line : class_1074.method_4662((String)translationKey, (Object[])new Object[0]).split("\\n")) {
                String[] parts = line.split(";", 2);
                switch (parts.length) {
                    case 0: {
                        res.add((Pair<class_2561, class_2561>)Pair.of((Object)class_2561.method_43473(), (Object)class_2561.method_43473()));
                        continue block5;
                    }
                    case 1: {
                        res.add((Pair<class_2561, class_2561>)Pair.of((Object)class_2561.method_43470((String)parts[0]).method_27695(new class_124[]{class_124.field_1054, class_124.field_1073}), (Object)class_2561.method_43473()));
                        continue block5;
                    }
                    default: {
                        res.add((Pair<class_2561, class_2561>)Pair.of((Object)class_2561.method_43470((String)parts[0]), (Object)class_2561.method_43470((String)parts[1]).method_27692(class_124.field_1080)));
                    }
                }
            }
            res.add((Pair<class_2561, class_2561>)Pair.of((Object)class_2561.method_43473(), (Object)class_2561.method_43473()));
        }
        return res;
    }

    @Override
    public boolean onInit() {
        return this.setSizeProportional(0.75f, 0.8f);
    }

    @Override
    public Theme getTheme() {
        return NordTheme.THEME;
    }

    @Override
    public void addWidgets() {
        this.add(this.textPanel);
        this.add(this.scrollBar);
        this.add(this.closeButton);
    }

    @Override
    public void alignWidgets() {
        int textPanelWidth = this.getGui().width - 6 - 16;
        this.textPanel.setPosAndSize(2, 2, textPanelWidth, this.getGui().height - 4);
        this.textPanel.alignWidgets();
        this.scrollBar.setPosAndSize(this.getGui().width - 2 - 16, this.textPanel.getPosY(), 16, this.textPanel.getHeight());
        this.closeButton.setPosAndSize(this.width + 2, 0, 20, 20);
    }

    @Override
    public class_2561 getTitle() {
        return class_2561.method_43471((String)"ftblibrary.gui.key_reference");
    }

    @Override
    public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        theme.drawGui(graphics, x, y, w, h, WidgetType.NORMAL);
        int w1 = theme.getStringWidth((class_5348)this.getTitle());
        theme.drawString(graphics, this.getTitle(), x + (w - w1) / 2, y - theme.getFontHeight() - 1, Color4I.rgb(65535), 2);
    }

    protected void drawTextBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        theme.drawPanelBackground(graphics, x, y, w, h);
    }

    private class TextPanel
    extends Panel {
        private final TwoColumnList textWidget;

        public TextPanel(Panel panel) {
            super(panel);
            this.textWidget = new TwoColumnList(this, KeyReferenceScreen.buildText(KeyReferenceScreen.this.translationKeys));
        }

        @Override
        public void addWidgets() {
            this.add(this.textWidget);
        }

        @Override
        public void alignWidgets() {
            this.align(WidgetLayout.VERTICAL);
            this.textWidget.setPos(4, 2);
            this.textWidget.setWidth(this.width);
        }

        @Override
        public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            KeyReferenceScreen.this.drawTextBackground(graphics, theme, x, y, w, h);
        }
    }

    private static class TwoColumnList
    extends Widget {
        private final int widestL;
        private final List<Pair<class_2561, class_2561>> data;
        private final List<Pair<class_2561, class_5481>> reflowed = new ArrayList<Pair<class_2561, class_5481>>();

        public TwoColumnList(Panel p, List<Pair<class_2561, class_2561>> data) {
            super(p);
            this.data = data;
            this.widestL = data.stream().map(e -> this.getGui().getTheme().getStringWidth((class_5348)e.getLeft())).max(Integer::compareTo).orElse(0);
        }

        @Override
        public void setWidth(int v) {
            super.setWidth(v);
            this.reflowText();
        }

        private void reflowText() {
            Theme theme = this.getGui().getTheme();
            int h = 0;
            int maxWidth = this.getParent().getWidth() - 4;
            this.reflowed.clear();
            for (Pair<class_2561, class_2561> entry : this.data) {
                if (((class_2561)entry.getRight()).getString().isEmpty()) {
                    this.reflowed.add((Pair<class_2561, class_5481>)Pair.of((Object)((class_2561)entry.getLeft()), null));
                    h += theme.getFontHeight() + 3;
                    continue;
                }
                List l = theme.getFont().method_1728((class_5348)entry.getRight(), maxWidth - 10 - this.widestL);
                if (l.isEmpty()) continue;
                this.reflowed.add((Pair<class_2561, class_5481>)Pair.of((Object)((class_2561)entry.getLeft()), (Object)((class_5481)l.get(0))));
                for (int i = 1; i < l.size(); ++i) {
                    this.reflowed.add((Pair<class_2561, class_5481>)Pair.of((Object)class_2561.method_43473(), (Object)((class_5481)l.get(i))));
                }
                h += (theme.getFontHeight() + 1) * l.size();
            }
            this.height = h;
        }

        @Override
        public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            int yPos = y;
            for (Pair<class_2561, class_5481> entry : this.reflowed) {
                boolean header = entry.getRight() == null;
                int leftWidth = theme.getStringWidth((class_5348)entry.getLeft());
                int xOff = header ? (this.width - leftWidth) / 2 : this.widestL - leftWidth - 2;
                theme.drawString(graphics, entry.getLeft(), x + xOff, yPos);
                if (!header) {
                    theme.drawString(graphics, entry.getRight(), x + this.widestL + 10, yPos);
                }
                yPos += theme.getFontHeight() + (header ? 3 : 1);
            }
        }
    }
}

