/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.snbt;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.util.function.BooleanSupplier;
import net.minecraft.class_156;

public class SNBTUtils {
    public static final BooleanSupplier ALWAYS_TRUE = () -> true;
    public static final char[] ESCAPE_CHARS = (char[])class_156.method_654((Object)new char[128], array -> {
        array[34] = 34;
        array[92] = 92;
        array[9] = 116;
        array[8] = 98;
        array[10] = 110;
        array[13] = 114;
        array[12] = 102;
    });
    public static final char[] REVERSE_ESCAPE_CHARS = (char[])class_156.method_654((Object)new char[128], array -> {
        for (int i = 0; i < ((char[])array).length; ++i) {
            if (ESCAPE_CHARS[i] == '\u0000') continue;
            array[SNBTUtils.ESCAPE_CHARS[i]] = (char)i;
        }
    });

    public static boolean isSimpleCharacter(char c) {
        return Character.isAlphabetic(c) || Character.isDigit(c) || c == '.' || c == '_' || c == '-' || c == '+' || c == '\u221e';
    }

    public static boolean isSimpleString(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (SNBTUtils.isSimpleCharacter(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int getNumberType(String s) {
        if (s.isEmpty()) {
            return 8;
        }
        char last = Character.toLowerCase(s.charAt(s.length() - 1));
        if (Character.isDigit(last) && Ints.tryParse((String)s) != null) {
            return 3;
        }
        String start = s.substring(0, s.length() - 1);
        if (last == 'b' && Ints.tryParse((String)start) != null) {
            return 1;
        }
        if (last == 's' && Ints.tryParse((String)start) != null) {
            return 2;
        }
        if (last == 'l' && Longs.tryParse((String)start) != null) {
            return 4;
        }
        if (last == 'f' && Floats.tryParse((String)start) != null) {
            return 5;
        }
        if (last == 'd' && Doubles.tryParse((String)start) != null) {
            return 6;
        }
        if (Floats.tryParse((String)s) != null) {
            return -6;
        }
        return 8;
    }

    public static String handleEscape(String string) {
        return SNBTUtils.isSimpleString(string) ? string : SNBTUtils.quoteAndEscape(string);
    }

    public static String quoteAndEscape(String string) {
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 2);
        sb.append('\"');
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (c < ESCAPE_CHARS.length && ESCAPE_CHARS[c] != '\u0000') {
                sb.append('\\');
                sb.append(ESCAPE_CHARS[c]);
                continue;
            }
            sb.append(c);
        }
        sb.append('\"');
        return sb.toString();
    }
}

