/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.sidebar;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.api.sidebar.SidebarButtonCreatedEvent;
import dev.ftb.mods.ftblibrary.config.FTBLibraryClientConfig;
import dev.ftb.mods.ftblibrary.sidebar.GridLocation;
import dev.ftb.mods.ftblibrary.sidebar.RegisteredSidebarButton;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButtonData;
import dev.ftb.mods.ftblibrary.sidebar.SidebarGuiButton;
import dev.ftb.mods.ftblibrary.snbt.config.StringSidebarMapValue;
import dev.ftb.mods.ftblibrary.util.MapUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;

public class SidebarButtonManager
extends class_4309 {
    public static final SidebarButtonManager INSTANCE = new SidebarButtonManager();
    private final Map<class_2960, RegisteredSidebarButton> buttons = new HashMap<class_2960, RegisteredSidebarButton>();
    private final List<SidebarGuiButton> buttonList = new ArrayList<SidebarGuiButton>();

    public SidebarButtonManager() {
        super(new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create(), "sidebar_buttons");
    }

    protected void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profilerFiller) {
        this.buttons.clear();
        this.loadResources(object, SidebarButtonData.CODEC, (id, buttonData) -> this.buttons.put((class_2960)id, new RegisteredSidebarButton((class_2960)id, (SidebarButtonData)buttonData)));
        this.buttonList.clear();
        List<RegisteredSidebarButton> sortedButtons = this.buttons.values().stream().sorted(Comparator.comparingInt(value -> value.getData().sortIndex())).toList();
        int y = 0;
        int x = 0;
        Map buttonConfig = (Map)FTBLibraryClientConfig.SIDEBAR_BUTTONS.get();
        Map prevConfig = Map.copyOf(buttonConfig);
        for (RegisteredSidebarButton buttonEntry : sortedButtons) {
            StringSidebarMapValue.SideButtonInfo buttonSettings = (StringSidebarMapValue.SideButtonInfo)buttonConfig.get(buttonEntry.getId().toString());
            if (buttonSettings == null) {
                buttonSettings = new StringSidebarMapValue.SideButtonInfo(true, x, y);
                buttonConfig.put(buttonEntry.getId().toString(), buttonSettings);
            }
            this.buttonList.add(new SidebarGuiButton(new GridLocation(buttonSettings.xPos(), buttonSettings.yPos()), buttonSettings.enabled(), buttonEntry));
            if (++x < 4) continue;
            x = 0;
            ++y;
        }
        for (RegisteredSidebarButton value2 : this.buttons.values()) {
            ((Consumer)SidebarButtonCreatedEvent.EVENT.invoker()).accept(new SidebarButtonCreatedEvent(value2));
        }
        if (!prevConfig.equals(buttonConfig)) {
            FTBLibraryClientConfig.save();
        }
    }

    private <T> void loadResources(Map<class_2960, JsonElement> objects, Codec<T> codec, BiConsumer<class_2960, T> consumer) {
        for (Map.Entry<class_2960, JsonElement> resource : objects.entrySet()) {
            codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)resource.getValue()).resultOrPartial(err -> FTBLibrary.LOGGER.error("Failed to parse json: {}", err)).ifPresent(result -> {
                class_2960 key = (class_2960)resource.getKey();
                class_2960 fixed = class_2960.method_60655((String)key.method_12836(), (String)key.method_12832());
                consumer.accept(fixed, result);
            });
        }
    }

    public void saveConfigFromButtonList() {
        int y;
        Int2ObjectOpenHashMap buttonMap = new Int2ObjectOpenHashMap();
        for (SidebarGuiButton button2 : this.getButtonList()) {
            y = button2.isEnabled() ? button2.getGridLocation().y() : -1;
            ((List)buttonMap.computeIfAbsent(y, k -> new LinkedList())).add(button2);
        }
        Map sidebarConfig = (Map)FTBLibraryClientConfig.SIDEBAR_BUTTONS.get();
        Map prevConfig = Map.copyOf(sidebarConfig);
        y = 0;
        for (Map.Entry buttonsByYpos : MapUtils.sortMapByKey(buttonMap).entrySet()) {
            if ((Integer)buttonsByYpos.getKey() == -1) {
                for (SidebarGuiButton button3 : (List)buttonsByYpos.getValue()) {
                    button3.setGridLocation(-1, -1);
                    sidebarConfig.put(button3.toString(), StringSidebarMapValue.SideButtonInfo.DISABLED);
                }
            }
            int x = 0;
            ((List)buttonsByYpos.getValue()).sort(Comparator.comparingInt(button -> button.getGridLocation().x()));
            for (SidebarGuiButton sidebarButton : (List)buttonsByYpos.getValue()) {
                if (!sidebarButton.isEnabled()) continue;
                sidebarButton.setGridLocation(x, y);
                sidebarConfig.put(sidebarButton.toString(), StringSidebarMapValue.SideButtonInfo.at(x, y));
                ++x;
            }
            if (x <= 0) continue;
            ++y;
        }
        for (SidebarGuiButton button4 : this.buttonList) {
            StringSidebarMapValue.SideButtonInfo buttonSettings = (StringSidebarMapValue.SideButtonInfo)sidebarConfig.get(button4.toString());
            if (buttonSettings == null) continue;
            sidebarConfig.put(button4.toString(), StringSidebarMapValue.SideButtonInfo.ofButton(button4));
        }
        if (!sidebarConfig.equals(prevConfig)) {
            FTBLibraryClientConfig.save();
        }
    }

    public List<SidebarGuiButton> getButtonList() {
        return this.buttonList;
    }

    public List<SidebarGuiButton> getEnabledButtonList(boolean all) {
        return this.buttonList.stream().filter(SidebarGuiButton::isEnabled).filter(button -> all || button.getSidebarButton().canSee()).toList();
    }

    public List<SidebarGuiButton> getDisabledButtonList(boolean all) {
        return this.buttonList.stream().filter(button -> !button.isEnabled()).filter(button -> all || button.getSidebarButton().canSee()).collect(Collectors.toList());
    }

    public Collection<RegisteredSidebarButton> getButtons() {
        return this.buttons.values();
    }

    public Optional<RegisteredSidebarButton> getButton(class_2960 id) {
        return Optional.ofNullable(this.buttons.get(id));
    }
}

