/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.icon;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.registry.registries.RegistrarManager;
import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.icon.EntityImageIcon;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.util.ModUtils;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1569;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.slf4j.Logger;

public class EntityIconLoader
extends class_4080<Map<class_1299<?>, EntityIconSettings>> {
    public static final Icon NORMAL = Icon.getIcon("ftblibrary:textures/faces/normal.png");
    public static final Icon HOSTILE = Icon.getIcon("ftblibrary:textures/faces/hostile.png");
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<class_1299<?>, Map<class_2960, Icon>> ICON_CACHE = new HashMap();
    private static final Map<class_1299<?>, EntityIconSettings> ENTITY_SETTINGS = new HashMap();
    private static final Set<class_1299<?>> DYNAMIC_JSON_TEXTURES = new HashSet();

    protected Map<class_1299<?>, EntityIconSettings> prepare(class_3300 resourceManager, class_3695 profiler) {
        HashMap map = new HashMap();
        DYNAMIC_JSON_TEXTURES.clear();
        for (Map.Entry entry : RegistrarManager.get((String)"ftblibrary").get(class_7924.field_41266).entrySet()) {
            Optional resource;
            class_2960 id = ((class_5321)entry.getKey()).method_29177();
            class_1299 entityType = (class_1299)entry.getValue();
            String basePath = EntityIconLoader.getBasePath(id);
            class_2960 invisible = FTBLibrary.rl(basePath + ".invisible");
            EntityIconSettings entityIconSettings = null;
            if (resourceManager.method_14486(invisible).isPresent()) {
                LOGGER.error("Entity {} is using legacy invisible texture, please update it to use the new system!", (Object)id);
                entityIconSettings = EntityIconSettings.OLD_HIDDEN;
            }
            if ((resource = resourceManager.method_14486(FTBLibrary.rl(basePath + ".json"))).isPresent()) {
                entityIconSettings = this.loadEntitySetting(id, (class_3298)resource.get());
                DYNAMIC_JSON_TEXTURES.add(entityType);
            } else {
                class_2960 imgLoc = FTBLibrary.rl(basePath + ".png");
                if (resourceManager.method_14486(imgLoc).isPresent()) {
                    entityIconSettings = EntityIconSettings.forImage(imgLoc);
                }
            }
            if (entityIconSettings == null && entityType.method_5891() != class_1311.field_17715) {
                if (ModUtils.isDevMode()) {
                    LOGGER.error("Missing entity icon settings for {}", (Object)id);
                }
                entityIconSettings = EntityIconSettings.legacy();
            }
            map.put(entityType, entityIconSettings);
        }
        return map;
    }

    protected void apply(Map<class_1299<?>, EntityIconSettings> entityIconDataMap, class_3300 resourceManager, class_3695 profiler) {
        ICON_CACHE.clear();
        ENTITY_SETTINGS.clear();
        ENTITY_SETTINGS.putAll(entityIconDataMap);
        FTBLibrary.LOGGER.debug("loaded {} entity face icons ({} using dynamic json textures)", (Object)entityIconDataMap.size(), (Object)DYNAMIC_JSON_TEXTURES.size());
    }

    public static boolean isDynamicTexture(class_1299<?> type) {
        return DYNAMIC_JSON_TEXTURES.contains(type);
    }

    private static String getBasePath(class_2960 id) {
        return "textures/faces/" + id.method_12836() + "/" + id.method_12832();
    }

    private EntityIconSettings loadEntitySetting(class_2960 id, class_3298 resource) {
        try {
            JsonElement jsonElement = (JsonElement)class_3518.method_15276((Gson)GSON, (Reader)resource.method_43039(), JsonElement.class);
            DataResult settings = EntityIconSettings.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement);
            return (EntityIconSettings)settings.getOrThrow();
        }
        catch (IOException e) {
            LOGGER.error("Failed to load entity icon settings for {}", (Object)id, (Object)e);
        }
        catch (IllegalStateException e) {
            LOGGER.error("Failed to parse entity icon settings for {}", (Object)id, (Object)e);
        }
        return null;
    }

    private static Optional<Icon> getIconCache(class_1297 entity) {
        return EntityIconLoader.getSettings(entity.method_5864()).map(settings -> settings.useMobTexture ? EntityIconLoader.getOrCreateIcon(entity.method_5864(), class_310.method_1551().method_1561().method_3953(entity).method_3931(entity), settings) : (Icon)settings.texture.map(resourceLocation -> EntityIconLoader.getOrCreateIcon(entity.method_5864(), resourceLocation, settings)).orElse(null));
    }

    public static Optional<EntityIconSettings> getSettings(class_1299<?> entityType) {
        return Optional.ofNullable(ENTITY_SETTINGS.get(entityType));
    }

    private static Icon getOrCreateIcon(class_1299<?> entityType, class_2960 texture, EntityIconSettings settings) {
        return ICON_CACHE.computeIfAbsent(entityType, i -> new HashMap()).computeIfAbsent(texture, t -> new EntityImageIcon((class_2960)t, settings.mainSlice.orElse(null), settings.children, settings.defaultImageSize.orElse(null)));
    }

    public static Icon getIcon(class_1297 entity) {
        return EntityIconLoader.getIconCache(entity).orElseGet(() -> entity instanceof class_1569 ? HOSTILE : NORMAL);
    }

    public static Icon getIcon(class_1299<?> entityType) {
        class_1297 entity = entityType.method_5883((class_1937)class_310.method_1551().field_1687);
        return entity == null ? NORMAL : EntityIconLoader.getIcon(entity);
    }

    public record EntityIconSettings(boolean useMobTexture, Optional<class_2960> texture, Optional<EntityImageIcon.Slice> mainSlice, List<EntityImageIcon.ChildIconData> children, WidthHeight widthHeight, Optional<WidthHeight> defaultImageSize, double scale, boolean defaultEnabled) {
        private static final EntityIconSettings OLD_HIDDEN = new EntityIconSettings(false, Optional.empty(), Optional.empty(), List.of(), WidthHeight.DEFAULT, Optional.empty(), 1.0, true);
        public static final Codec<EntityIconSettings> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.optionalFieldOf("use_mob_texture", (Object)false).forGetter(s -> s.useMobTexture), (App)class_2960.field_25139.optionalFieldOf("texture").forGetter(s -> s.texture), (App)EntityImageIcon.Slice.CODEC.optionalFieldOf("slice").forGetter(entityIconData -> entityIconData.mainSlice), (App)EntityImageIcon.ChildIconData.CODEC.listOf().optionalFieldOf("children", List.of()).forGetter(entityIconData -> entityIconData.children), (App)WidthHeight.CODEC.optionalFieldOf("size", (Object)WidthHeight.DEFAULT).forGetter(s -> s.widthHeight), (App)WidthHeight.CODEC.optionalFieldOf("default_image_size").forGetter(s -> s.defaultImageSize), (App)Codec.DOUBLE.optionalFieldOf("scale", (Object)1.0).forGetter(s -> s.scale), (App)Codec.BOOL.optionalFieldOf("default_enabled", (Object)true).forGetter(s -> s.defaultEnabled)).apply((Applicative)builder, EntityIconSettings::new)).validate(settings -> settings.texture().isEmpty() && !settings.useMobTexture ? DataResult.error(() -> "Texture is required if use_mob_texture is false") : DataResult.success((Object)settings));

        public static EntityIconSettings forImage(class_2960 imgLoc) {
            return new EntityIconSettings(false, Optional.of(imgLoc), Optional.empty(), List.of(), WidthHeight.DEFAULT, Optional.empty(), 1.0, true);
        }

        public static EntityIconSettings legacy() {
            return OLD_HIDDEN;
        }
    }

    public record WidthHeight(int width, int height) {
        public static final WidthHeight DEFAULT = new WidthHeight(16, 16);
        public static final Codec<WidthHeight> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("width").forGetter(WidthHeight::width), (App)Codec.INT.fieldOf("height").forGetter(WidthHeight::height)).apply((Applicative)instance, WidthHeight::new));
    }
}

