/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui.resource;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import dev.architectury.registry.registries.RegistrarManager;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.FTBLibraryClientConfig;
import dev.ftb.mods.ftblibrary.config.FluidConfig;
import dev.ftb.mods.ftblibrary.config.ui.resource.ResourceSearchMode;
import dev.ftb.mods.ftblibrary.config.ui.resource.ResourceSelectorScreen;
import dev.ftb.mods.ftblibrary.config.ui.resource.SearchModeIndex;
import dev.ftb.mods.ftblibrary.config.ui.resource.SelectableResource;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.util.ModUtils;
import dev.ftb.mods.ftblibrary.util.SearchTerms;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public class SelectFluidScreen
extends ResourceSelectorScreen<FluidStack> {
    private static final SearchModeIndex<ResourceSearchMode<FluidStack>> KNOWN_MODES = (SearchModeIndex)class_156.method_654(new SearchModeIndex(), idx -> idx.appendMode(ResourceSearchMode.ALL_FLUIDS));

    public SelectFluidScreen(FluidConfig config, ConfigCallback callback) {
        super(config, callback);
    }

    @Override
    protected int defaultQuantity() {
        return (int)FluidStackHooks.bucketAmount();
    }

    @Override
    protected SearchModeIndex<ResourceSearchMode<FluidStack>> getSearchModeIndex() {
        return KNOWN_MODES;
    }

    @Override
    protected ResourceSelectorScreen.ResourceButton makeResourceButton(Panel panel, SelectableResource<FluidStack> resource) {
        return new FluidStackButton(this, panel, Objects.requireNonNullElse(resource, SelectableResource.fluid(FluidStack.empty())));
    }

    private class FluidStackButton
    extends ResourceSelectorScreen.ResourceButton {
        private FluidStackButton(SelectFluidScreen selectFluidScreen, Panel panel, SelectableResource<FluidStack> resource) {
            super(panel, resource);
        }

        @Override
        public boolean shouldAdd(SearchTerms searchTerms) {
            return searchTerms.match(RegistrarManager.getId((Object)((FluidStack)this.getResource()).getFluid(), (class_5321)class_7924.field_41270), ((FluidStack)this.getResource()).getName().getString(), id -> ((FluidStack)this.getResource()).getFluid().method_40178().method_40220(class_6862.method_40092((class_5321)class_7924.field_41270, (class_2960)id)));
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            if (!((FluidStack)this.getResource()).isEmpty()) {
                list.add(((FluidStack)this.getResource()).getName());
                if (((Boolean)FTBLibraryClientConfig.FLUID_MODNAME.get()).booleanValue()) {
                    ModUtils.getModName(((FluidStack)this.getResource()).getFluid()).ifPresent(name -> list.add((class_2561)class_2561.method_43470((String)name).method_27695(new class_124[]{class_124.field_1078, class_124.field_1056})));
                }
            }
        }
    }
}

