/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui.resource;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.config.ui.resource.EntityFaceResource;
import dev.ftb.mods.ftblibrary.config.ui.resource.ImageResource;
import dev.ftb.mods.ftblibrary.config.ui.resource.SelectableResource;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import net.minecraft.class_7706;
import net.minecraft.class_7764;
import net.minecraft.class_7923;

public interface ResourceSearchMode<T> {
    public static final ResourceSearchMode<class_1799> ALL_ITEMS = new SearchMode<class_1799>((class_2561)class_2561.method_43471((String)"ftblibrary.select_item.list_mode.all"), Icons.COMPASS){
        private List<SelectableResource<class_1799>> allItemsCache = null;

        @Override
        public Collection<? extends SelectableResource<class_1799>> getAllResources() {
            if (this.allItemsCache == null) {
                class_7706.method_47330((class_7699)class_7701.field_40183, (boolean)false, (class_7225.class_7874)ClientUtils.registryAccess());
                this.allItemsCache = class_7706.method_47344().method_47313().stream().map(SelectableResource::item).toList();
            }
            return this.allItemsCache;
        }
    };
    public static final ResourceSearchMode<class_1799> INVENTORY = new SearchMode<class_1799>((class_2561)class_2561.method_43471((String)"ftblibrary.select_item.list_mode.inv"), ItemIcon.getItemIcon(class_1802.field_8106)){

        @Override
        public Collection<? extends SelectableResource<class_1799>> getAllResources() {
            class_746 player = class_310.method_1551().field_1724;
            if (player == null) {
                return Collections.emptySet();
            }
            int invSize = player.method_31548().method_5439();
            ArrayList<SelectableResource<class_1799>> items = new ArrayList<SelectableResource<class_1799>>(invSize);
            for (int i = 0; i < invSize; ++i) {
                class_1799 stack = player.method_31548().method_5438(i);
                if (stack.method_7960()) continue;
                items.add(SelectableResource.item(stack));
            }
            return items;
        }
    };
    public static final ResourceSearchMode<FluidStack> ALL_FLUIDS = new SearchMode<FluidStack>((class_2561)class_2561.method_43471((String)"ftblibrary.select_fluid.list_mode.all"), ItemIcon.getItemIcon(class_1802.field_8251)){
        private List<SelectableResource<FluidStack>> allFluidsCache = null;

        @Override
        public Collection<? extends SelectableResource<FluidStack>> getAllResources() {
            if (this.allFluidsCache == null) {
                ArrayList fluidstacks = new ArrayList();
                class_7923.field_41173.forEach(f -> {
                    if (f.method_15793(f.method_15785())) {
                        fluidstacks.add(SelectableResource.fluid(FluidStack.create((class_3611)f, (long)FluidStackHooks.bucketAmount())));
                    }
                });
                this.allFluidsCache = List.copyOf(fluidstacks);
            }
            return this.allFluidsCache;
        }
    };
    public static final ResourceSearchMode<class_1299<?>> ENTITY_FACES = new SearchMode<class_1299<?>>((class_2561)class_2561.method_43471((String)"ftblibrary.select_entity.all_entities"), Icons.PLAYER){
        private List<SelectableResource<class_1299<?>>> allTypesCache = null;

        @Override
        public Collection<? extends SelectableResource<class_1299<?>>> getAllResources() {
            if (this.allTypesCache == null) {
                ArrayList types = new ArrayList();
                class_7923.field_41177.forEach(entityType -> {
                    if (entityType.method_5883((class_1937)class_310.method_1551().field_1687) instanceof class_1309) {
                        types.add(new EntityFaceResource((class_1299<?>)entityType));
                    }
                });
                this.allTypesCache = types.stream().sorted().toList();
            }
            return this.allTypesCache;
        }
    };
    public static final ResourceSearchMode<class_2960> IMAGES = new SearchMode<class_2960>((class_2561)class_2561.method_43471((String)"ftblibrary.select_image.all_images"), Icons.ART){
        private List<ImageResource> cachedImages = null;

        @Override
        public void clearCache() {
            this.cachedImages = null;
        }

        @Override
        public Collection<? extends SelectableResource<class_2960>> getAllResources() {
            if (this.cachedImages == null) {
                ArrayList images = new ArrayList();
                StringUtils.ignoreResourceLocationErrors = true;
                Map textures = Collections.emptyMap();
                try {
                    textures = class_310.method_1551().method_1478().method_14488("textures", t -> t.method_12832().endsWith(".png"));
                }
                catch (Exception ex) {
                    FTBLibrary.LOGGER.error("A mod has a broken resource preventing this list from loading: {}", (Object)String.valueOf(ex));
                }
                StringUtils.ignoreResourceLocationErrors = false;
                textures.keySet().forEach(rl -> class_2960.method_29186((String)rl.toString()).result().ifPresentOrElse(images::add, () -> FTBLibrary.LOGGER.warn("Image {} has invalid path! Report this to author of '{}'!", rl, (Object)rl.method_12836())));
                this.cachedImages = images.stream().sorted().map(res -> {
                    class_2960 res1 = class_2960.method_60655((String)res.method_12836(), (String)res.method_12832().substring(9, res.method_12832().length() - 4));
                    class_1058 sprite = class_310.method_1551().method_1554().method_24153(class_1723.field_21668).method_4608(res1);
                    class_7764 contents = sprite.method_45851();
                    if (contents.method_45816().equals((Object)class_1047.method_4539())) {
                        res1 = res;
                    }
                    return new ImageResource(res1);
                }).toList();
            }
            return this.cachedImages;
        }
    };

    public Icon getIcon();

    public class_2561 getDisplayName();

    public Collection<? extends SelectableResource<T>> getAllResources();

    default public void clearCache() {
    }

    public static abstract class SearchMode<T>
    implements ResourceSearchMode<T> {
        private final class_2561 name;
        private final Icon icon;

        protected SearchMode(class_2561 name, Icon icon) {
            this.name = name;
            this.icon = icon;
        }

        @Override
        public class_2561 getDisplayName() {
            return this.name;
        }

        @Override
        public Icon getIcon() {
            return this.icon;
        }
    }
}

