/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.util;

import dev.architectury.event.CompoundEventResult;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.ftb.mods.ftbessentials.api.event.TeleportEvent;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import dev.ftb.mods.ftbessentials.util.fabric.WarmupCooldownTeleporterImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class WarmupCooldownTeleporter {
    private final FTBEPlayerData playerData;
    private final ToIntFunction<class_3222> cooldownConfig;
    private final ToIntFunction<class_3222> warmupConfig;
    private final boolean popHistoryOnTeleport;
    private long lastRun;
    private static final Map<UUID, Warmup> WARMUPS = new HashMap<UUID, Warmup>();
    private static final Map<UUID, Warmup> pendingAdditions = new HashMap<UUID, Warmup>();
    private static final Set<UUID> pendingRemovals = new HashSet<UUID>();

    public WarmupCooldownTeleporter(FTBEPlayerData playerData, ToIntFunction<class_3222> cooldownConfig, ToIntFunction<class_3222> warmupConfig) {
        this(playerData, cooldownConfig, warmupConfig, false);
    }

    public WarmupCooldownTeleporter(FTBEPlayerData playerData, ToIntFunction<class_3222> cooldownConfig, ToIntFunction<class_3222> warmupConfig, boolean popHistoryOnTeleport) {
        this.playerData = playerData;
        this.cooldownConfig = cooldownConfig;
        this.warmupConfig = warmupConfig;
        this.popHistoryOnTeleport = popHistoryOnTeleport;
        this.lastRun = 0L;
    }

    public TeleportPos.TeleportResult checkCooldown(class_3222 player) {
        long nextRun;
        long now = System.currentTimeMillis();
        if (now < (nextRun = this.lastRun + Math.max(0L, (long)this.cooldownConfig.applyAsInt(player) * 1000L))) {
            return () -> nextRun - now;
        }
        return TeleportPos.TeleportResult.SUCCESS;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static boolean firePlatformTeleportEvent(class_3222 player, class_243 pos) {
        void var1_1;
        return WarmupCooldownTeleporterImpl.firePlatformTeleportEvent(player, (class_243)var1_1);
    }

    public TeleportPos.TeleportResult teleport(class_3222 player, Function<class_3222, TeleportPos> positionGetter) {
        TeleportPos.TeleportResult blacklistedResult;
        TeleportPos.TeleportResult cooldownResult = this.checkCooldown(player);
        if (!cooldownResult.isSuccess()) {
            return cooldownResult;
        }
        TeleportPos pos = positionGetter.apply(player);
        if (!(player.method_5687(2) && ((Boolean)FTBEConfig.ADMINS_EXEMPT_DIMENSION_BLACKLISTS.get()).booleanValue() || (blacklistedResult = pos.checkDimensionBlacklist((class_1657)player)).isSuccess())) {
            return blacklistedResult;
        }
        CompoundEventResult<class_2561> result = ((TeleportEvent.Teleport)TeleportEvent.TELEPORT.invoker()).teleport(player);
        if (result.isFalse()) {
            return TeleportPos.TeleportResult.failed((class_2561)result.object());
        }
        if (!WarmupCooldownTeleporter.firePlatformTeleportEvent(player, class_243.method_24955((class_2382)pos.getPos()))) {
            return TeleportPos.TeleportResult.failed((class_2561)class_2561.method_43471((String)"ftbessentials.teleport_prevented"));
        }
        int warmupTime = this.warmupConfig.applyAsInt(player);
        if (warmupTime == 0) {
            return this.teleportNow(player, pos);
        }
        pendingAdditions.put(player.method_5667(), new Warmup(System.currentTimeMillis() + (long)warmupTime * 1000L, this, player.method_19538(), pos));
        return TeleportPos.TeleportResult.SUCCESS;
    }

    private TeleportPos.TeleportResult teleportNow(class_3222 player, TeleportPos teleportPos) {
        this.lastRun = System.currentTimeMillis();
        TeleportPos currentPos = new TeleportPos((class_1297)player);
        TeleportPos.TeleportResult res = teleportPos.teleport(player);
        if (res.isSuccess()) {
            if (this.popHistoryOnTeleport) {
                this.playerData.popTeleportHistory();
            } else if (!((Boolean)FTBEConfig.BACK_ON_DEATH_ONLY.get()).booleanValue()) {
                this.playerData.addTeleportHistory(player, currentPos);
            }
        }
        return res;
    }

    public static void tickWarmups(MinecraftServer server) {
        WARMUPS.putAll(pendingAdditions);
        pendingAdditions.clear();
        pendingRemovals.forEach(WARMUPS::remove);
        pendingRemovals.clear();
        if (WARMUPS.isEmpty()) {
            return;
        }
        HashSet<UUID> toRemove = new HashSet<UUID>();
        long now = System.currentTimeMillis();
        for (Map.Entry<UUID, Warmup> entry : WARMUPS.entrySet()) {
            UUID playerId = entry.getKey();
            class_3222 player = server.method_3760().method_14602(playerId);
            if (player != null) {
                Warmup warmup = entry.getValue();
                if (warmup.when() <= now) {
                    TeleportPos.TeleportResult res = warmup.teleporter().teleportNow(player, warmup.teleportPos());
                    toRemove.add(playerId);
                    res.runCommand(player);
                    continue;
                }
                if (player.method_19538().method_1025(warmup.initialPos) > 0.25) {
                    toRemove.add(playerId);
                    player.method_7353((class_2561)class_2561.method_43471((String)"ftbessentials.teleport.interrupted").method_27692(class_124.field_1061), true);
                    continue;
                }
                long seconds = (warmup.when() - now) / 1000L;
                player.method_7353((class_2561)class_2561.method_43469((String)"ftbessentials.teleport.notify", (Object[])new Object[]{seconds}).method_27692(class_124.field_1054), true);
                continue;
            }
            toRemove.add(playerId);
        }
        toRemove.forEach(WARMUPS::remove);
    }

    public static void cancelWarmup(class_3222 player) {
        if (WARMUPS.containsKey(player.method_5667())) {
            pendingRemovals.add(player.method_5667());
            player.method_7353((class_2561)class_2561.method_43471((String)"ftbessentials.teleport.interrupted").method_27692(class_124.field_1061), true);
        }
    }

    private record Warmup(long when, WarmupCooldownTeleporter teleporter, class_243 initialPos, TeleportPos teleportPos) {
    }
}

