/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.commands.impl.teleporting;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.ftb.mods.ftbessentials.commands.FTBCommand;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.SavedTeleportManager;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2191;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;

public class HomeCommand
implements FTBCommand {
    @Override
    public boolean enabled() {
        return FTBEConfig.HOME.isEnabled();
    }

    @Override
    public List<LiteralArgumentBuilder<class_2168>> register() {
        return List.of((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"home").requires((Predicate)FTBEConfig.HOME)).executes(context -> this.home(((class_2168)context.getSource()).method_9207(), "home"))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265(this.getHomeSuggestions((CommandContext<class_2168>)context), (SuggestionsBuilder)builder)).executes(context -> this.home(((class_2168)context.getSource()).method_9207(), StringArgumentType.getString((CommandContext)context, (String)"name")))), (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sethome").requires((Predicate)FTBEConfig.HOME)).executes(context -> this.setHome(((class_2168)context.getSource()).method_9207(), "home"))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(context -> this.setHome(((class_2168)context.getSource()).method_9207(), StringArgumentType.getString((CommandContext)context, (String)"name")))), (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"delhome").requires((Predicate)FTBEConfig.HOME)).executes(context -> this.delHome(((class_2168)context.getSource()).method_9207(), "home"))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265(this.getHomeSuggestions((CommandContext<class_2168>)context), (SuggestionsBuilder)builder)).executes(context -> this.delHome(((class_2168)context.getSource()).method_9207(), StringArgumentType.getString((CommandContext)context, (String)"name")))), (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"listhomes").requires((Predicate)FTBEConfig.HOME)).executes(context -> HomeCommand.listHomes((class_2168)context.getSource(), ((class_2168)context.getSource()).method_9207().method_7334()))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).requires(source -> source.method_9211().method_3724() || source.method_9259(2))).executes(context -> HomeCommand.listHomes((class_2168)context.getSource(), (GameProfile)class_2191.method_9330((CommandContext)context, (String)"player").iterator().next()))));
    }

    public Set<String> getHomeSuggestions(CommandContext<class_2168> context) throws CommandSyntaxException {
        return FTBEPlayerData.getOrCreate((class_1657)((class_2168)context.getSource()).method_9207()).map(data -> data.homeManager().getNames()).orElse(Set.of());
    }

    public int home(class_3222 player, String name) {
        return FTBEPlayerData.getOrCreate((class_1657)player).map(data -> data.homeManager().teleportTo(name, player, data.homeTeleporter).runCommand(player)).orElse(0);
    }

    public int setHome(class_3222 player, String name) {
        return FTBEPlayerData.getOrCreate((class_1657)player).map(data -> {
            try {
                if (player.method_24515().method_10264() < (Integer)FTBEConfig.HOME_MIN_Y.get()) {
                    player.method_7353((class_2561)class_2561.method_43469((String)"ftbessentials.home.y_too_low", (Object[])new Object[]{FTBEConfig.HOME_MIN_Y.get()}), false);
                    return 0;
                }
                data.homeManager().addDestination(name, new TeleportPos((class_1297)player), player);
                player.method_7353((class_2561)class_2561.method_43471((String)"ftbessentials.home.set"), false);
                return 1;
            }
            catch (SavedTeleportManager.TooManyDestinationsException e) {
                player.method_7353((class_2561)class_2561.method_43471((String)"ftbessentials.home.too_many"), false);
                return 0;
            }
        }).orElse(0);
    }

    public int delHome(class_3222 player, String name) {
        return FTBEPlayerData.getOrCreate((class_1657)player).map(data -> {
            if (data.homeManager().deleteDestination(name.toLowerCase())) {
                player.method_7353((class_2561)class_2561.method_43471((String)"ftbessentials.home.deleted"), false);
                return 1;
            }
            player.method_7353((class_2561)class_2561.method_43471((String)"ftbessentials.home.not_found"), false);
            return 0;
        }).orElse(0);
    }

    public static int listHomes(class_2168 source, GameProfile of) {
        return FTBEPlayerData.getOrCreate(source.method_9211(), of.getId()).map(data -> {
            if (data.homeManager().getNames().isEmpty()) {
                source.method_9226(() -> class_2561.method_43471((String)"ftbessentials.none"), false);
            } else {
                source.method_9226(() -> class_2561.method_43469((String)"ftbessentials.home.for_player", (Object[])new Object[]{of.getName()}).method_27692(class_124.field_1065), false);
                source.method_9226(() -> class_2561.method_43470((String)"---").method_27692(class_124.field_1065), false);
                TeleportPos origin = new TeleportPos((class_5321<class_1937>)source.method_9225().method_27983(), class_2338.method_49638((class_2374)source.method_9222()));
                data.homeManager().destinations().forEach(entry -> source.method_9226(() -> {
                    class_5250 line = class_2561.method_43469((String)"ftbessentials.home.show_home", (Object[])new Object[]{class_2561.method_43470((String)entry.name()).method_27692(class_124.field_1075), entry.destination().distanceString(origin)});
                    if (source.method_9259(2)) {
                        line.method_27696(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/tp @s " + entry.destination().posAsString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"ftbessentials.click_to_teleport"))));
                    }
                    return line;
                }, false));
            }
            return 1;
        }).orElse(0);
    }
}

