/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.api.ChunkTeamData;
import dev.ftb.mods.ftbchunks.api.ClaimResult;
import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.ChunkTeamDataImpl;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManagerImpl;
import dev.ftb.mods.ftbchunks.net.ChunkChangeResponsePacket;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_4844;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record RequestChunkChangePacket(ChunkChangeOp action, Set<XZ> chunks, boolean tryAdminChanges, Optional<UUID> teamId) implements class_8710
{
    public static final class_8710.class_9154<RequestChunkChangePacket> TYPE = new class_8710.class_9154(FTBChunksAPI.rl("request_chunk_change_packet"));
    public static final class_9139<class_2540, RequestChunkChangePacket> STREAM_CODEC = class_9139.method_56905((class_9139)NetworkHelper.enumStreamCodec(ChunkChangeOp.class), RequestChunkChangePacket::action, (class_9139)XZ.STREAM_CODEC.method_56433(class_9135.method_56374(HashSet::new)), RequestChunkChangePacket::chunks, (class_9139)class_9135.field_48547, RequestChunkChangePacket::tryAdminChanges, (class_9139)class_4844.field_48453.method_56433(class_9135::method_56382), RequestChunkChangePacket::teamId, RequestChunkChangePacket::new);

    public class_8710.class_9154<RequestChunkChangePacket> method_56479() {
        return TYPE;
    }

    public static void handle(RequestChunkChangePacket message, NetworkManager.PacketContext context) {
        class_3222 player = (class_3222)context.getPlayer();
        class_2168 source = player.method_5671();
        ChunkTeamDataImpl chunkTeamData = null;
        if (message.teamId().isPresent()) {
            Optional team = FTBTeamsAPI.api().getManager().getTeamByID(message.teamId().get());
            if (team.isEmpty()) {
                player.method_43496((class_2561)class_2561.method_43469((String)"ftbteams.team_not_found", (Object[])new Object[]{message.teamId, class_124.field_1061}));
                return;
            }
            chunkTeamData = ClaimedChunkManagerImpl.getInstance().getOrCreateData((Team)team.get());
        }
        if (chunkTeamData == null) {
            chunkTeamData = ClaimedChunkManagerImpl.getInstance().getOrCreateData(player);
        }
        ChunkTeamDataImpl data = chunkTeamData;
        Function<XZ, ClaimResult> consumer = switch (message.action.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> pos -> data.claim(source, pos.dim(player.method_37908()), false);
            case 1 -> pos -> data.unclaim(source, pos.dim(player.method_37908()), false, message.tryAdminChanges);
            case 2 -> pos -> data.forceLoad(source, pos.dim(player.method_37908()), false, message.tryAdminChanges);
            case 3 -> pos -> data.unForceLoad(source, pos.dim(player.method_37908()), false, message.tryAdminChanges);
        };
        EnumMap<ClaimResult.StandardProblem, Integer> problems = new EnumMap<ClaimResult.StandardProblem, Integer>(ClaimResult.StandardProblem.class);
        int changed = 0;
        for (XZ pos2 : message.chunks) {
            ClaimResult r = consumer.apply(pos2);
            if (!r.isSuccess()) {
                FTBChunks.LOGGER.debug(String.format("%s tried to %s @ %s:%d:%d but got result %s", player.method_5820(), message.action.name, player.method_37908().method_27983().method_29177(), pos2.x(), pos2.z(), r));
                if (!(r instanceof ClaimResult.StandardProblem)) continue;
                ClaimResult.StandardProblem cr = (ClaimResult.StandardProblem)r;
                problems.put(cr, problems.getOrDefault(cr, 0) + 1);
                continue;
            }
            ++changed;
        }
        NetworkManager.sendToPlayer((class_3222)player, (class_8710)new ChunkChangeResponsePacket(message.chunks.size(), changed, problems));
        SendGeneralDataPacket.send((ChunkTeamData)data, player);
        if (message.teamId.isPresent()) {
            SendGeneralDataPacket.send((ChunkTeamData)chunkTeamData, data.getTeam().getOnlineMembers());
        }
    }

    public static enum ChunkChangeOp {
        CLAIM("claim"),
        UNCLAIM("unclaim"),
        LOAD("load"),
        UNLOAD("unload");

        private final String name;

        private ChunkChangeOp(String name) {
            this.name = name;
        }

        public static ChunkChangeOp create(boolean isLeftMouse, boolean isShift) {
            return isShift ? (isLeftMouse ? LOAD : UNLOAD) : (isLeftMouse ? CLAIM : UNCLAIM);
        }
    }
}

