/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.map.color;

import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import java.io.InputStream;
import java.util.HashMap;
import net.minecraft.class_1011;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3532;
import net.minecraft.class_5253;

public class ColorUtils {
    private static Color4I[] reducedColorPalette = null;
    private static Color4I[] topographyPalette = null;
    private static Color4I[][] lightMapPalette = null;
    private static final HashMap<Color4I, Color4I> reducedColorMap = new HashMap();

    public static int convertToNative(int c) {
        return class_5253.class_8045.method_48344((int)(c >> 24 & 0xFF), (int)(c >> 0 & 0xFF), (int)(c >> 8 & 0xFF), (int)(c >> 16 & 0xFF));
    }

    public static int convertFromNative(int c) {
        return class_5253.class_8045.method_48342((int)c) << 24 | class_5253.class_8045.method_48345((int)c) << 16 | class_5253.class_8045.method_48346((int)c) << 8 | class_5253.class_8045.method_48347((int)c);
    }

    public static Color4I addBrightness(Color4I c, float f) {
        float r = c.redf() + f;
        float g = c.greenf() + f;
        float b = c.bluef() + f;
        int ri = class_3532.method_15340((int)((int)(r * 255.0f)), (int)0, (int)255);
        int gi = class_3532.method_15340((int)((int)(g * 255.0f)), (int)0, (int)255);
        int bi = class_3532.method_15340((int)((int)(b * 255.0f)), (int)0, (int)255);
        return Color4I.rgb((int)ri, (int)gi, (int)bi);
    }

    public static Color4I reduce(Color4I c) {
        if (reducedColorPalette == null) {
            reducedColorPalette = new Color4I[0];
            try (InputStream stream = ((class_3298)class_310.method_1551().method_1478().method_14486(FTBChunksAPI.rl("textures/reduced_color_palette.png")).orElseThrow()).method_14482();){
                class_1011 image = class_1011.method_4309((InputStream)stream);
                int w = image.method_4307();
                int h = image.method_4323();
                reducedColorPalette = new Color4I[w * h];
                for (int x = 0; x < w; ++x) {
                    for (int y = 0; y < h; ++y) {
                        int col2 = image.method_4315(x, y);
                        ColorUtils.reducedColorPalette[x + y * w] = Color4I.rgb((int)(class_5253.class_8045.method_48345((int)col2) << 16 | class_5253.class_8045.method_48346((int)col2) << 8 | class_5253.class_8045.method_48347((int)col2)));
                    }
                }
                image.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (reducedColorPalette.length == 0) {
            return c;
        }
        return reducedColorMap.computeIfAbsent(c, col -> {
            int r = col.redi();
            int g = col.greeni();
            int b = col.bluei();
            long prevDist = Long.MAX_VALUE;
            Color4I colr = Color4I.BLACK;
            for (Color4I rcol : reducedColorPalette) {
                long db;
                long dg;
                long dr = r - rcol.redi();
                long d = dr * dr + (dg = (long)(g - rcol.greeni())) * dg + (db = (long)(b - rcol.bluei())) * db;
                if (d >= prevDist) continue;
                prevDist = d;
                colr = rcol;
            }
            return colr;
        });
    }

    public static Color4I[] getTopographyPalette() {
        if (topographyPalette == null) {
            topographyPalette = new Color4I[0];
            try (InputStream stream = ((class_3298)class_310.method_1551().method_1478().method_14486(FTBChunksAPI.rl("textures/topography_palette.png")).orElseThrow()).method_14482();){
                class_1011 image = class_1011.method_4309((InputStream)stream);
                int w = image.method_4307();
                int h = image.method_4323();
                topographyPalette = new Color4I[w * h];
                for (int x = 0; x < w; ++x) {
                    for (int y = 0; y < h; ++y) {
                        int col = image.method_4315(x, y);
                        ColorUtils.topographyPalette[x + y * w] = Color4I.rgb((int)ColorUtils.convertFromNative(col)).withAlpha(255);
                    }
                }
                image.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return topographyPalette;
    }

    public static Color4I[][] getLightMapPalette() {
        if (lightMapPalette == null) {
            lightMapPalette = new Color4I[0][0];
            try (InputStream stream = ((class_3298)class_310.method_1551().method_1478().method_14486(FTBChunksAPI.rl("textures/lightmap_palette.png")).orElseThrow()).method_14482();){
                class_1011 image = class_1011.method_4309((InputStream)stream);
                int w = image.method_4307();
                int h = image.method_4323();
                lightMapPalette = new Color4I[w][h];
                for (int x = 0; x < w; ++x) {
                    for (int y = 0; y < h; ++y) {
                        int col = image.method_4315(x, y);
                        ColorUtils.lightMapPalette[x][y] = Color4I.rgb((int)ColorUtils.convertFromNative(col)).withAlpha(255);
                    }
                }
                image.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return lightMapPalette;
    }
}

