/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.map;

import dev.ftb.mods.ftbchunks.api.client.icon.WaypointIcon;
import dev.ftb.mods.ftbchunks.api.client.waypoint.Waypoint;
import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.client.map.WaypointType;
import dev.ftb.mods.ftbchunks.client.mapicon.WaypointMapIcon;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_5321;

public class WaypointImpl
implements Waypoint {
    private final MapDimension mapDimension;
    private final class_2338 pos;
    private final WaypointType type;
    public double minimapDistance = 50000.0;
    public double inWorldDistance = 0.0;
    private boolean hidden = false;
    private String name = "";
    private int color = 0xFFFFFF;
    private WaypointMapIcon mapIcon;
    private boolean isTransient;

    public WaypointImpl(WaypointType type, MapDimension mapDimension, class_2338 pos) {
        this.type = type;
        this.mapDimension = mapDimension;
        this.pos = pos;
    }

    public WaypointType getType() {
        return this.type;
    }

    @Override
    public boolean isDeathpoint() {
        return this.type == WaypointType.DEATH;
    }

    @Override
    public class_5321<class_1937> getDimension() {
        return this.mapDimension.dimension;
    }

    @Override
    public class_2338 getPos() {
        return this.pos;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public WaypointImpl setHidden(boolean hidden) {
        this.hidden = hidden;
        this.mapDimension.markDirty();
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public WaypointImpl setName(String name) {
        this.name = name;
        this.mapDimension.markDirty();
        return this;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public WaypointImpl setColor(int color) {
        this.color = color;
        this.mapDimension.markDirty();
        return this;
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public WaypointImpl setTransient(boolean isTransient) {
        this.isTransient = isTransient;
        return this;
    }

    @Override
    public double getDistanceSq(class_1297 entity) {
        return entity.method_5707(class_243.method_24953((class_2382)this.pos));
    }

    @Override
    public WaypointIcon getMapIcon() {
        return this.mapIcon;
    }

    public void refreshIcon() {
        this.mapIcon = new WaypointMapIcon(this);
    }

    public double getDrawDistance(boolean isMinimap) {
        if (isMinimap) {
            return this.minimapDistance;
        }
        return this.inWorldDistance == 0.0 ? (Double)FTBChunksClientConfig.WAYPOINT_MAX_DISTANCE.get() : this.inWorldDistance;
    }

    public void removeFromManager() {
        this.mapDimension.getWaypointManager().remove(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WaypointImpl waypoint = (WaypointImpl)o;
        return this.pos.equals((Object)waypoint.pos) && this.mapDimension.dimension.equals(waypoint.mapDimension.dimension);
    }

    public int hashCode() {
        return Objects.hash(this.mapDimension.dimension, this.pos);
    }
}

