/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.gui;

import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import dev.ftb.mods.ftbchunks.client.gui.AddWaypointOverlay;
import dev.ftb.mods.ftbchunks.client.gui.ChunkScreen;
import dev.ftb.mods.ftbchunks.client.gui.MinimapInfoSortScreen;
import dev.ftb.mods.ftbchunks.client.gui.RegionMapPanel;
import dev.ftb.mods.ftbchunks.client.gui.WaypointEditorScreen;
import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.client.map.MapRegion;
import dev.ftb.mods.ftbchunks.client.map.MapRegionData;
import dev.ftb.mods.ftbchunks.client.map.WaypointImpl;
import dev.ftb.mods.ftbchunks.client.map.WaypointManagerImpl;
import dev.ftb.mods.ftbchunks.client.map.WaypointType;
import dev.ftb.mods.ftbchunks.net.TeleportFromMapPacket;
import dev.ftb.mods.ftblibrary.config.ColorConfig;
import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.manager.ConfigManagerClient;
import dev.ftb.mods.ftblibrary.config.ui.EditStringConfigOverlay;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.DropDownMenu;
import dev.ftb.mods.ftblibrary.ui.ModalPanel;
import dev.ftb.mods.ftblibrary.ui.NordTheme;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.ScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.KeyReferenceScreen;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import dev.ftb.mods.ftblibrary.util.TextComponentUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_4208;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_746;
import net.minecraft.class_8710;

public class LargeMapScreen
extends BaseScreen {
    private static final Color4I BACKGROUND_COLOR = Color4I.rgb((int)0x202225);
    private static final Icon MINIMAP_INFO = Icon.getIcon((class_2960)FTBChunksAPI.rl("textures/minimap_info.png"));
    private final RegionMapPanel regionPanel = new RegionMapPanel(this);
    private int zoom = 256;
    MapDimension dimension;
    int scrollWidth = 0;
    int scrollHeight = 0;
    int prevMouseX;
    int prevMouseY;
    int grabbed = 0;
    private boolean movedToPlayer = false;
    private Button claimChunksButton;
    private Button dimensionButton;
    private Button waypointManagerButton;
    private Button infoButton;
    private Button settingsButton;
    private Button serverSettingsButton;
    private Button clearDeathpointsButton;
    private Button infoSortScreen;
    private boolean needIconRefresh;
    private final int minZoom;

    private LargeMapScreen(MapDimension dim) {
        this.dimension = dim;
        this.regionPanel.setScrollX(0.0);
        this.regionPanel.setScrollY(0.0);
        this.minZoom = this.determineMinZoom();
    }

    public static void openMap() {
        MapDimension.getCurrent().ifPresentOrElse(mapDimension -> new LargeMapScreen((MapDimension)mapDimension).openGui(), () -> FTBChunks.LOGGER.warn("Missing MapDimension data?? not opening large map"));
    }

    public Theme getTheme() {
        return NordTheme.THEME;
    }

    public void onClosed() {
        super.onClosed();
        int autoRelease = (Integer)FTBChunksClientConfig.AUTORELEASE_ON_MAP_CLOSE.get();
        if (autoRelease > 0 && this.dimension != null) {
            this.dimension.getManager().scheduleRegionPurge(this.dimension);
        }
    }

    public class_5321<class_1937> currentDimension() {
        return this.dimension.dimension;
    }

    public int getRegionTileSize() {
        return this.zoom * 2;
    }

    public void addZoom(double up) {
        int prevZoom = this.zoom;
        this.zoom = up > 0.0 ? (this.zoom *= 2) : (this.zoom /= 2);
        this.zoom = class_3532.method_15340((int)this.zoom, (int)this.minZoom, (int)1024);
        if (this.zoom != prevZoom) {
            this.grabbed = 0;
            double sx = this.regionPanel.regionX;
            double sy = this.regionPanel.regionZ;
            this.regionPanel.resetScroll();
            this.regionPanel.scrollTo(sx, sy);
            class_310.method_1551().field_1729.field_1783 = true;
            class_310.method_1551().field_1729.method_1610();
        }
    }

    public void addWidgets() {
        this.add((Widget)this.regionPanel);
        this.claimChunksButton = new SimpleTooltipButton((Panel)this, (class_2561)class_2561.method_43471((String)"ftbchunks.gui.claimed_chunks"), Icons.MAP, (b, m) -> ChunkScreen.openChunkScreen(), (class_2561)class_2561.method_43470((String)"[C]").method_27692(class_124.field_1080));
        this.add((Widget)this.claimChunksButton);
        class_5250 tooltip = class_2561.method_43470((String)"[").method_10852(FTBChunksClient.INSTANCE.waypointManagerKey.method_16007()).method_10852((class_2561)class_2561.method_43470((String)"]")).method_27692(class_124.field_1080);
        this.waypointManagerButton = new SimpleTooltipButton((Panel)this, (class_2561)class_2561.method_43471((String)"ftbchunks.gui.waypoints"), Icons.COMPASS, (b, m) -> new WaypointEditorScreen().openGui(), (class_2561)tooltip);
        this.add((Widget)this.waypointManagerButton);
        this.infoSortScreen = new SimpleTooltipButton((Panel)this, (class_2561)class_2561.method_43471((String)"ftbchunks.gui.sort_minimap_info"), MINIMAP_INFO, (b, m) -> new MinimapInfoSortScreen().openGui(), (class_2561)tooltip);
        this.add((Widget)this.infoSortScreen);
        this.infoButton = new SimpleButton((Panel)this, (class_2561)class_2561.method_43471((String)"ftbchunks.gui.large_map_info"), Icons.INFO, (b, m) -> new MapKeyReferenceScreen().openGui());
        this.add((Widget)this.infoButton);
        this.clearDeathpointsButton = new ClearDeathPointButton((Panel)this);
        this.add((Widget)this.clearDeathpointsButton);
        class_2561 dimName = TextComponentUtils.translatedDimension(this.dimension.dimension);
        List<ContextMenuItem> dimItems = AddWaypointOverlay.createDimContextItems(key -> {
            this.dimension = this.dimension.getManager().getDimension((class_5321<class_1937>)key);
            this.refreshWidgets();
            this.movedToPlayer = false;
        });
        this.dimensionButton = new SimpleButton((Panel)this, dimName, Icons.GLOBE, (b, m) -> {
            DropDownMenu dropDownMenu = this.getGui().openDropdownMenu(dimItems);
            dropDownMenu.setPos(this.dimensionButton.getX() + this.dimensionButton.width, this.dimensionButton.getY() + this.dimensionButton.height - dropDownMenu.height);
        });
        this.add((Widget)this.dimensionButton);
        this.settingsButton = new SimpleTooltipButton((Panel)this, (class_2561)class_2561.method_43471((String)"ftbchunks.gui.settings"), Icons.SETTINGS, (b, m) -> ConfigManagerClient.editConfig((String)"ftbchunks-client"), (class_2561)class_2561.method_43470((String)"[S]").method_27692(class_124.field_1080));
        this.add((Widget)this.settingsButton);
        if (class_310.method_1551().field_1724.method_5687(2)) {
            this.serverSettingsButton = new SimpleTooltipButton((Panel)this, (class_2561)class_2561.method_43471((String)"ftbchunks.gui.settings.server"), Icons.SETTINGS.withTint(Color4I.rgb((int)10502399)), (b, m) -> ConfigManagerClient.editConfig((String)"ftbchunks-world"), (class_2561)class_2561.method_43470((String)"[Ctrl + S]").method_27692(class_124.field_1080));
            this.add((Widget)this.serverSettingsButton);
        }
    }

    private WaypointManagerImpl getWaypointManager() {
        return MapManager.getInstance().orElseThrow().getDimension(this.dimension.dimension).getWaypointManager();
    }

    private void cycleVisibleDimension(MouseButton m) {
        try {
            ArrayList<MapDimension> list = new ArrayList<MapDimension>(this.dimension.getManager().getDimensions().values());
            int i = list.indexOf(this.dimension);
            if (i != -1) {
                this.dimension = (MapDimension)list.get(MathUtils.mod((int)(i + (m.isLeft() ? 1 : -1)), (int)list.size()));
                this.refreshWidgets();
                this.movedToPlayer = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void alignWidgets() {
        this.claimChunksButton.setPosAndSize(1, 1, 16, 16);
        this.waypointManagerButton.setPosAndSize(1, 19, 16, 16);
        this.infoButton.setPosAndSize(1, 37, 16, 16);
        this.infoSortScreen.setPosAndSize(1, 55, 16, 16);
        this.clearDeathpointsButton.setPosAndSize(1, 73, 16, 16);
        this.dimensionButton.setPosAndSize(1, this.height - 36, 16, 16);
        this.settingsButton.setPosAndSize(1, this.height - 18, 16, 16);
        if (this.serverSettingsButton != null) {
            this.serverSettingsButton.setPosAndSize(this.width - 18, this.height - 18, 16, 16);
        }
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public boolean mousePressed(MouseButton button) {
        if (super.mousePressed(button)) {
            return true;
        }
        if (button.isLeft()) {
            this.prevMouseX = this.getMouseX();
            this.prevMouseY = this.getMouseY();
            return true;
        }
        if (button.isRight()) {
            int fixedY = Math.max(this.regionPanel.blockY, class_310.method_1551().field_1687.method_31607());
            class_2338 pos = new class_2338(this.regionPanel.blockX, fixedY, this.regionPanel.blockZ);
            class_4208 globalPos = class_4208.method_19443(this.dimension.dimension, (class_2338)pos);
            ArrayList<ContextMenuItem> list = new ArrayList<ContextMenuItem>();
            class_5250 title = class_2561.method_43471((String)"ftbchunks.gui.add_waypoint");
            list.add(new ContextMenuItem((class_2561)title, Icons.ADD, arg_0 -> this.lambda$mousePressed$11(globalPos, (class_2561)title, arg_0)));
            this.openContextMenu(list);
            return true;
        }
        return false;
    }

    public boolean keyPressed(Key key) {
        if (super.keyPressed(key)) {
            return true;
        }
        if (key.is(32)) {
            this.movedToPlayer = false;
            return true;
        }
        if (key.is(84)) {
            NetworkManager.sendToServer((class_8710)new TeleportFromMapPacket(this.regionPanel.blockPos().method_10084(), this.regionPanel.blockY == -32767, this.dimension.dimension));
            this.closeGui(false);
            return true;
        }
        if (key.is(71) && class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)292)) {
            FTBChunksClientConfig.CHUNK_GRID.toggle();
            FTBChunksClientConfig.saveConfig();
            this.dimension.getManager().updateAllRegions(false);
            return true;
        }
        if (key.is(67)) {
            this.claimChunksButton.onClicked(MouseButton.LEFT);
            return true;
        }
        if (key.is(83)) {
            if (class_437.method_25441()) {
                if (this.serverSettingsButton != null) {
                    this.serverSettingsButton.onClicked(MouseButton.LEFT);
                }
            } else {
                this.settingsButton.onClicked(MouseButton.LEFT);
            }
            return true;
        }
        if (FTBChunksClient.doesKeybindMatch(FTBChunksClient.INSTANCE.waypointManagerKey, key)) {
            this.waypointManagerButton.onClicked(MouseButton.LEFT);
        } else if (FTBChunksClient.doesKeybindMatch(FTBChunksClient.INSTANCE.openMapKey, key) && Platform.isForgeLike()) {
            this.closeGui(false);
            return true;
        }
        return false;
    }

    public void tick() {
        super.tick();
        if (this.needIconRefresh) {
            this.regionPanel.refreshWidgets();
            this.needIconRefresh = false;
        }
    }

    public boolean drawDefaultBackground(class_332 graphics) {
        if (!this.movedToPlayer) {
            class_746 p = class_310.method_1551().field_1724;
            this.regionPanel.resetScroll();
            this.regionPanel.scrollTo(p.method_23317() / 512.0, p.method_23321() / 512.0);
            this.movedToPlayer = true;
        }
        BACKGROUND_COLOR.draw(graphics, 0, 0, this.width, this.height);
        return false;
    }

    public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        if (this.grabbed != 0) {
            int mx = this.getMouseX();
            int my = this.getMouseY();
            if (this.scrollWidth > this.regionPanel.width) {
                this.regionPanel.setScrollX(Math.max(Math.min(this.regionPanel.getScrollX() + (double)(this.prevMouseX - mx), (double)(this.scrollWidth - this.regionPanel.width)), 0.0));
            }
            if (this.scrollHeight > this.regionPanel.height) {
                this.regionPanel.setScrollY(Math.max(Math.min(this.regionPanel.getScrollY() + (double)(this.prevMouseY - my), (double)(this.scrollHeight - this.regionPanel.height)), 0.0));
            }
            this.prevMouseX = mx;
            this.prevMouseY = my;
        }
        if (this.scrollWidth <= this.regionPanel.width) {
            this.regionPanel.setScrollX((double)(this.scrollWidth - this.regionPanel.width) / 2.0);
        }
        if (this.scrollHeight <= this.regionPanel.height) {
            this.regionPanel.setScrollY((double)(this.scrollHeight - this.regionPanel.height) / 2.0);
        }
        int s = this.getRegionTileSize();
        double ox = -this.regionPanel.getScrollX() % (double)s;
        double oy = -this.regionPanel.getScrollY() % (double)s;
        for (int gx = 0; gx <= w / s + 1; ++gx) {
            graphics.method_25301((int)((double)x + ox + (double)(gx * s)), y, y + h, 0x64464646);
        }
        for (int gy = 0; gy <= h / s + 1; ++gy) {
            graphics.method_25292(x, x + w, (int)((double)y + oy + (double)(gy * s)), 0x64464646);
        }
    }

    public void drawForeground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        MapRegion region;
        MapRegionData data;
        String coords = "X: " + this.regionPanel.blockX + ", Y: " + String.valueOf(this.regionPanel.blockY == -32767 ? "??" : Integer.valueOf(this.regionPanel.blockY)) + ", Z: " + this.regionPanel.blockZ;
        if (this.regionPanel.blockY != -32767 && (data = (region = this.dimension.getRegion(XZ.regionFromBlock((int)this.regionPanel.blockX, (int)this.regionPanel.blockZ))).getData()) != null) {
            int waterLightAndBiome = data.waterLightAndBiome[this.regionPanel.blockIndex] & 0xFFFF;
            class_5321<class_1959> biome = this.dimension.getManager().getBiomeKey(waterLightAndBiome);
            class_2248 block = this.dimension.getManager().getBlock(data.getBlockIndex(this.regionPanel.blockIndex));
            coords = coords + " | " + class_1074.method_4662((String)("biome." + biome.method_29177().method_12836() + "." + biome.method_29177().method_12832()), (Object[])new Object[0]) + " | " + class_1074.method_4662((String)block.method_9539(), (Object[])new Object[0]);
            if ((waterLightAndBiome & 0x8000) != 0) {
                coords = coords + " (in water)";
            }
        }
        int coordsw = theme.getStringWidth(coords) / 2;
        BACKGROUND_COLOR.withAlpha(150).draw(graphics, x + (w - coordsw) / 2, y + h - 6, coordsw + 4, 6);
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416((float)x + (float)(w - coordsw) / 2.0f + 2.0f, (float)(y + h - 5), 0.0f);
        poseStack.method_22905(0.5f, 0.5f, 1.0f);
        theme.drawString(graphics, (Object)coords, 0, 0, 2);
        poseStack.method_22909();
        if (((Boolean)FTBChunksClientConfig.DEBUG_INFO.get()).booleanValue()) {
            long memory = MapManager.getInstance().map(MapManager::estimateMemoryUsage).orElse(0L);
            String memoryUsage = "Estimated Memory Usage: " + StringUtils.formatDouble00((double)((double)memory / 1024.0 / 1024.0)) + " MB";
            int memoryUsagew = theme.getStringWidth(memoryUsage) / 2;
            BACKGROUND_COLOR.withAlpha(150).draw(graphics, x + (w - memoryUsagew) - 2, y, memoryUsagew + 4, 6);
            poseStack.method_22903();
            poseStack.method_46416((float)(x + (w - memoryUsagew)) - 1.0f, (float)(y + 1), 0.0f);
            poseStack.method_22905(0.5f, 0.5f, 1.0f);
            theme.drawString(graphics, (Object)memoryUsage, 0, 0, 2);
            poseStack.method_22909();
        }
        if (this.zoom == this.minZoom && this.zoom > 1) {
            class_5250 zoomWarn = class_2561.method_43471((String)"ftbchunks.zoom_warning");
            poseStack.method_22903();
            poseStack.method_46416((float)x + (float)w / 2.0f, (float)(y + 1), 0.0f);
            poseStack.method_22905(0.5f, 0.5f, 1.0f);
            theme.drawString(graphics, (Object)zoomWarn, 0, 0, Color4I.rgb((int)0xF0C000), 4);
            poseStack.method_22909();
        }
    }

    public static void refreshIconsIfOpen() {
        ScreenWrapper sw;
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof ScreenWrapper && (class_4372 = (sw = (ScreenWrapper)class_4372).getGui()) instanceof LargeMapScreen) {
            LargeMapScreen lms = (LargeMapScreen)class_4372;
            lms.refreshIcons();
        }
    }

    public void refreshIcons() {
        this.needIconRefresh = true;
    }

    private int determineMinZoom() {
        if (!((Boolean)FTBChunksClientConfig.MAX_ZOOM_CONSTRAINT.get()).booleanValue()) {
            return 1;
        }
        long potentialUsage = (long)this.dimension.getLoadedRegions().size() * 0x400000L;
        long allocatedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        long freeMem = Runtime.getRuntime().maxMemory() - allocatedMemory;
        long ratio = freeMem / Math.max(1L, potentialUsage);
        FTBChunks.LOGGER.debug("large map: free mem = {}, potential usage = {}, ratio = {}", (Object)freeMem, (Object)potentialUsage, (Object)ratio);
        if (ratio < 8L) {
            return 64;
        }
        if (ratio < 16L) {
            return 32;
        }
        if (ratio < 32L) {
            return 16;
        }
        if (ratio < 64L) {
            return 8;
        }
        return 1;
    }

    private /* synthetic */ void lambda$mousePressed$11(class_4208 globalPos, class_2561 title, Button btn) {
        StringConfig name = new StringConfig();
        name.setValue((Object)"");
        ColorConfig col = new ColorConfig();
        col.setValue((Object)Color4I.hsb((float)MathUtils.RAND.nextFloat(), (float)1.0f, (float)1.0f));
        AddWaypointOverlay.GlobalPosConfig globalPosConfig = new AddWaypointOverlay.GlobalPosConfig();
        globalPosConfig.setValue(globalPos);
        EditStringConfigOverlay overlay = new AddWaypointOverlay((Panel)this.getGui(), title, globalPosConfig, (ConfigFromString<String>)name, col, accepted -> {
            if (accepted) {
                MapDimension mapDimension = MapManager.getInstance().orElseThrow().getDimension((class_5321<class_1937>)((class_4208)globalPosConfig.getValue()).comp_2207());
                WaypointImpl waypoint = new WaypointImpl(WaypointType.DEFAULT, mapDimension, ((class_4208)globalPosConfig.getValue()).comp_2208()).setName((String)name.getValue()).setColor(((Color4I)col.getValue()).rgba());
                mapDimension.getWaypointManager().add(waypoint);
                this.refreshWidgets();
            }
        }).atMousePosition();
        overlay.setWidth(150);
        overlay.setX(Math.min(overlay.getX(), this.getScreen().method_4486() - 155));
        this.getGui().pushModalPanel((ModalPanel)overlay);
    }

    private static class SimpleTooltipButton
    extends SimpleButton {
        private final List<class_2561> tooltipLines;

        public SimpleTooltipButton(Panel panel, class_2561 text, Icon icon, SimpleButton.Callback c, class_2561 tooltipLine) {
            super(panel, text, icon, c);
            this.tooltipLines = List.of(tooltipLine);
        }

        public void addMouseOverText(TooltipList list) {
            super.addMouseOverText(list);
            this.tooltipLines.forEach(arg_0 -> ((TooltipList)list).add(arg_0));
        }
    }

    private class ClearDeathPointButton
    extends SimpleButton {
        public ClearDeathPointButton(Panel panel) {
            super(panel, (class_2561)class_2561.method_43471((String)"ftbchunks.gui.clear_deathpoints"), Icons.CANCEL, (b, m) -> {
                if (LargeMapScreen.this.getWaypointManager().removeIf(wp -> wp.getType() == WaypointType.DEATH)) {
                    LargeMapScreen.this.refreshWidgets();
                }
            });
        }

        public boolean shouldDraw() {
            return super.shouldDraw() && LargeMapScreen.this.getWaypointManager().hasDeathpoint();
        }

        public boolean isEnabled() {
            return this.shouldDraw();
        }
    }

    private static class MapKeyReferenceScreen
    extends KeyReferenceScreen {
        public MapKeyReferenceScreen() {
            super(new String[]{"ftbchunks.gui.large_map_info.text"});
        }

        public class_2561 getTitle() {
            return class_2561.method_43471((String)"ftbchunks.gui.large_map_info");
        }
    }
}

