/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.api.FTBChunksProperties;
import dev.ftb.mods.ftbchunks.data.ChunkTeamDataImpl;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManagerImpl;
import dev.ftb.mods.ftbchunks.net.SendPlayerPositionPacket;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public enum LongRangePlayerTracker {
    INSTANCE;

    private long lastTick = 0L;
    private final Table<UUID, UUID, class_2338> trackingMap = HashBasedTable.create();

    public void tick(MinecraftServer server) {
        int interval = (Integer)FTBChunksWorldConfig.LONG_RANGE_TRACKER_INTERVAL.get();
        if (interval != 0 && (long)server.method_3780() - this.lastTick > (long)interval) {
            this.lastTick = server.method_3780();
            List players = server.method_3760().method_14571();
            int maxDistSq = server.method_3760().method_14568() * server.method_3760().method_14568() * 256;
            players.forEach(trackingPlayer -> trackingPlayer.method_37908().method_18456().forEach(p2a -> {
                if (p2a instanceof class_3222) {
                    class_3222 trackedPlayer = (class_3222)p2a;
                    if (this.shouldTrack((class_3222)trackingPlayer, trackedPlayer, maxDistSq)) {
                        class_2338 lastPos = (class_2338)this.trackingMap.get((Object)trackingPlayer.method_5667(), (Object)trackedPlayer.method_5667());
                        if (lastPos == null || trackedPlayer.method_24515().method_10262((class_2382)lastPos) > 16.0) {
                            NetworkManager.sendToPlayer((class_3222)trackingPlayer, (class_8710)SendPlayerPositionPacket.startTracking(trackedPlayer));
                            this.trackingMap.put((Object)trackingPlayer.method_5667(), (Object)trackedPlayer.method_5667(), (Object)trackedPlayer.method_24515());
                        }
                    } else if (this.trackingMap.contains((Object)trackingPlayer.method_5667(), (Object)trackedPlayer.method_5667())) {
                        NetworkManager.sendToPlayer((class_3222)trackingPlayer, (class_8710)SendPlayerPositionPacket.stopTracking(trackedPlayer));
                        this.trackingMap.remove((Object)trackingPlayer.method_5667(), (Object)trackedPlayer.method_5667());
                    }
                }
            }));
        }
    }

    public void stopTracking(class_3222 player) {
        if (player.method_5682() == null) {
            return;
        }
        HashMap<UUID, UUID> toRemove = new HashMap<UUID, UUID>();
        for (UUID trackingId2 : this.trackingMap.rowKeySet()) {
            if (!this.trackingMap.contains((Object)trackingId2, (Object)player.method_5667())) continue;
            toRemove.put(trackingId2, player.method_5667());
        }
        toRemove.forEach((trackingId, disconnectedId) -> {
            class_3222 trackingPlayer = player.method_5682().method_3760().method_14602(trackingId);
            if (trackingPlayer != null) {
                NetworkManager.sendToPlayer((class_3222)trackingPlayer, (class_8710)SendPlayerPositionPacket.stopTracking(player));
            }
            this.trackingMap.remove(trackingId, disconnectedId);
        });
    }

    private boolean shouldTrack(class_3222 p1, class_3222 p2, int maxDistSq) {
        if (p1 == p2 || p1.method_5858((class_1297)p2) < (double)maxDistSq) {
            return false;
        }
        if (((Boolean)FTBChunksWorldConfig.LOCATION_MODE_OVERRIDE.get()).booleanValue()) {
            return true;
        }
        ChunkTeamDataImpl p2Team = ClaimedChunkManagerImpl.getInstance().getOrCreateData(p2);
        return p2Team != null && p2Team.canPlayerUse(p1, FTBChunksProperties.LOCATION_MODE);
    }
}

