/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.ftb.mods.ftbchunks.FTBCUtils;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.client.map.color.BlockColor;
import dev.ftb.mods.ftbchunks.client.map.color.BlockColors;
import dev.ftb.mods.ftbchunks.client.map.color.CustomBlockColor;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2189;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2269;
import net.minecraft.class_2358;
import net.minecraft.class_2362;
import net.minecraft.class_2372;
import net.minecraft.class_2397;
import net.minecraft.class_2459;
import net.minecraft.class_2504;
import net.minecraft.class_2527;
import net.minecraft.class_2541;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_5321;

public class ColorMapLoader
extends class_4080<JsonObject> {
    private static final Map<class_2960, BlockColor> BLOCK_ID_TO_COLOR_MAP = new HashMap<class_2960, BlockColor>();

    protected JsonObject prepare(class_3300 resourceManager, class_3695 profiler) {
        Gson gson = new GsonBuilder().setLenient().create();
        JsonObject object = new JsonObject();
        for (String namespace : resourceManager.method_14487()) {
            try {
                for (class_3298 resource : resourceManager.method_14489(class_2960.method_60655((String)namespace, (String)"ftbchunks_block_colors.json"))) {
                    try (InputStreamReader reader = new InputStreamReader(resource.method_14482(), StandardCharsets.UTF_8);){
                        for (Map.Entry entry : ((JsonObject)gson.fromJson((Reader)reader, JsonObject.class)).entrySet()) {
                            if (((String)entry.getKey()).startsWith("#")) {
                                object.add("#" + namespace + ":" + ((String)entry.getKey()).substring(1), (JsonElement)entry.getValue());
                                continue;
                            }
                            object.add(namespace + ":" + (String)entry.getKey(), (JsonElement)entry.getValue());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            catch (Exception exception) {
            }
        }
        return object;
    }

    protected void apply(JsonObject object, class_3300 resourceManager, class_3695 profiler) {
        BLOCK_ID_TO_COLOR_MAP.clear();
        for (Map.Entry entry : FTBChunks.BLOCK_REGISTRY.entrySet()) {
            class_2248 block = (class_2248)entry.getValue();
            class_2960 id = ((class_5321)entry.getKey()).method_29177();
            if (id == null) continue;
            if (block instanceof class_2189 || block instanceof class_2261 || block instanceof class_2358 || block instanceof class_2269 || block instanceof class_2527 && !(block instanceof class_2459) || block instanceof class_2504) {
                BLOCK_ID_TO_COLOR_MAP.put(id, BlockColors.IGNORED);
                continue;
            }
            if (block instanceof class_2372) {
                BLOCK_ID_TO_COLOR_MAP.put(id, BlockColors.GRASS);
                continue;
            }
            if (block instanceof class_2397 || block instanceof class_2541) {
                BLOCK_ID_TO_COLOR_MAP.put(id, BlockColors.FOLIAGE);
                continue;
            }
            if (block instanceof class_2362) {
                BLOCK_ID_TO_COLOR_MAP.put(id, new CustomBlockColor(Color4I.rgb((int)6830637)));
                continue;
            }
            if (FTBCUtils.isRail(block)) {
                BLOCK_ID_TO_COLOR_MAP.put(id, new CustomBlockColor(Color4I.rgb((int)0x888888)));
                continue;
            }
            if (block.method_26403() != null) {
                BLOCK_ID_TO_COLOR_MAP.put(id, new CustomBlockColor(Color4I.rgb((int)block.method_26403().field_16011)));
                continue;
            }
            BLOCK_ID_TO_COLOR_MAP.put(id, new CustomBlockColor(Color4I.RED));
        }
        for (Map.Entry entry : object.entrySet()) {
            BlockColor col;
            if (!((JsonElement)entry.getValue()).isJsonPrimitive() || (col = BlockColors.getFromType(((JsonElement)entry.getValue()).getAsString())) == null) continue;
            BLOCK_ID_TO_COLOR_MAP.put(class_2960.method_12829((String)((String)entry.getKey())), col);
        }
    }

    public static BlockColor getBlockColor(class_2960 id) {
        return BLOCK_ID_TO_COLOR_MAP.getOrDefault(id, BlockColors.IGNORED);
    }
}

