/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.registry;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.JsonOps;
import de.cristelknight.cristellib.CristelLib;
import de.cristelknight.cristellib.config.ConfigManager;
import de.cristelknight.cristellib.config.serialize.placement.PlacementConfig;
import de.cristelknight.cristellib.data.codec.StructureSetData;
import de.cristelknight.cristellib.util.JanksonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class ReadStructureSets {
    public static Map<class_2960, List<class_2960>> readSetsAndAddStructures(List<StructureSetData> structureSetHolder) {
        ImmutableMap.Builder structures = new ImmutableMap.Builder();
        structureSetHolder.forEach(holder -> holder.sets().forEach(setLocation -> {
            String modID = holder.modID();
            JsonElement e = JanksonUtil.getSetElement(modID, setLocation);
            if (ReadStructureSets.checkElement(e, modID, setLocation)) {
                return;
            }
            JsonArray structureArray = class_3518.method_15261((JsonObject)e.getAsJsonObject(), (String)"structures");
            ArrayList<class_2960> structureList = new ArrayList<class_2960>();
            for (JsonElement element : structureArray) {
                if (!element.isJsonObject()) continue;
                structureList.add(class_2960.method_12829((String)class_3518.method_15265((JsonObject)element.getAsJsonObject(), (String)"structure")));
            }
            structures.put(setLocation, structureList);
        }));
        return structures.build();
    }

    public static Map<class_2960, PlacementConfig> readSetsAndAddPlacements(List<StructureSetData> structureSetHolder) {
        ImmutableMap.Builder structurePlacement = new ImmutableMap.Builder();
        structureSetHolder.forEach(holder -> holder.sets().forEach(setLocation -> {
            String modID = holder.modID();
            JsonElement e = JanksonUtil.getSetElement(modID, setLocation);
            if (ReadStructureSets.checkElement(e, modID, setLocation)) {
                return;
            }
            JsonObject placement = class_3518.method_15296((JsonObject)e.getAsJsonObject(), (String)"placement");
            PlacementConfig config = ConfigManager.readElement(String.format("Couldn't read %s in %s, crashing instead. Maybe try to delete the config files!", setLocation, modID), PlacementConfig.CODEC, JsonOps.INSTANCE, placement);
            structurePlacement.put(setLocation, (Object)config);
        }));
        return structurePlacement.build();
    }

    private static boolean checkElement(JsonElement element, String modID, class_2960 setLocation) {
        if (!element.isJsonObject()) {
            CristelLib.LOGGER.error("Set for {} {} is not a JsonObject", (Object)modID, (Object)setLocation);
            return true;
        }
        return false;
    }
}

