/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.builtinpacks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.cristelknight.cristellib.CristelLib;
import de.cristelknight.cristellib.builtinpacks.BuiltinResourcePackSource;
import de.cristelknight.cristellib.util.JanksonUtil;
import de.cristelknight.cristellib.util.RuntimePackUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3258;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3518;
import net.minecraft.class_5352;
import net.minecraft.class_7367;
import net.minecraft.class_9224;
import net.minecraft.class_9226;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RuntimePack
implements class_3262 {
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    private final Lock waiting = new ReentrantLock();
    private final Map<class_2960, Supplier<byte[]>> data = new ConcurrentHashMap<class_2960, Supplier<byte[]>>();
    private final Map<List<String>, Supplier<byte[]>> root = new ConcurrentHashMap<List<String>, Supplier<byte[]>>();
    public final int packVersion;
    private final String id;
    private final class_9224 metadata;

    public RuntimePack(class_2960 id, int version, String description, @Nullable Path imageFile) {
        byte[] image;
        this.packVersion = version;
        this.id = id.toString();
        this.metadata = new class_9224(this.id, (class_2561)class_2561.method_43470((String)description), (class_5352)new BuiltinResourcePackSource(), Optional.of(new class_9226("cristellib", this.id, String.valueOf(version))));
        if (imageFile != null && (image = RuntimePackUtil.extractImageBytes(imageFile)) != null) {
            this.addRootResource("pack.png", image);
        }
        if (!this.hasRootResource("pack.mcmeta")) {
            JsonObject object = new JsonObject();
            JsonObject pack = new JsonObject();
            pack.addProperty("pack_format", (Number)this.packVersion);
            pack.addProperty("min_format", (Number)this.packVersion);
            pack.addProperty("max_format", (Number)this.packVersion);
            pack.addProperty("description", description);
            object.add("pack", (JsonElement)pack);
            this.addRootResource("pack.mcmeta", RuntimePackUtil.serializeJson(object));
        }
    }

    public byte[] addStructureSet(class_2960 identifier, JsonObject set) {
        return this.addDataForJsonLocation("worldgen/structure_set", identifier, set);
    }

    public byte[] addBiome(class_2960 identifier, JsonObject biome) {
        return this.addDataForJsonLocation("worldgen/biome", identifier, biome);
    }

    public byte[] addStructure(class_2960 identifier, JsonObject structure) {
        return this.addDataForJsonLocation("worldgen/structure", identifier, structure);
    }

    public byte[] addLootTable(class_2960 identifier, JsonObject table) {
        return this.addDataForJsonLocation("loot_tables", identifier, table);
    }

    public byte @Nullable [] addDataForJsonLocationFromPath(String prefix, class_2960 identifier, String fromSubPath, String fromModID) {
        JsonElement jsonElement = JanksonUtil.getElement(fromModID, fromSubPath);
        if (jsonElement instanceof JsonObject) {
            JsonObject object = (JsonObject)jsonElement;
            return this.addDataForJsonLocation(prefix, identifier, object);
        }
        return null;
    }

    public byte[] addDataForJsonLocation(String prefix, class_2960 identifier, JsonObject object) {
        return this.addAndSerializeDataForLocation(prefix, "json", identifier, object);
    }

    public byte[] addAndSerializeDataForLocation(String prefix, String end, class_2960 identifier, JsonObject object) {
        return this.addData(class_2960.method_60655((String)identifier.method_12836(), (String)(prefix + "/" + identifier.method_12832() + "." + end)), RuntimePackUtil.serializeJson(object));
    }

    public byte[] addData(class_2960 path, byte[] data) {
        this.data.put(path, () -> data);
        return data;
    }

    public void removeData(class_2960 path) {
        this.data.remove(path);
    }

    public byte[] addRootResource(String path, byte[] data) {
        this.root.put(Arrays.asList(path.split("/")), () -> data);
        return data;
    }

    @Nullable
    public class_7367<InputStream> method_14410(String ... strings) {
        this.lock();
        Supplier<byte[]> supplier = this.root.get(Arrays.asList(strings));
        if (supplier == null) {
            this.waiting.unlock();
            return null;
        }
        this.waiting.unlock();
        return () -> new ByteArrayInputStream((byte[])supplier.get());
    }

    public boolean hasRootResource(String ... strings) {
        return this.root.containsKey(Arrays.asList(strings));
    }

    @Nullable
    public class_7367<InputStream> method_14405(@NotNull class_3264 packType, @NotNull class_2960 id) {
        this.lock();
        Supplier<byte[]> supplier = this.data.get(id);
        if (supplier == null) {
            this.waiting.unlock();
            return null;
        }
        this.waiting.unlock();
        return () -> new ByteArrayInputStream((byte[])supplier.get());
    }

    public boolean hasResource(class_2960 location) {
        return this.data.containsKey(location);
    }

    public void method_14408(@NotNull class_3264 packType, @NotNull String namespace, @NotNull String prefix, @NotNull class_3262.class_7664 resourceOutput) {
        this.lock();
        for (class_2960 identifier : this.data.keySet()) {
            Supplier<byte[]> supplier = this.data.get(identifier);
            if (supplier == null) {
                this.waiting.unlock();
                continue;
            }
            if (!identifier.method_12836().equals(namespace) || !identifier.method_12832().contains(prefix + "/")) continue;
            class_7367 inputSupplier = () -> new ByteArrayInputStream((byte[])supplier.get());
            resourceOutput.accept((Object)identifier, (Object)inputSupplier);
        }
        this.waiting.unlock();
    }

    @NotNull
    public Set<String> method_14406(@NotNull class_3264 packType) {
        this.lock();
        HashSet<String> namespaces = new HashSet<String>();
        for (class_2960 identifier : this.data.keySet()) {
            namespaces.add(identifier.method_12836());
        }
        this.waiting.unlock();
        return namespaces;
    }

    @Nullable
    public <T> T method_14407(class_3270<T> metadataSectionSerializer) {
        InputStream stream = null;
        try {
            class_7367<InputStream> supplier = this.method_14410("pack.mcmeta");
            if (supplier != null) {
                stream = (InputStream)supplier.get();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (stream == null) {
            CristelLib.LOGGER.error("Couldn't find pack.mcmeta of the Runtime Pack: {}", (Object)this.id);
        }
        return (T)class_3258.method_14392(metadataSectionSerializer, (InputStream)stream);
    }

    @NotNull
    public class_9224 method_56926() {
        return this.metadata;
    }

    @NotNull
    public String method_14409() {
        return this.id;
    }

    private void lock() {
        if (!this.waiting.tryLock()) {
            this.waiting.lock();
        }
    }

    public void close() {
        CristelLib.LOGGER.debug("Closing RDP: {}", (Object)this.id);
    }

    public void load(Path dir) throws IOException {
        Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);
        for (Path file : () -> stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(dir::relativize).iterator()) {
            String s = file.toString();
            if (s.startsWith("data")) {
                String path = s.substring("data".length() + 1);
                this.load(path, this.data, Files.readAllBytes(file));
                continue;
            }
            if (s.startsWith("assets")) continue;
            byte[] data = Files.readAllBytes(file);
            this.root.put(Arrays.asList(s.split("/")), () -> data);
        }
    }

    public void load(ZipInputStream stream) throws IOException {
        ZipEntry entry;
        while ((entry = stream.getNextEntry()) != null) {
            String s = entry.toString();
            if (s.startsWith("data")) {
                String path = s.substring("data".length() + 1);
                this.load(path, this.data, this.read(entry, stream));
                continue;
            }
            if (s.startsWith("assets")) continue;
            byte[] data = this.read(entry, stream);
            this.root.put(Arrays.asList(s.split("/")), () -> data);
        }
    }

    protected byte[] read(ZipEntry entry, InputStream stream) throws IOException {
        byte[] data = new byte[Math.toIntExact(entry.getSize())];
        if (stream.read(data) != data.length) {
            throw new IOException("Zip stream was cut off! (maybe incorrect zip entry length? maybe u didn't flush your stream?)");
        }
        return data;
    }

    protected void load(String fullPath, Map<class_2960, Supplier<byte[]>> map, byte[] data) {
        int sep = fullPath.indexOf(47);
        String namespace = fullPath.substring(0, sep);
        String path = fullPath.substring(sep + 1);
        map.put(class_2960.method_60655((String)namespace, (String)path), () -> data);
    }

    @Nullable
    public JsonObject getResource(class_2960 location) {
        JsonObject jsonObject;
        class_7367<InputStream> stream = this.method_14405(class_3264.field_14190, location);
        try {
            jsonObject = class_3518.method_15255((Reader)new BufferedReader(new InputStreamReader((InputStream)stream.get())));
        }
        catch (IOException | NullPointerException ex) {
            CristelLib.LOGGER.error("Couldn't get JsonObject from location: {}", (Object)location, (Object)ex);
            return null;
        }
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpToFolder(Path output) throws IOException {
        this.lock();
        try {
            Path filePath;
            for (Map.Entry<List<String>, Supplier<byte[]>> entry : this.root.entrySet()) {
                List<String> pathParts = entry.getKey();
                filePath = output.resolve(Paths.get("", pathParts.toArray(new String[0])));
                Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                Files.write(filePath, entry.getValue().get(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            for (Map.Entry<List<String>, Supplier<byte[]>> entry : this.data.entrySet()) {
                class_2960 rl = (class_2960)entry.getKey();
                filePath = output.resolve(Paths.get("data", rl.method_12836(), rl.method_12832()));
                Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                Files.write(filePath, entry.getValue().get(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
        }
        finally {
            this.waiting.unlock();
        }
    }
}

