/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.convenientdecor.init.group;

import com.github.mim1q.convenientdecor.ConvenientDecor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public abstract class ColoredGroup<T, U extends ColoredGroup<T, U>> {
    private final Map<class_1767, T> entries = new HashMap<class_1767, T>();

    protected ColoredGroup() {
    }

    public U add(class_1767 color, ColoredConstructor<T> constructor) {
        this.entries.put(color, constructor.create(color));
        return (U)this;
    }

    public U add16Colors(ColoredConstructor<T> constructor) {
        for (class_1767 color : class_1767.values()) {
            this.entries.put(color, constructor.create(color));
        }
        return (U)this;
    }

    public T get(class_1767 color) {
        return this.entries.get(color);
    }

    public List<T> getList() {
        return List.of(this.get(class_1767.field_7963), this.get(class_1767.field_7944), this.get(class_1767.field_7967), this.get(class_1767.field_7952), this.get(class_1767.field_7957), this.get(class_1767.field_7966), this.get(class_1767.field_7955), this.get(class_1767.field_7951), this.get(class_1767.field_7961), this.get(class_1767.field_7942), this.get(class_1767.field_7947), this.get(class_1767.field_7946), this.get(class_1767.field_7964), this.get(class_1767.field_7954), this.get(class_1767.field_7958), this.get(class_1767.field_7945));
    }

    protected abstract void registerSingle(class_2960 var1, T var2);

    public U register(String baseName) {
        for (Map.Entry<class_1767, T> entry : this.entries.entrySet()) {
            this.registerSingle(ConvenientDecor.id(entry.getKey().method_7792() + "_" + baseName), entry.getValue());
        }
        return (U)this;
    }

    public static ColoredItemGroup ofItems() {
        return new ColoredItemGroup();
    }

    public static ColoredBlockGroup ofBlocks(boolean withBlockItem) {
        return new ColoredBlockGroup(withBlockItem);
    }

    @FunctionalInterface
    public static interface ColoredConstructor<T> {
        public T create(class_1767 var1);
    }

    public static class ColoredItemGroup
    extends ColoredGroup<class_1792, ColoredItemGroup> {
        @Override
        protected void registerSingle(class_2960 id, class_1792 entry) {
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)id, (Object)entry);
        }

        public List<class_1799> getItemStackList() {
            return this.getList().stream().map(item -> item.method_7854()).toList();
        }
    }

    public static class ColoredBlockGroup
    extends ColoredGroup<class_2248, ColoredBlockGroup> {
        private final boolean withBlockItem;

        protected ColoredBlockGroup(boolean withBlockItem) {
            this.withBlockItem = withBlockItem;
        }

        @Override
        protected void registerSingle(class_2960 id, class_2248 entry) {
            class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)id, (Object)entry);
            if (this.withBlockItem) {
                class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)id, (Object)new class_1747(entry, new class_1792.class_1793()));
            }
        }

        public List<class_1799> getItemStackList() {
            return this.getList().stream().map(block -> block.method_8389().method_7854()).toList();
        }
    }
}

