/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.forge.services;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_forge.services.helpers.RegisterItemHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ForgeRegisterItemHelper
implements RegisterItemHelper {
    private static final HashMap<String, DeferredRegister<Item>> deferredItemRegisterMap = new HashMap();
    private static final HashMap<ResourceLocation, RegistryObject<Item>> registeredItems = new HashMap();
    private static final List<Pair<ResourceKey<CreativeModeTab>, RegistryObject<Item>>> creativeInventoryItemPairs = new ArrayList<Pair<ResourceKey<CreativeModeTab>, RegistryObject<Item>>>();

    @Override
    public <T extends Item> void registerItem(Object modEventBusObject, ResourceLocation resourceLocation, Supplier<T> itemSupplier, ResourceKey<CreativeModeTab> creativeModeTabResourceKey, boolean lastItem) {
        ForgeRegisterItemHelper.staticRegisterItem(modEventBusObject, resourceLocation, itemSupplier, creativeModeTabResourceKey, lastItem);
    }

    @Override
    public Item getRegisteredItem(ResourceLocation resourceLocation) {
        return (Item)registeredItems.get(resourceLocation).get();
    }

    public static <T extends Item> RegistryObject<Item> staticRegisterItem(Object modEventBusObject, ResourceLocation resourceLocation, Supplier<T> itemSupplier, ResourceKey<CreativeModeTab> creativeModeTabResourceKey, boolean lastItem) {
        String namespace = resourceLocation.getNamespace();
        if (!deferredItemRegisterMap.containsKey(namespace)) {
            DeferredRegister deferredItemRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)namespace);
            deferredItemRegisterMap.put(namespace, (DeferredRegister<Item>)deferredItemRegister);
        }
        RegistryObject deferredItemObject = deferredItemRegisterMap.get(namespace).register(resourceLocation.getPath(), itemSupplier);
        registeredItems.put(resourceLocation, (RegistryObject<Item>)deferredItemObject);
        if (creativeModeTabResourceKey != null) {
            creativeInventoryItemPairs.add((Pair<ResourceKey<CreativeModeTab>, RegistryObject<Item>>)Pair.of(creativeModeTabResourceKey, (Object)deferredItemObject));
        }
        if (lastItem) {
            deferredItemRegisterMap.get(namespace).register((IEventBus)modEventBusObject);
        }
        return deferredItemObject;
    }

    public static void addItemsToCreativeInventory(BuildCreativeModeTabContentsEvent e) {
        for (Pair<ResourceKey<CreativeModeTab>, RegistryObject<Item>> tabPair : creativeInventoryItemPairs) {
            if (!e.getTabKey().equals(tabPair.getFirst())) continue;
            e.accept((ItemLike)((RegistryObject)tabPair.getSecond()).get());
        }
    }
}

