/*
 * Decompiled with CFR 0.152.
 */
package com.cobeffectiveness.type;

import com.cobeffectiveness.CobEffectiveness;
import com.cobeffectiveness.type.ChartJson;
import com.cobeffectiveness.type.Type;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public final class EffectivenessChart {
    private static final Map<Type, Map<Type, Double>> MAP = new EnumMap<Type, Map<Type, Double>>(Type.class);

    private EffectivenessChart() {
    }

    public static void configure(ChartJson json, Function<String, Type> nameMapper) {
        MAP.clear();
        for (Type atk : Type.values()) {
            EnumMap<Type, Double> inner = new EnumMap<Type, Double>(Type.class);
            for (Type def : Type.values()) {
                inner.put(def, json.default_);
            }
            MAP.put(atk, inner);
        }
        if (json.rules != null) {
            for (ChartJson.Rule r : json.rules) {
                Type atk = nameMapper.apply(r.attack);
                Type def = nameMapper.apply(r.defend);
                if (atk == null || def == null) {
                    CobEffectiveness.logWarn("Unknown type in rule: {} -> {}", String.valueOf(r.attack), String.valueOf(r.defend));
                    continue;
                }
                MAP.get((Object)atk).put(def, r.mult);
            }
        }
    }

    public static double effectiveness(Type attack, Set<Type> defender) {
        double m = 1.0;
        Map<Type, Double> row = MAP.get((Object)attack);
        if (row == null) {
            return 1.0;
        }
        for (Type d : defender) {
            m *= row.getOrDefault((Object)d, 1.0).doubleValue();
        }
        return m;
    }

    public static Map<Double, Set<Type>> attackersByMultipliers(Set<Type> defender, double ... targets) {
        LinkedHashMap<Double, Set<Type>> out = new LinkedHashMap<Double, Set<Type>>();
        for (double t : targets) {
            out.put(t, EnumSet.noneOf(Type.class));
        }
        for (Type atk : Type.values()) {
            double m = EffectivenessChart.effectiveness(atk, defender);
            for (double t : targets) {
                if (!(Math.abs(m - t) < 1.0E-6)) continue;
                ((Set)out.get(t)).add(atk);
            }
        }
        return out;
    }
}

