/*
 * Decompiled with CFR 0.152.
 */
package com.cobeffectiveness.fabric.ui;

import com.cobeffectiveness.battle.OpponentSnapshot;
import com.cobeffectiveness.type.EffectivenessChart;
import com.cobeffectiveness.type.Type;
import com.cobeffectiveness.ui.IconRenderer;
import com.cobeffectiveness.ui.PanelRenderer;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;

public final class EffectivenessHud {
    private static final int RIGHT_MARGIN = 12;
    private static final int TOP_OFFSET = 56;
    private static final int PAD_X = 6;
    private static final int PAD_Y = 6;
    private static final int LABEL_GAP = 4;
    private static final int ROW_GAP = 4;
    private static final int DIV_H = 1;
    private final class_310 mc = class_310.method_1551();

    public void render(class_332 dc) {
        OpponentSnapshot.current().ifPresent(opponentTypes -> {
            int rowX;
            if (opponentTypes.isEmpty()) {
                return;
            }
            Map<Double, Set<Type>> groups = EffectivenessChart.attackersByMultipliers(opponentTypes, 4.0, 2.0);
            Set<Type> fourX = groups.get(4.0);
            Set<Type> twoX = groups.get(2.0);
            if ((fourX == null || fourX.isEmpty()) && (twoX == null || twoX.isEmpty())) {
                return;
            }
            Objects.requireNonNull(this.mc.field_1772);
            int fontH = 9;
            int iconH = IconRenderer.rowHeight();
            String L4 = "\u00d74";
            String L2 = "\u00d72";
            int L4w = this.mc.field_1772.method_1727("\u00d74");
            int L2w = this.mc.field_1772.method_1727("\u00d72");
            int fourW = IconRenderer.rowWidth(fourX != null ? fourX.size() : 0);
            int twoW = IconRenderer.rowWidth(twoX != null ? twoX.size() : 0);
            int row4W = fourW > 0 ? L4w + 4 + fourW : 0;
            int row2W = twoW > 0 ? L2w + 4 + twoW : 0;
            int innerW = Math.max(row4W, row2W);
            if (innerW == 0) {
                return;
            }
            int panelH = 6;
            if (row4W > 0) {
                panelH += iconH;
            }
            if (row4W > 0 && row2W > 0) {
                panelH += 9;
            }
            if (row2W > 0) {
                panelH += iconH;
            }
            int panelW = innerW + 12;
            int sw = this.mc.method_22683().method_4486();
            int x = sw - 12 - panelW;
            int y = 56;
            PanelRenderer.drawPanel(dc, x, y, panelW, panelH += 6);
            int cursorY = y + 6;
            int labelYOffset = (iconH - fontH) / 2 + 1;
            if (row4W > 0) {
                rowX = x + 6 + (innerW - row4W) / 2;
                dc.method_27535(this.mc.field_1772, (class_2561)class_2561.method_43470((String)"\u00d74"), rowX, cursorY + labelYOffset, -8090);
                IconRenderer.drawTypes(dc, rowX + L4w + 4, cursorY, fourX);
                cursorY += iconH;
            }
            if (row4W > 0 && row2W > 0) {
                PanelRenderer.drawDivider(dc, x + 6, cursorY += 4, innerW);
                cursorY += 5;
            }
            if (row2W > 0) {
                rowX = x + 6 + (innerW - row2W) / 2;
                dc.method_27535(this.mc.field_1772, (class_2561)class_2561.method_43470((String)"\u00d72"), rowX, cursorY + labelYOffset, -4734721);
                IconRenderer.drawTypes(dc, rowX + L2w + 4, cursorY, twoX);
            }
        });
    }
}

