/*
 * Decompiled with CFR 0.152.
 */
package com.arcaryx.cobblemonintegrations.enhancedcelestials;

import com.arcaryx.cobblemonintegrations.enhancedcelestials.PokemonLunarEvent;
import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.spawning.context.SpawningContext;
import com.cobblemon.mod.common.pokemon.IVs;
import dev.corgitaco.enhancedcelestials.EnhancedCelestials;
import dev.corgitaco.enhancedcelestials.api.EnhancedCelestialsRegistry;
import dev.corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import dev.corgitaco.enhancedcelestials.lunarevent.EnhancedCelestialsLunarForecastWorldData;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.random.Random;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001d\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0014\u0010\u0015J)\u0010\u0019\u001a\u00020\u000f2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00120\u00162\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001d\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lcom/arcaryx/cobblemonintegrations/enhancedcelestials/EnhancedCelestialsHandler;", "", "<init>", "()V", "Lnet/minecraft/class_1937;", "level", "Lnet/minecraft/class_2960;", "lunarEvent", "", "isOngoingLunarEvent", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2960;)Z", "Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "props", "Lcom/cobblemon/mod/common/api/spawning/context/SpawningContext;", "ctx", "", "modifySpawns", "(Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;Lcom/cobblemon/mod/common/api/spawning/context/SpawningContext;)V", "", "baseExp", "modifyBattleExp", "(ILnet/minecraft/class_1937;)I", "", "Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;", "baseChanges", "modifyBattleEVs", "(Ljava/util/Map;Lnet/minecraft/class_1937;)V", "eventLocation", "Lnet/minecraft/class_2561;", "getLunarEventName", "(Lnet/minecraft/class_2960;Lnet/minecraft/class_1937;)Lnet/minecraft/class_2561;", "cobblemonintegrations-common-1.21.1"})
public final class EnhancedCelestialsHandler {
    @NotNull
    public static final EnhancedCelestialsHandler INSTANCE = new EnhancedCelestialsHandler();

    private EnhancedCelestialsHandler() {
    }

    public final boolean isOngoingLunarEvent(@NotNull class_1937 level, @NotNull class_2960 lunarEvent) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)lunarEvent, (String)"lunarEvent");
        Optional lunarForecastWorldData = EnhancedCelestials.lunarForecastWorldData((class_1937)level);
        return lunarForecastWorldData.isPresent() && ((EnhancedCelestialsLunarForecastWorldData)lunarForecastWorldData.get()).currentLunarEventHolder().method_40226(lunarEvent);
    }

    public final void modifySpawns(@NotNull PokemonProperties props, @NotNull SpawningContext ctx) {
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        class_3218 level = ctx.getWorld();
        Optional lunarForecastWorldData = EnhancedCelestials.lunarForecastWorldData((class_1937)((class_1937)level));
        if (lunarForecastWorldData.isPresent()) {
            class_2378 registry = level.method_30349().method_30530(PokemonLunarEvent.Companion.getKEY());
            for (PokemonLunarEvent event : registry) {
                if (!((EnhancedCelestialsLunarForecastWorldData)lunarForecastWorldData.get()).currentLunarEventHolder().method_40226(event.getLunarEvent())) continue;
                if (Cobblemon.INSTANCE.getConfig().getShinyRate() >= 1.0f && event.getShinyMultiplier() > 0.0f) {
                    float modifiedShinyRate = Cobblemon.INSTANCE.getConfig().getShinyRate() / event.getShinyMultiplier();
                    if (Random.Default.nextFloat() < 1.0f / modifiedShinyRate) {
                        props.setShiny(Boolean.valueOf(true));
                    }
                }
                if (event.getPerfIVs() <= 0) break;
                props.setIvs(IVs.Companion.createRandomIVs(event.getPerfIVs()));
                break;
            }
        }
    }

    public final int modifyBattleExp(int baseExp, @NotNull class_1937 level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Optional lunarForecastWorldData = EnhancedCelestials.lunarForecastWorldData((class_1937)level);
        if (lunarForecastWorldData.isPresent()) {
            class_2378 registry = level.method_30349().method_30530(PokemonLunarEvent.Companion.getKEY());
            for (PokemonLunarEvent event : registry) {
                if (!((EnhancedCelestialsLunarForecastWorldData)lunarForecastWorldData.get()).currentLunarEventHolder().method_40226(event.getLunarEvent())) continue;
                return MathKt.roundToInt((float)((float)baseExp * event.getExpMultiplier()));
            }
        }
        return baseExp;
    }

    public final void modifyBattleEVs(@NotNull Map<Stat, Integer> baseChanges, @NotNull class_1937 level) {
        Intrinsics.checkNotNullParameter(baseChanges, (String)"baseChanges");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Optional lunarForecastWorldData = EnhancedCelestials.lunarForecastWorldData((class_1937)level);
        if (lunarForecastWorldData.isPresent()) {
            class_2378 registry = level.method_30349().method_30530(PokemonLunarEvent.Companion.getKEY());
            for (PokemonLunarEvent event : registry) {
                if (!((EnhancedCelestialsLunarForecastWorldData)lunarForecastWorldData.get()).currentLunarEventHolder().method_40226(event.getLunarEvent())) continue;
                for (Stat stat : baseChanges.keySet()) {
                    Integer n = baseChanges.get(stat);
                    int base = n != null ? n : 0;
                    baseChanges.put(stat, MathKt.roundToInt((float)((float)Math.ceil((float)base * event.getEvMultiplier()))));
                }
            }
        }
    }

    @NotNull
    public final class_2561 getLunarEventName(@NotNull class_2960 eventLocation, @NotNull class_1937 level) {
        Intrinsics.checkNotNullParameter((Object)eventLocation, (String)"eventLocation");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        class_2378 class_23782 = level.method_30349().method_30530(EnhancedCelestialsRegistry.LUNAR_EVENT_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)class_23782, (String)"registryOrThrow(...)");
        class_2378 lunarEventRegistry = class_23782;
        LunarEvent lunarEvent = (LunarEvent)lunarEventRegistry.method_10223(eventLocation);
        if (lunarEvent != null) {
            class_2561 class_25612 = lunarEvent.getTextComponents().name().getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)class_25612, (String)"getComponent(...)");
            return class_25612;
        }
        class_5250 class_52502 = class_2561.method_43470((String)eventLocation.method_12832());
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"literal(...)");
        return (class_2561)class_52502;
    }
}

