/*
 * Decompiled with CFR 0.152.
 */
package dev.ripio.cobbleloots.util.io;

import dev.ripio.cobbleloots.Cobbleloots;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CobblelootsYamlParser {
    public static Map<String, Object> parse(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            Object parsed = CobblelootsYamlParser.parseYaml(lines, 0);
            if (parsed instanceof Map) {
                result.putAll((Map)parsed);
                LinkedHashMap<String, Object> linkedHashMap = result;
                return linkedHashMap;
            }
            if (parsed instanceof List) {
                Cobbleloots.LOGGER.warn("Parsed YAML is a List, expected Map: " + String.valueOf(parsed));
            } else {
                Cobbleloots.LOGGER.warn("Parsed YAML is not a Map or List: " + String.valueOf(parsed));
            }
            Map<String, Object> map = Collections.emptyMap();
            return map;
        }
    }

    public static Object parseYaml(List<String> lines, int indent) {
        LinkedHashMap result = null;
        int i = 0;
        while (i < lines.size()) {
            String line = lines.get(i).replaceAll("\\t", "  ");
            if (line.trim().isEmpty() || line.trim().startsWith("#")) {
                ++i;
                continue;
            }
            int currentIndent = line.indexOf(line.trim());
            if (currentIndent < indent) break;
            if ((line = line.trim()).startsWith("- ")) {
                String item;
                if (!(result instanceof List)) {
                    result = new ArrayList();
                }
                if ((item = line.substring(2).trim()).isEmpty()) {
                    String nextLine;
                    int nextIndent;
                    ArrayList<String> subLines = new ArrayList<String>();
                    ++i;
                    while (i < lines.size() && (nextIndent = (nextLine = lines.get(i).replaceAll("\\t", "  ")).indexOf(nextLine.trim())) > currentIndent) {
                        subLines.add(nextLine);
                        ++i;
                    }
                    ((List)((Object)result)).add(CobblelootsYamlParser.parseYaml(subLines, currentIndent + 2));
                    continue;
                }
                ((List)((Object)result)).add(CobblelootsYamlParser.parseValue(item));
            } else if (line.contains(":")) {
                if (!(result instanceof Map)) {
                    result = new LinkedHashMap();
                }
                String[] parts = line.split(":", 2);
                String key = parts[0].trim();
                String value = parts[1].trim();
                if (value.isEmpty()) {
                    String nextLine;
                    int nextIndent;
                    ArrayList<String> subLines = new ArrayList<String>();
                    ++i;
                    while (i < lines.size() && (nextIndent = (nextLine = lines.get(i)).indexOf(nextLine.trim())) > currentIndent) {
                        subLines.add(nextLine);
                        ++i;
                    }
                    ((Map)result).put(key, CobblelootsYamlParser.parseYaml(subLines, currentIndent + 2));
                    continue;
                }
                ((Map)result).put(key, CobblelootsYamlParser.parseValue(value));
            } else {
                result = CobblelootsYamlParser.parseValue(line);
            }
            ++i;
        }
        return result;
    }

    private static Object parseValue(String value) {
        if (value.startsWith("[") && value.endsWith("]")) {
            ArrayList<String> list = new ArrayList<String>();
            String content = value.substring(1, value.length() - 1).trim();
            if (!content.isEmpty()) {
                String[] items;
                for (String item : items = content.split(",")) {
                    list.add(item.trim());
                }
            }
            return list;
        }
        return value;
    }
}

