/*
 * Decompiled with CFR 0.152.
 */
package dev.ripio.cobbleloots.util.enums;

public enum CobblelootsSourceType {
    GENERATION("generation"),
    SPAWNING("spawning"),
    FISHING("fishing"),
    ARCHAEOLOGY("archaeology");

    private final String name;

    private CobblelootsSourceType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static CobblelootsSourceType fromName(String name) {
        for (CobblelootsSourceType type : CobblelootsSourceType.values()) {
            if (!type.getName().equals(name)) continue;
            return type;
        }
        return null;
    }

    public static boolean isValid(String name) {
        return CobblelootsSourceType.fromName(name) != null;
    }

    public static boolean isValid(CobblelootsSourceType type) {
        return type != null;
    }

    public static int getLength() {
        return CobblelootsSourceType.values().length;
    }
}

