/*
 * Decompiled with CFR 0.152.
 */
package dev.ripio.cobbleloots.entity.custom;

import dev.ripio.cobbleloots.config.CobblelootsConfig;
import dev.ripio.cobbleloots.data.CobblelootsDataProvider;
import dev.ripio.cobbleloots.data.custom.CobblelootsLootBallData;
import dev.ripio.cobbleloots.data.custom.CobblelootsLootBallVariantData;
import dev.ripio.cobbleloots.entity.custom.CobblelootsBaseContainerEntity;
import dev.ripio.cobbleloots.item.CobblelootsItems;
import dev.ripio.cobbleloots.sound.CobblelootsLootBallSounds;
import dev.ripio.cobbleloots.util.CobblelootsDefinitions;
import dev.ripio.cobbleloots.util.CobblelootsUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_7094;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CobblelootsLootBall
extends CobblelootsBaseContainerEntity {
    private static final int CONTAINER_SIZE = 1;
    private final class_2371<class_1799> itemStacks = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    public final class_7094 openingAnimationState = new class_7094();
    private static final int LOOT_BALL_OPENING_TICKS = 50;
    private static final int LOOT_BALL_OPENING_DROP_TICK = 25;
    private static final float PARTICLE_SPAWN_CHANCE = 0.05f;
    private static final double PARTICLE_OFFSET_MULTIPLIER = 0.1;
    private static final double PARTICLE_Y_FIXED_OFFSET = 0.5;
    private static final double PARTICLE_VELOCITY_MULTIPLIER = 0.1;
    private boolean isOpening = false;
    private class_3222 pendingOpener = null;
    private boolean wasInvisible = false;
    private static final class_2940<Integer> OPENING_TICKS = class_2945.method_12791(CobblelootsLootBall.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> SPARKS = class_2945.method_12791(CobblelootsLootBall.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> INVISIBLE = class_2945.method_12791(CobblelootsLootBall.class, (class_2941)class_2943.field_13323);
    private static final class_2940<String> CUSTOM_TEXTURE = class_2945.method_12791(CobblelootsLootBall.class, (class_2941)class_2943.field_13326);
    private static final class_2940<String> LOOT_BALL_DATA_ID = class_2945.method_12791(CobblelootsLootBall.class, (class_2941)class_2943.field_13326);
    private static final class_2940<String> VARIANT_ID = class_2945.method_12791(CobblelootsLootBall.class, (class_2941)class_2943.field_13326);
    private static final class_2940<class_2487> LOOT_BALL_CLIENT_DATA = class_2945.method_12791(CobblelootsLootBall.class, (class_2941)class_2943.field_13318);
    public static final String TAG_SPARKS = "Sparks";
    public static final String TAG_INVISIBLE = "Invisible";
    public static final String TAG_CUSTOM_TEXTURE = "Texture";
    public static final String TAG_LOOT_BALL_DATA_ID = "LootBallData";
    public static final String TAG_VARIANT_ID = "Variant";
    private static final String TAG_OPENERS = "Openers";
    private static final String TAG_USES = "Uses";
    private static final String TAG_MULTIPLIER = "Multiplier";
    private static final String TAG_DESPAWN_TICK = "DespawnTick";
    private static final String TAG_PLAYER_TIMER = "PlayerTimer";
    private static final String TAG_XP = "XP";
    private static final String TEXT_ERROR_IS_OPENING = "entity.cobbleloots.loot_ball.error.is_opening";
    private static final String TEXT_ERROR_ALREADY_OPENED = "entity.cobbleloots.loot_ball.error.already_opened";
    private static final String TEXT_ERROR_COOLDOWN = "entity.cobbleloots.loot_ball.error.cooldown";
    private static final String TEXT_INFO_NO_LOOT = "entity.cobbleloots.loot_ball.info.no_loot";
    private static final String TEXT_OPEN_SUCCESS = "entity.cobbleloots.loot_ball.open.success";
    private static final String TEXT_OPEN_SUCCESS_BONUS = "entity.cobbleloots.loot_ball.open.success.bonus";
    private static final String TEXT_SET_ITEM = "entity.cobbleloots.loot_ball.set.item";
    private static final String TEXT_TOGGLE_VISIBILITY = "entity.cobbleloots.loot_ball.toggle.visibility";
    private static final String TEXT_TOGGLE_SPARKS = "entity.cobbleloots.loot_ball.toggle.sparks";
    private static final float DEFAULT_MULTIPLIER = CobblelootsConfig.getFloatConfig("loot_ball.defaults.multiplier");
    private static final int DEFAULT_USES = CobblelootsConfig.getIntConfig("loot_ball.defaults.uses");
    private static final long DEFAULT_DESPAWN_TICK = CobblelootsConfig.getLongConfig("loot_ball.defaults.despawn_tick");
    private static final long DEFAULT_PLAYER_TIMER = CobblelootsConfig.getLongConfig("loot_ball.defaults.player_timer");
    private static final int DEFAULT_XP = CobblelootsConfig.getIntConfig("loot_ball.defaults.xp");
    protected final Map<UUID, Long> openers = new HashMap<UUID, Long>();
    protected int uses = DEFAULT_USES;
    protected float multiplier = DEFAULT_MULTIPLIER;
    protected long despawnTick = DEFAULT_DESPAWN_TICK;
    protected long playerTimer = DEFAULT_PLAYER_TIMER;
    protected int xp = DEFAULT_XP;

    public CobblelootsLootBall(class_1299<? extends class_1309> entityType, class_1937 level) {
        super(entityType, level);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1429.method_26828().method_26868(class_5134.field_49078, 0.1);
    }

    public boolean method_5753() {
        return true;
    }

    public void method_36456(float f) {
        super.method_36456(f);
        super.method_5847(f);
        super.method_5636(f);
    }

    public boolean method_27298() {
        return false;
    }

    protected void method_6027() {
        this.method_5648(this.method_5767());
    }

    public void method_5648(boolean bl) {
        this.method_5841().method_12778(INVISIBLE, (Object)bl);
        super.method_5648(bl);
    }

    public boolean method_5767() {
        return (Boolean)this.method_5841().method_12789(INVISIBLE);
    }

    @NotNull
    public class_1269 method_5688(class_1657 player, class_1268 interactionHand) {
        if (!this.method_37908().method_8608() && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            this.handleServerSideInteraction(serverPlayer, interactionHand);
        }
        this.method_5431();
        return class_1269.field_5812;
    }

    private void handleServerSideInteraction(class_3222 serverPlayer, class_1268 interactionHand) {
        class_1799 handStack = serverPlayer.method_5998(interactionHand).method_7972();
        if (serverPlayer.method_7337()) {
            this.handleCreativeModeInteraction(serverPlayer, handStack);
        } else if (!serverPlayer.method_7325()) {
            this.tryOpen(serverPlayer);
        }
    }

    private void handleCreativeModeInteraction(class_3222 serverPlayer, class_1799 handStack) {
        if (handStack.method_7960()) {
            this.toggleVisibility(serverPlayer);
        } else if (handStack.method_31574(class_1802.field_20414) && this.method_5767()) {
            this.toggleSparks(serverPlayer);
        } else {
            this.setLootBallItem(handStack, serverPlayer);
        }
    }

    public boolean method_5643(class_1282 damageSource, float f) {
        class_1297 attacker = damageSource.method_5529();
        if (!(attacker instanceof class_1657)) {
            return false;
        }
        class_1657 player = (class_1657)attacker;
        this.field_6238 = 100;
        if (this.method_37908().method_8608()) {
            return false;
        }
        if (!(player instanceof class_3222)) {
            return false;
        }
        class_3222 serverPlayer = (class_3222)player;
        class_1799 itemStack = serverPlayer.method_6047();
        if (!itemStack.method_7960()) {
            return false;
        }
        return this.handleEmptyHandAttack(serverPlayer);
    }

    private boolean handleEmptyHandAttack(class_3222 serverPlayer) {
        if (!serverPlayer.method_7337() && this.getRemainingUses() != 0) {
            serverPlayer.method_17356(class_3417.field_15150, class_3419.field_15245, 0.3f, 1.0f);
            return false;
        }
        if (this.isOpening) {
            serverPlayer.method_17356(class_3417.field_15150, class_3419.field_15245, 0.3f, 1.0f);
            return false;
        }
        if (!this.method_5442() && serverPlayer.method_7337()) {
            this.method_5775(this.method_5438(0));
        }
        if (!serverPlayer.method_7337() && CobblelootsConfig.getBooleanConfig("loot_ball.survival.drop.enabled")) {
            this.method_5775(this.getSurvivalLootBallItem());
        }
        this.method_5783(class_3417.field_15118, 0.5f, 1.0f);
        this.method_31472();
        return true;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(SPARKS, (Object)true);
        builder.method_56912(INVISIBLE, (Object)false);
        builder.method_56912(CUSTOM_TEXTURE, (Object)"");
        builder.method_56912(LOOT_BALL_DATA_ID, (Object)"");
        builder.method_56912(VARIANT_ID, (Object)"");
        builder.method_56912(OPENING_TICKS, (Object)0);
        builder.method_56912(LOOT_BALL_CLIENT_DATA, (Object)new class_2487());
    }

    @Override
    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        this.saveEntityVisualProperties(compoundTag);
        this.saveEntityIdentificationData(compoundTag);
        this.saveOpeners(compoundTag);
        this.saveNumericalProperties(compoundTag);
    }

    private void saveEntityVisualProperties(class_2487 compoundTag) {
        compoundTag.method_10556(TAG_SPARKS, this.hasSparks());
        compoundTag.method_10556(TAG_INVISIBLE, this.method_5767());
        String customTexture = (String)this.method_5841().method_12789(CUSTOM_TEXTURE);
        if (customTexture != null && !customTexture.isEmpty()) {
            compoundTag.method_10582(TAG_CUSTOM_TEXTURE, customTexture);
        }
    }

    private void saveEntityIdentificationData(class_2487 compoundTag) {
        String variantId;
        String lootBallDataId = this.getLootBallDataId();
        if (lootBallDataId != null && !lootBallDataId.isEmpty()) {
            compoundTag.method_10582(TAG_LOOT_BALL_DATA_ID, lootBallDataId);
        }
        if ((variantId = this.getVariantId()) != null && !variantId.isEmpty()) {
            compoundTag.method_10582(TAG_VARIANT_ID, variantId);
        }
    }

    private void saveOpeners(class_2487 compoundTag) {
        if (this.openers.isEmpty()) {
            return;
        }
        class_2499 openersTag = new class_2499();
        for (Map.Entry<UUID, Long> entry : this.openers.entrySet()) {
            class_2487 openerTag = new class_2487();
            openerTag.method_25927("UUID", entry.getKey());
            openerTag.method_10544("Timestamp", entry.getValue().longValue());
            openersTag.add((Object)openerTag);
        }
        compoundTag.method_10566(TAG_OPENERS, (class_2520)openersTag);
    }

    private void saveNumericalProperties(class_2487 compoundTag) {
        if (this.uses != DEFAULT_USES) {
            compoundTag.method_10569(TAG_USES, this.uses);
        }
        if (this.multiplier != DEFAULT_MULTIPLIER) {
            compoundTag.method_10548(TAG_MULTIPLIER, this.multiplier);
        }
        if (this.despawnTick != DEFAULT_DESPAWN_TICK) {
            compoundTag.method_10544(TAG_DESPAWN_TICK, this.despawnTick);
        }
        if (this.playerTimer != DEFAULT_PLAYER_TIMER) {
            compoundTag.method_10544(TAG_PLAYER_TIMER, this.playerTimer);
        }
        if (this.xp != DEFAULT_XP) {
            compoundTag.method_10569(TAG_XP, this.xp);
        }
    }

    @Override
    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.setSparks(compoundTag.method_10577(TAG_SPARKS));
        this.method_5648(compoundTag.method_10577(TAG_INVISIBLE));
        this.readTextureFromTag(compoundTag);
        this.readLootBallDataFromTag(compoundTag);
        if (compoundTag.method_10545(TAG_VARIANT_ID)) {
            this.setVariantId(compoundTag.method_10558(TAG_VARIANT_ID));
        }
        this.readOpenersFromTag(compoundTag);
        this.readNumericalValuesFromTag(compoundTag);
    }

    private void readTextureFromTag(class_2487 compoundTag) {
        class_2960 textureLocation;
        String texturePath;
        if (compoundTag.method_10545(TAG_CUSTOM_TEXTURE) && !(texturePath = compoundTag.method_10558(TAG_CUSTOM_TEXTURE)).isEmpty() && (textureLocation = class_2960.method_12829((String)texturePath)) != null) {
            this.setTexture(textureLocation);
        }
    }

    private void readLootBallDataFromTag(class_2487 compoundTag) {
        class_2960 lootBallDataLocation;
        String dataPath;
        if (compoundTag.method_10545(TAG_LOOT_BALL_DATA_ID) && !(dataPath = compoundTag.method_10558(TAG_LOOT_BALL_DATA_ID)).isEmpty() && (lootBallDataLocation = class_2960.method_12829((String)dataPath)) != null) {
            this.setLootBallDataId(lootBallDataLocation);
        }
    }

    private void readOpenersFromTag(class_2487 compoundTag) {
        if (compoundTag.method_10545(TAG_OPENERS)) {
            class_2499 openersTag = compoundTag.method_10554(TAG_OPENERS, 10);
            this.openers.clear();
            for (int i = 0; i < openersTag.size(); ++i) {
                class_2487 openerTag = openersTag.method_10602(i);
                if (!openerTag.method_10545("UUID") || !openerTag.method_10545("Timestamp")) continue;
                UUID uuid = openerTag.method_25926("UUID");
                long timestamp = openerTag.method_10537("Timestamp");
                this.openers.put(uuid, timestamp);
            }
        }
    }

    private void readNumericalValuesFromTag(class_2487 compoundTag) {
        this.uses = compoundTag.method_10545(TAG_USES) ? compoundTag.method_10550(TAG_USES) : DEFAULT_USES;
        this.multiplier = compoundTag.method_10545(TAG_MULTIPLIER) ? compoundTag.method_10583(TAG_MULTIPLIER) : DEFAULT_MULTIPLIER;
        this.despawnTick = compoundTag.method_10545(TAG_DESPAWN_TICK) ? compoundTag.method_10537(TAG_DESPAWN_TICK) : DEFAULT_DESPAWN_TICK;
        this.playerTimer = compoundTag.method_10545(TAG_PLAYER_TIMER) ? compoundTag.method_10537(TAG_PLAYER_TIMER) : DEFAULT_PLAYER_TIMER;
        this.xp = compoundTag.method_10545(TAG_XP) ? compoundTag.method_10550(TAG_XP) : DEFAULT_XP;
    }

    public boolean method_5810() {
        return false;
    }

    public void method_5847(float f) {
        super.method_5847(f);
        super.method_5636(f);
    }

    public void method_5636(float f) {
        super.method_5636(f);
        super.method_5847(f);
    }

    public void method_5773() {
        super.method_5773();
        this.openingTick();
        if (!this.method_37908().method_8608() && this.getDespawnTick() > 0L && this.method_37908().method_8510() >= this.getDespawnTick()) {
            this.method_31472();
        }
    }

    public boolean method_6094() {
        return true;
    }

    public void method_5670() {
        super.method_5670();
        this.method_37908().method_16107().method_15396("cobblelootsLootBallEntityBaseTick");
        this.trySpawnParticles();
        this.method_37908().method_16107().method_15407();
    }

    private void trySpawnParticles() {
        if (this.field_5974.method_43057() > 0.05f) {
            return;
        }
        double x = this.method_23317() + this.field_5974.method_43059() * 0.1;
        double y = this.method_23318() + 0.5 + this.field_5974.method_43059() * 0.1;
        double z = this.method_23321() + this.field_5974.method_43059() * 0.1;
        double vx = this.field_5974.method_43059() * 0.1;
        double vy = this.field_5974.method_43059() * 0.1;
        double vz = this.field_5974.method_43059() * 0.1;
        if (this.method_5767() && this.hasSparks()) {
            this.method_37908().method_8406((class_2394)class_2398.field_29644, x, y, z, vx, vy, vz);
        }
        if (this.method_5799()) {
            this.method_37908().method_8406((class_2394)class_2398.field_11238, x, y, z, vx, vy, vz);
        }
    }

    @Override
    @NotNull
    public class_2371<class_1799> getItemStacks() {
        return this.itemStacks;
    }

    @Override
    public int method_5439() {
        return 1;
    }

    @Override
    public class_2960 getLootTableLocation() {
        class_2960 tableLocation = super.getLootTableLocation();
        if (tableLocation == null) {
            CobblelootsLootBallData lootBallData = this.getLootBallData();
            if (lootBallData == null) {
                return CobblelootsDefinitions.EMPTY_LOCATION;
            }
            CobblelootsLootBallVariantData variantData = this.getVariantData();
            if (variantData != null && variantData.getLootTable() != null && !variantData.getLootTable().equals((Object)CobblelootsDefinitions.EMPTY_LOCATION)) {
                tableLocation = variantData.getLootTable();
            } else if (lootBallData.getLootTable() != null && !lootBallData.getLootTable().equals((Object)CobblelootsDefinitions.EMPTY_LOCATION)) {
                tableLocation = lootBallData.getLootTable();
            } else {
                return CobblelootsDefinitions.EMPTY_LOCATION;
            }
        }
        return tableLocation;
    }

    private void tryOpen(class_3222 serverPlayer) {
        if (!this.canPlayerOpenLootBall(serverPlayer)) {
            return;
        }
        this.unpackLootTable(serverPlayer);
        if (!this.method_5442()) {
            this.startOpeningAnimation(serverPlayer);
        } else {
            serverPlayer.method_43502((class_2561)CobblelootsUtils.cobblelootsText(TEXT_INFO_NO_LOOT, new Object[0]).method_27692(class_124.field_1080), true);
        }
    }

    private boolean canPlayerOpenLootBall(class_3222 serverPlayer) {
        if (this.isOpening) {
            serverPlayer.method_43502((class_2561)CobblelootsUtils.cobblelootsText(TEXT_ERROR_IS_OPENING, new Object[0]).method_27692(class_124.field_1061), true);
            return false;
        }
        if (this.isOpener(serverPlayer) && !this.handleAlreadyOpenedError(serverPlayer)) {
            return false;
        }
        if (this.getRemainingUses() == 0) {
            serverPlayer.method_43502((class_2561)CobblelootsUtils.cobblelootsText(TEXT_ERROR_ALREADY_OPENED, new Object[0]).method_27692(class_124.field_1061), true);
            return false;
        }
        return true;
    }

    private boolean handleAlreadyOpenedError(class_3222 serverPlayer) {
        if (this.getPlayerTimer() > 0L) {
            long lastOpenTime = this.openers.getOrDefault(serverPlayer.method_5667(), 0L);
            long timeDiff = this.method_37908().method_8510() - lastOpenTime;
            if (timeDiff < this.getPlayerTimer()) {
                long remainingSeconds = (long)Math.ceil((float)(this.getPlayerTimer() - timeDiff) / 20.0f);
                serverPlayer.method_43502((class_2561)CobblelootsUtils.cobblelootsText(TEXT_ERROR_COOLDOWN, String.valueOf(remainingSeconds)).method_27692(class_124.field_1061), true);
                return false;
            }
            return true;
        }
        serverPlayer.method_43502((class_2561)CobblelootsUtils.cobblelootsText(TEXT_ERROR_ALREADY_OPENED, new Object[0]).method_27692(class_124.field_1061), true);
        return false;
    }

    private void startOpeningAnimation(class_3222 serverPlayer) {
        this.pendingOpener = serverPlayer;
        this.isOpening = true;
        this.wasInvisible = this.method_5767();
        this.method_5648(false);
        this.setOpeningTicks(50);
        if (this.getDespawnTick() > 0L) {
            this.setDespawnTick(this.method_37908().method_8510() + 250L);
        }
    }

    private long getPlayerTimer() {
        return this.playerTimer;
    }

    private void setOpeningTicks(int i) {
        this.method_5841().method_12778(OPENING_TICKS, (Object)i);
    }

    private int getOpeningTicks() {
        return (Integer)this.method_5841().method_12789(OPENING_TICKS);
    }

    private void open(class_3222 serverPlayer) {
        if (serverPlayer == null) {
            return;
        }
        this.deliverItemsToPlayer(serverPlayer);
        this.awardExperienceIfEnabled(serverPlayer);
        this.decrementUsesIfNotInfinite();
        this.clearInventoryIfUsingLootTable();
        this.method_5431();
    }

    private void deliverItemsToPlayer(class_3222 serverPlayer) {
        for (class_1799 itemStack : this.itemStacks) {
            if (itemStack.method_7960()) continue;
            class_1799 deliveredItem = this.prepareItemForDelivery(itemStack.method_7972());
            this.notifyPlayerAboutItem(serverPlayer, deliveredItem);
            serverPlayer.method_31548().method_7398(deliveredItem);
            this.addOpener(serverPlayer);
            this.method_43077(CobblelootsLootBallSounds.getPopItemSound());
            serverPlayer.method_17356(CobblelootsLootBallSounds.getFanfare(), class_3419.field_15245, 1.0f, 1.0f);
        }
    }

    private class_1799 prepareItemForDelivery(class_1799 item) {
        int multipliedCount = (int)Math.ceil((float)item.method_7947() * this.getMultiplier());
        item.method_7939(multipliedCount);
        return item;
    }

    private void notifyPlayerAboutItem(class_3222 serverPlayer, class_1799 item) {
        class_5250 message = this.getMultiplier() > 1.0f ? CobblelootsUtils.cobblelootsText(TEXT_OPEN_SUCCESS_BONUS, String.valueOf(this.getMultiplier()), item.method_7964().getString(), String.valueOf(item.method_7947())).method_27692(class_124.field_1075) : CobblelootsUtils.cobblelootsText(TEXT_OPEN_SUCCESS, item.method_7964().getString(), String.valueOf(item.method_7947())).method_27692(class_124.field_1075);
        serverPlayer.method_43502((class_2561)message, true);
    }

    private void awardExperienceIfEnabled(class_3222 serverPlayer) {
        if (CobblelootsConfig.getBooleanConfig("loot_ball.xp.enabled") && this.getXP() > 0) {
            serverPlayer.method_7255(this.getXP());
        }
    }

    private void decrementUsesIfNotInfinite() {
        if (!this.isInfinite()) {
            this.setRemainingUses(this.getRemainingUses() - 1);
        }
    }

    private void clearInventoryIfUsingLootTable() {
        class_2960 lootTableLocation = this.getLootTableLocation();
        if (lootTableLocation != null && !lootTableLocation.equals((Object)CobblelootsDefinitions.EMPTY_LOCATION)) {
            this.method_5448();
        }
    }

    public boolean isOpener(class_3222 serverPlayer) {
        return this.openers.containsKey(serverPlayer.method_5667());
    }

    public void addOpener(class_3222 serverPlayer) {
        this.openers.put(serverPlayer.method_5667(), this.method_37908().method_8510());
    }

    public int getRemainingUses() {
        return this.uses;
    }

    public void setRemainingUses(int uses) {
        this.uses = uses;
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(float multiplier) {
        this.multiplier = multiplier;
    }

    public boolean hasSparks() {
        return (Boolean)this.method_5841().method_12789(SPARKS);
    }

    public String getLootBallDataId() {
        return (String)this.method_5841().method_12789(LOOT_BALL_DATA_ID);
    }

    public String getVariantId() {
        return (String)this.method_5841().method_12789(VARIANT_ID);
    }

    @Nullable
    public CobblelootsLootBallData getLootBallData() {
        class_2960 dataLocation = class_2960.method_12829((String)this.getLootBallDataId());
        if (dataLocation == null) {
            return null;
        }
        return CobblelootsDataProvider.getLootBallData(dataLocation);
    }

    @Nullable
    public CobblelootsLootBallVariantData getVariantData() {
        CobblelootsLootBallData lootBallData = this.getLootBallData();
        if (lootBallData == null) {
            return null;
        }
        return lootBallData.getVariants().get(this.getVariantId());
    }

    public class_2487 getLootBallClientData() {
        return (class_2487)this.method_5841().method_12789(LOOT_BALL_CLIENT_DATA);
    }

    public void updateLootBallClientData() {
        class_2487 compoundTag = new class_2487();
        class_2960 texture = this.getTextureFromServerData();
        if (texture != null) {
            compoundTag.method_10582(TAG_CUSTOM_TEXTURE, texture.toString());
        }
        this.method_5841().method_12778(LOOT_BALL_CLIENT_DATA, (Object)compoundTag);
    }

    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if ((key.equals(CUSTOM_TEXTURE) || key.equals(LOOT_BALL_DATA_ID) || key.equals(VARIANT_ID)) && !this.method_37908().method_8608()) {
            this.updateLootBallClientData();
        }
    }

    public String getTextureId() {
        return this.getTexture().toString();
    }

    @NotNull
    public class_2960 getTexture() {
        class_2960 textureLocation = this.method_37908().method_8608() ? this.getTextureFromClientData() : this.getTextureFromServerData();
        return textureLocation != null ? textureLocation : CobblelootsDefinitions.EMPTY_LOCATION;
    }

    @Nullable
    private class_2960 getTextureFromClientData() {
        class_2487 compoundTag = this.getLootBallClientData();
        if (compoundTag == null || !compoundTag.method_10545(TAG_CUSTOM_TEXTURE)) {
            return null;
        }
        String texturePath = compoundTag.method_10558(TAG_CUSTOM_TEXTURE);
        if (texturePath.isEmpty()) {
            return null;
        }
        return class_2960.method_12829((String)texturePath);
    }

    @Nullable
    private class_2960 getTextureFromServerData() {
        class_2960 customLocation = this.getCustomTextureLocation();
        if (customLocation != null) {
            return customLocation;
        }
        return this.getLootBallDataTexture();
    }

    @Nullable
    private class_2960 getCustomTextureLocation() {
        String customTexture = (String)this.method_5841().method_12789(CUSTOM_TEXTURE);
        if (customTexture.isEmpty()) {
            return null;
        }
        return class_2960.method_12829((String)customTexture);
    }

    @Nullable
    private class_2960 getLootBallDataTexture() {
        CobblelootsLootBallVariantData variantData;
        CobblelootsLootBallData lootBallData = this.getLootBallData();
        if (lootBallData == null) {
            return null;
        }
        String variantId = this.getVariantId();
        if (!variantId.isEmpty() && (variantData = lootBallData.getVariants().get(variantId)) != null && variantData.getTexture() != null && !variantData.getTexture().equals((Object)CobblelootsDefinitions.EMPTY_LOCATION)) {
            return variantData.getTexture();
        }
        return lootBallData.getTexture();
    }

    public void setSparks(boolean sparks) {
        this.method_5841().method_12778(SPARKS, (Object)sparks);
    }

    public void setVariantId(String variantId) {
        this.method_5841().method_12778(VARIANT_ID, (Object)variantId);
        this.updateLootBallClientData();
    }

    public void setLootBallDataId(class_2960 lootBallData) {
        this.method_5841().method_12778(LOOT_BALL_DATA_ID, (Object)lootBallData.toString());
        this.updateLootBallClientData();
    }

    public void setTexture(class_2960 texture) {
        this.method_5841().method_12778(CUSTOM_TEXTURE, (Object)texture.toString());
        this.updateLootBallClientData();
    }

    public void setDespawnTick(long tick) {
        this.despawnTick = tick;
    }

    public long getDespawnTick() {
        return this.despawnTick;
    }

    public boolean isInfinite() {
        return this.uses <= -1;
    }

    public int getXP() {
        if (this.xp != DEFAULT_XP) {
            return this.xp;
        }
        CobblelootsLootBallData lootBallData = this.getLootBallData();
        if (lootBallData != null && lootBallData.getXp() > 0) {
            return lootBallData.getXp();
        }
        return this.xp;
    }

    private void toggleVisibility(class_3222 serverPlayer) {
        serverPlayer.method_43502((class_2561)CobblelootsUtils.cobblelootsText(TEXT_TOGGLE_VISIBILITY, new Object[0]).method_27692(class_124.field_1075), true);
        serverPlayer.method_17356(CobblelootsLootBallSounds.getToggleInvisibilitySound(), class_3419.field_15245, 0.5f, 1.0f);
        this.method_5648(!this.method_5767());
    }

    private void toggleSparks(class_3222 serverPlayer) {
        serverPlayer.method_43502((class_2561)CobblelootsUtils.cobblelootsText(TEXT_TOGGLE_SPARKS, new Object[0]).method_27692(class_124.field_1075), true);
        serverPlayer.method_17356(CobblelootsLootBallSounds.getToggleSparksSound(this.hasSparks()), class_3419.field_15245, 0.5f, 1.0f);
        this.setSparks(!this.hasSparks());
    }

    private void setLootBallItem(class_1799 itemStack, class_3222 serverPlayer) {
        this.method_5447(0, itemStack);
        if (!serverPlayer.method_7337()) {
            serverPlayer.method_6122(class_1268.field_5808, class_1799.field_8037);
        }
        serverPlayer.method_43502((class_2561)CobblelootsUtils.cobblelootsText(TEXT_SET_ITEM, itemStack.method_7964().getString(), String.valueOf(itemStack.method_7947())).method_27692(class_124.field_1075), true);
        serverPlayer.method_17356(CobblelootsLootBallSounds.getSetItemSound(), class_3419.field_15245, 0.5f, 1.0f);
        this.method_5431();
    }

    private class_1799 getSurvivalLootBallItem() {
        class_2561 nameComponent;
        class_1799 lootBallItem = new class_1799((class_1935)CobblelootsItems.getLootBallItem());
        class_2487 tag = this.createSurvivalLootBallItemTag();
        if (!tag.method_33133()) {
            lootBallItem.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
        }
        if (!(nameComponent = this.getLootBallNameComponent()).equals((Object)class_2561.method_43473())) {
            lootBallItem.method_57379(class_9334.field_49631, (Object)nameComponent);
        }
        return lootBallItem;
    }

    private class_1799 getCreativeLootBallItem() {
        class_2561 nameComponent;
        class_1799 lootBallItem = new class_1799((class_1935)CobblelootsItems.getLootBallItem());
        class_2487 tag = this.createCreativeLootBallItemTag();
        if (!tag.method_33133()) {
            lootBallItem.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
        }
        if (!(nameComponent = this.getLootBallNameComponent()).equals((Object)class_2561.method_43473())) {
            lootBallItem.method_57379(class_9334.field_49631, (Object)nameComponent);
        }
        return lootBallItem;
    }

    private class_2561 getLootBallNameComponent() {
        CobblelootsLootBallData data = this.getLootBallData();
        CobblelootsLootBallVariantData variantData = this.getVariantData();
        if (variantData != null) {
            return variantData.getName();
        }
        if (data != null) {
            return data.getName();
        }
        return class_2561.method_43473();
    }

    private class_2487 createSurvivalLootBallItemTag() {
        class_2487 tag = new class_2487();
        tag.method_10582(TAG_LOOT_BALL_DATA_ID, this.getLootBallDataId());
        tag.method_10582(TAG_VARIANT_ID, this.getVariantId());
        tag.method_10582(TAG_CUSTOM_TEXTURE, this.getTextureId());
        tag.method_10556(TAG_INVISIBLE, false);
        tag.method_10569(TAG_USES, 0);
        tag.method_10544(TAG_DESPAWN_TICK, 0L);
        return tag;
    }

    private class_2487 createCreativeLootBallItemTag() {
        class_2487 tag = new class_2487();
        tag.method_10582(TAG_LOOT_BALL_DATA_ID, this.getLootBallDataId());
        tag.method_10582(TAG_VARIANT_ID, this.getVariantId());
        tag.method_10582(TAG_CUSTOM_TEXTURE, this.getTextureId());
        tag.method_10556(TAG_SPARKS, this.hasSparks());
        tag.method_10556(TAG_INVISIBLE, this.method_5767());
        tag.method_10569(TAG_USES, this.getRemainingUses());
        tag.method_10548(TAG_MULTIPLIER, this.getMultiplier());
        tag.method_10544(TAG_DESPAWN_TICK, this.getDespawnTick());
        tag.method_10544(TAG_PLAYER_TIMER, this.getPlayerTimer());
        tag.method_10569(TAG_XP, this.getXP());
        return tag;
    }

    private void openingTick() {
        if (this.method_37908().method_8608()) {
            this.handleClientAnimations();
        } else {
            this.handleServerAnimations();
        }
    }

    private void handleClientAnimations() {
        int currentTicks = this.getOpeningTicks();
        boolean animationStarted = this.openingAnimationState.method_41327();
        if (currentTicks > 0 && !animationStarted) {
            this.openingAnimationState.method_41322(this.field_6012);
        } else if (currentTicks == 0 && animationStarted) {
            this.openingAnimationState.method_41325();
        }
    }

    private void handleServerAnimations() {
        int currentTicks = this.getOpeningTicks();
        if (currentTicks > 0) {
            if (currentTicks == 50) {
                this.method_43077(CobblelootsLootBallSounds.getLidOpenSound());
            } else if (currentTicks == 25) {
                this.open(this.pendingOpener);
            }
            this.setOpeningTicks(currentTicks - 1);
        } else if (currentTicks == 0 && this.pendingOpener != null) {
            this.pendingOpener = null;
            this.isOpening = false;
            this.method_5648(this.wasInvisible);
            this.method_43077(CobblelootsLootBallSounds.getLidCloseSound());
            if (CobblelootsConfig.getBooleanConfig("loot_ball.survival.destroy_looted") && !this.isInfinite() && this.getRemainingUses() <= 0) {
                this.method_31472();
                return;
            }
            if (CobblelootsConfig.getBooleanConfig("loot_ball.survival.drop.enabled") && CobblelootsConfig.getBooleanConfig("loot_ball.survival.drop.automatic") && !this.isInfinite() && this.getRemainingUses() <= 0) {
                this.method_31472();
                this.method_5775(this.getSurvivalLootBallItem());
                this.method_43077(class_3417.field_14770);
            }
        }
    }

    public class_1799 method_31480() {
        return this.getCreativeLootBallItem();
    }
}

