/*
 * Decompiled with CFR 0.152.
 */
package dev.ripio.cobbleloots.config;

import dev.ripio.cobbleloots.Cobbleloots;
import dev.ripio.cobbleloots.util.io.CobblelootsYamlParser;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;

public class CobblelootsConfig {
    public static final Path CONFIG_PATH = Path.of("config/cobbleloots/cobbleloots.yaml", new String[0]);
    public static final String LOOT_BALL_XP_ENABLED = "loot_ball.xp.enabled";
    public static final String LOOT_BALL_XP_AMOUNT = "loot_ball.xp.amount";
    public static final String LOOT_BALL_BONUS_ENABLED = "loot_ball.bonus.enabled";
    public static final String LOOT_BALL_BONUS_CHANCE = "loot_ball.bonus.chance";
    public static final String LOOT_BALL_BONUS_MULTIPLIER = "loot_ball.bonus.multiplier";
    public static final String LOOT_BALL_BONUS_INVISIBLE = "loot_ball.bonus.invisible";
    public static final String LOOT_BALL_GENERATION_ENABLED = "loot_ball.generation.enabled";
    public static final String LOOT_BALL_GENERATION_CHANCE = "loot_ball.generation.chance";
    public static final String LOOT_BALL_GENERATION_ATTEMPTS = "loot_ball.generation.attempts";
    public static final String LOOT_BALL_GENERATION_CHUNK_CAP = "loot_ball.generation.chunk_cap";
    public static final String LOOT_BALL_SPAWNING_ENABLED = "loot_ball.spawning.enabled";
    public static final String LOOT_BALL_SPAWNING_CHANCE = "loot_ball.spawning.chance";
    public static final String LOOT_BALL_SPAWNING_COOLDOWN_MIN = "loot_ball.spawning.cooldown.min";
    public static final String LOOT_BALL_SPAWNING_COOLDOWN_MAX = "loot_ball.spawning.cooldown.max";
    public static final String LOOT_BALL_SPAWNING_DESPAWN_ENABLED = "loot_ball.spawning.despawn.enabled";
    public static final String LOOT_BALL_SPAWNING_DESPAWN_TIME = "loot_ball.spawning.despawn.time";
    public static final String LOOT_BALL_SURVIVAL_DROP_ENABLED = "loot_ball.survival.drop.enabled";
    public static final String LOOT_BALL_SURVIVAL_DROP_AUTOMATIC = "loot_ball.survival.drop.automatic";
    public static final String LOOT_BALL_SURVIVAL_DESTROY_LOOTED = "loot_ball.survival.destroy_looted";
    public static final String LOOT_BALL_DEFAULTS_USES = "loot_ball.defaults.uses";
    public static final String LOOT_BALL_DEFAULTS_MULTIPLIER = "loot_ball.defaults.multiplier";
    public static final String LOOT_BALL_DEFAULTS_XP = "loot_ball.defaults.xp";
    public static final String LOOT_BALL_DEFAULTS_PLAYER_TIMER = "loot_ball.defaults.player_timer";
    public static final String LOOT_BALL_DEFAULTS_DESPAWN_TICK = "loot_ball.defaults.despawn_tick";
    public static final String LOOT_BALL_DISABLED_DIMENSIONS_GENERATION = "loot_ball.disabled.dimensions.generation";
    public static final String LOOT_BALL_DISABLED_DIMENSIONS_SPAWNING = "loot_ball.disabled.dimensions.spawning";
    public static final String LOOT_BALL_DISABLED_DIMENSIONS_FISHING = "loot_ball.disabled.dimensions.fishing";
    public static final String LOOT_BALL_DISABLED_DIMENSIONS_ARCHAEOLOGY = "loot_ball.disabled.dimensions.archaeology";
    private static Map<String, Object> configMap = new HashMap<String, Object>();
    private static Map<String, Object> fileMap = new HashMap<String, Object>();

    private static boolean isResourceLocationListKey(String key) {
        return key.equals(LOOT_BALL_DISABLED_DIMENSIONS_GENERATION) || key.equals(LOOT_BALL_DISABLED_DIMENSIONS_SPAWNING) || key.equals(LOOT_BALL_DISABLED_DIMENSIONS_FISHING) || key.equals(LOOT_BALL_DISABLED_DIMENSIONS_ARCHAEOLOGY);
    }

    private static Map<String, Object> getDefaultConfig() {
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        defaults.put(LOOT_BALL_XP_ENABLED, true);
        defaults.put(LOOT_BALL_BONUS_ENABLED, true);
        defaults.put(LOOT_BALL_BONUS_CHANCE, Float.valueOf(0.1f));
        defaults.put(LOOT_BALL_BONUS_MULTIPLIER, Float.valueOf(2.0f));
        defaults.put(LOOT_BALL_BONUS_INVISIBLE, true);
        defaults.put(LOOT_BALL_GENERATION_ENABLED, true);
        defaults.put(LOOT_BALL_GENERATION_CHANCE, Float.valueOf(0.0513f));
        defaults.put(LOOT_BALL_GENERATION_ATTEMPTS, 2);
        defaults.put(LOOT_BALL_GENERATION_CHUNK_CAP, 4);
        defaults.put(LOOT_BALL_SPAWNING_ENABLED, true);
        defaults.put(LOOT_BALL_SPAWNING_CHANCE, Float.valueOf(0.25f));
        defaults.put(LOOT_BALL_SPAWNING_COOLDOWN_MIN, 6000);
        defaults.put(LOOT_BALL_SPAWNING_COOLDOWN_MAX, 36000);
        defaults.put(LOOT_BALL_SPAWNING_DESPAWN_ENABLED, true);
        defaults.put(LOOT_BALL_SPAWNING_DESPAWN_TIME, 24000);
        defaults.put(LOOT_BALL_SURVIVAL_DROP_ENABLED, true);
        defaults.put(LOOT_BALL_SURVIVAL_DROP_AUTOMATIC, true);
        defaults.put(LOOT_BALL_SURVIVAL_DESTROY_LOOTED, false);
        defaults.put(LOOT_BALL_DEFAULTS_USES, 1);
        defaults.put(LOOT_BALL_DEFAULTS_MULTIPLIER, Float.valueOf(1.0f));
        defaults.put(LOOT_BALL_DEFAULTS_XP, 0);
        defaults.put(LOOT_BALL_DEFAULTS_PLAYER_TIMER, 0L);
        defaults.put(LOOT_BALL_DEFAULTS_DESPAWN_TICK, 0L);
        defaults.put(LOOT_BALL_DISABLED_DIMENSIONS_GENERATION, new ArrayList());
        defaults.put(LOOT_BALL_DISABLED_DIMENSIONS_SPAWNING, new ArrayList());
        defaults.put(LOOT_BALL_DISABLED_DIMENSIONS_FISHING, new ArrayList());
        defaults.put(LOOT_BALL_DISABLED_DIMENSIONS_ARCHAEOLOGY, new ArrayList());
        return defaults;
    }

    public static void initConfig() {
        configMap = CobblelootsConfig.getDefaultConfig();
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                fileMap = CobblelootsConfig.flatten(CobblelootsYamlParser.parse(CONFIG_PATH), "");
                Cobbleloots.LOGGER.info("Config file found, loading values.");
            }
            catch (IOException e) {
                Cobbleloots.LOGGER.error("Invalid config file, generating new one with defaults.");
            }
            catch (Exception e) {
                Cobbleloots.LOGGER.error("Error loading config file: {}", (Object)e.getMessage());
                Cobbleloots.LOGGER.info("Generating new config file with defaults.");
            }
        } else {
            Cobbleloots.LOGGER.info("Config file not found, creating new one with defaults.");
        }
        for (String key : fileMap.keySet()) {
            if (!configMap.containsKey(key)) continue;
            Object defaultValue = configMap.get(key);
            Object fileValue = fileMap.get(key);
            try {
                if (defaultValue instanceof Integer) {
                    configMap.put(key, Integer.parseInt(fileValue.toString()));
                    continue;
                }
                if (defaultValue instanceof Float) {
                    configMap.put(key, Float.valueOf(Float.parseFloat(fileValue.toString())));
                    continue;
                }
                if (defaultValue instanceof Double) {
                    configMap.put(key, Double.parseDouble(fileValue.toString()));
                    continue;
                }
                if (defaultValue instanceof Long) {
                    configMap.put(key, Long.parseLong(fileValue.toString()));
                    continue;
                }
                if (defaultValue instanceof Boolean) {
                    configMap.put(key, Boolean.parseBoolean(fileValue.toString()));
                    continue;
                }
                if (defaultValue instanceof String) {
                    configMap.put(key, fileValue.toString());
                    continue;
                }
                if (defaultValue instanceof List && CobblelootsConfig.isResourceLocationListKey(key)) {
                    if (fileValue instanceof List) {
                        ArrayList<class_2960> locationList = new ArrayList<class_2960>();
                        for (Object item : (List)fileValue) {
                            if (item instanceof String) {
                                class_2960 location = class_2960.method_12829((String)((String)item));
                                if (location != null) {
                                    locationList.add(location);
                                    continue;
                                }
                                Cobbleloots.LOGGER.warn("Invalid resource location string in list for key {}: {}", (Object)key, item);
                                continue;
                            }
                            Cobbleloots.LOGGER.warn("Item in list for key {} is not a string: {}", (Object)key, item);
                        }
                        configMap.put(key, locationList);
                        continue;
                    }
                    if (fileValue instanceof String) {
                        class_2960 location = class_2960.method_12829((String)fileValue.toString());
                        if (location != null) {
                            ArrayList<class_2960> singleItemList = new ArrayList<class_2960>();
                            singleItemList.add(location);
                            configMap.put(key, singleItemList);
                            continue;
                        }
                        Cobbleloots.LOGGER.warn("Invalid resource location string for key {}: {}", (Object)key, fileValue);
                        continue;
                    }
                    if (fileValue == null) continue;
                    Cobbleloots.LOGGER.warn("Config key {} expected a list but got {}. Using default value.", (Object)key, (Object)fileValue.getClass().getSimpleName());
                    continue;
                }
                if (defaultValue != null) {
                    Cobbleloots.LOGGER.warn("Config key {} has an unexpected type (Expected: {}). Using default value.", (Object)key, (Object)defaultValue.getClass().getSimpleName());
                    continue;
                }
                Cobbleloots.LOGGER.warn("Config key {} has a null default value. Using file value if available: {}", (Object)key, fileValue);
                if (fileValue == null) continue;
                configMap.put(key, fileValue);
            }
            catch (NumberFormatException e) {
                Cobbleloots.LOGGER.error("Config key {} has incompatible number format (Value: '{}'). Using default value.", new Object[]{key, fileValue, e});
            }
            catch (Exception e) {
                Cobbleloots.LOGGER.error("Error processing config key {} (Value: '{}'). Using default value.", new Object[]{key, fileValue, e});
            }
        }
        CobblelootsConfig.saveConfig();
        Cobbleloots.LOGGER.info("{} configurations loaded.", (Object)configMap.size());
    }

    public static int getIntConfig(String key) {
        Object value = configMap.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new IllegalArgumentException("Config key not found or not an int: " + key);
    }

    public static float getFloatConfig(String key) {
        Object value = configMap.get(key);
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        throw new IllegalArgumentException("Config key not found or not a float: " + key);
    }

    public static boolean getBooleanConfig(String key) {
        Object value = configMap.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new IllegalArgumentException("Config key not found or not a boolean: " + key);
    }

    public static long getLongConfig(String key) {
        Object value = configMap.get(key);
        if (value instanceof Long) {
            return (Long)value;
        }
        throw new IllegalArgumentException("Config key not found or not a long: " + key);
    }

    public static String getStringConfig(String key) {
        Object value = configMap.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        throw new IllegalArgumentException("Config key not found or not a string: " + key);
    }

    public static List<class_2960> getResourceLocationList(String key) {
        Object value = configMap.get(key);
        if (value instanceof List) {
            return (List)value;
        }
        throw new IllegalArgumentException("Config key not found or not a resource location list: " + key);
    }

    private static void saveConfig() {
        try {
            if (!Files.exists(CONFIG_PATH.getParent(), new LinkOption[0])) {
                Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            }
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                Map<String, Object> nested = CobblelootsConfig.unflatten(configMap);
                CobblelootsConfig.writeYaml(writer, nested, 0);
            }
        }
        catch (IOException | ClassCastException e) {
            Cobbleloots.LOGGER.error("Failed to save config: {}", (Object)e.getMessage());
        }
    }

    private static Map<String, Object> flatten(Map<String, Object> map, String prefix) {
        HashMap<String, Object> flat = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key;
            String string = key = prefix.isEmpty() ? entry.getKey() : prefix + "." + entry.getKey();
            if (entry.getValue() instanceof Map) {
                flat.putAll(CobblelootsConfig.flatten((Map)entry.getValue(), key));
                continue;
            }
            flat.put(key, entry.getValue());
        }
        return flat;
    }

    static Map<String, Object> unflatten(Map<String, Object> flat) {
        HashMap<String, Object> nested = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : flat.entrySet()) {
            String[] parts = entry.getKey().split("\\.");
            Map<String, Object> current = nested;
            for (int i = 0; i < parts.length - 1; ++i) {
                current = (Map)current.computeIfAbsent(parts[i], k -> new HashMap());
            }
            current.put(parts[parts.length - 1], entry.getValue());
        }
        return nested;
    }

    private static void writeYaml(BufferedWriter writer, Map<String, Object> map, int indent) throws IOException {
        String indentStr = " ".repeat(indent);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Map) {
                writer.write(indentStr + entry.getKey() + ":\n");
                CobblelootsConfig.writeYaml(writer, (Map)value, indent + 2);
                continue;
            }
            if (value instanceof List) {
                List listValue = (List)value;
                if (listValue.isEmpty()) {
                    writer.write(indentStr + entry.getKey() + ": []\n");
                    continue;
                }
                if (listValue.get(0) instanceof class_2960) {
                    writer.write(indentStr + entry.getKey() + ":\n");
                    for (Object item : listValue) {
                        writer.write(indentStr + "  - " + ((class_2960)item).toString() + "\n");
                    }
                    continue;
                }
                writer.write(indentStr + entry.getKey() + ":\n");
                for (Object item : listValue) {
                    writer.write(indentStr + "  - " + item.toString() + "\n");
                }
                continue;
            }
            writer.write(indentStr + entry.getKey() + ": " + String.valueOf(value) + "\n");
        }
    }
}

