/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.trees;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3111;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFFlatWave;
import org.betterx.bclib.sdf.operator.SDFScale;
import org.betterx.bclib.sdf.operator.SDFScale3D;
import org.betterx.bclib.sdf.operator.SDFSmoothUnion;
import org.betterx.bclib.sdf.operator.SDFSubtraction;
import org.betterx.bclib.sdf.operator.SDFTranslate;
import org.betterx.bclib.sdf.operator.SDFUnary;
import org.betterx.bclib.sdf.operator.SDFUnion;
import org.betterx.bclib.sdf.primitive.SDFPrimitive;
import org.betterx.bclib.sdf.primitive.SDFSphere;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.bclib.util.SplineHelper;
import org.betterx.betterend.blocks.UmbrellaTreeClusterBlock;
import org.betterx.betterend.blocks.UmbrellaTreeMembraneBlock;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;
import org.joml.Vector3f;

public class UmbrellaTreeFeature
extends DefaultFeature {
    private static final Function<class_2680, Boolean> REPLACE;
    private static final List<Vector3f> SPLINE;
    private static final List<Vector3f> ROOT;

    public boolean method_13151(class_5821<class_3111> featureConfig) {
        class_5819 random = featureConfig.method_33654();
        class_2338 pos = featureConfig.method_33655();
        class_5281 world = featureConfig.method_33652();
        class_3111 config = (class_3111)featureConfig.method_33656();
        if (!world.method_8320(pos.method_10074()).method_26164(class_3481.field_21953)) {
            return false;
        }
        class_2680 wood = EndBlocks.UMBRELLA_TREE.getBark().method_9564();
        class_2680 membrane = (class_2680)EndBlocks.UMBRELLA_TREE_MEMBRANE.method_9564().method_11657((class_2769)UmbrellaTreeMembraneBlock.COLOR, (Comparable)Integer.valueOf(1));
        class_2680 center = (class_2680)EndBlocks.UMBRELLA_TREE_MEMBRANE.method_9564().method_11657((class_2769)UmbrellaTreeMembraneBlock.COLOR, (Comparable)Integer.valueOf(0));
        class_2680 fruit = (class_2680)EndBlocks.UMBRELLA_TREE_CLUSTER.method_9564().method_11657((class_2769)UmbrellaTreeClusterBlock.NATURAL, (Comparable)Boolean.valueOf(true));
        float size = MHelper.randRange((int)10, (int)20, (class_5819)random);
        int count = (int)(size * 0.15f);
        float var = (float)Math.PI * 2 / (float)(count * 3);
        float start = MHelper.randRange((float)0.0f, (float)((float)Math.PI * 2), (class_5819)random);
        SDFUnary sdf = null;
        ArrayList centers = Lists.newArrayList();
        float scale = 1.0f;
        if (config != null) {
            scale = MHelper.randRange((float)1.0f, (float)1.7f, (class_5819)random);
        }
        for (int i = 0; i < count; ++i) {
            float angle = (float)i / (float)count * ((float)Math.PI * 2) + MHelper.randRange((float)0.0f, (float)var, (class_5819)random) + start;
            List spline = SplineHelper.copySpline(SPLINE);
            float sizeXZ = (size + MHelper.randRange((float)0.0f, (float)(size * 0.5f), (class_5819)random)) * 0.7f;
            SplineHelper.scale((List)spline, (float)sizeXZ, (float)(sizeXZ * MHelper.randRange((float)1.0f, (float)2.0f, (class_5819)random)), (float)sizeXZ);
            SplineHelper.rotateSpline((List)spline, (float)angle);
            SplineHelper.offsetParts((List)spline, (class_5819)random, (float)0.5f, (float)0.0f, (float)0.5f);
            if (!SplineHelper.canGenerate((List)spline, (class_2338)pos, (class_5281)world, REPLACE)) continue;
            float rScale = (scale - 1.0f) * 0.4f + 1.0f;
            SDF branch = SplineHelper.buildSDF((List)spline, (float)(1.2f * rScale), (float)(0.8f * rScale), bpos -> wood);
            Vector3f vec = (Vector3f)spline.get(spline.size() - 1);
            float radius = (size + MHelper.randRange((float)0.0f, (float)(size * 0.5f), (class_5819)random)) * 0.4f;
            sdf = sdf == null ? branch : new SDFUnion().setSourceA((SDF)sdf).setSourceB(branch);
            SDF mem = this.makeMembrane(radius, random, membrane, center);
            float px = (float)MHelper.floor((double)vec.x()) + 0.5f;
            float py = (float)MHelper.floor((double)vec.y()) + 0.5f;
            float pz = (float)MHelper.floor((double)vec.z()) + 0.5f;
            mem = new SDFTranslate().setTranslate(px, py, pz).setSource(mem);
            sdf = new SDFSmoothUnion().setRadius(2.0f).setSourceA((SDF)sdf).setSourceB(mem);
            centers.add(new Center((double)pos.method_10263() + (double)(px * scale), (double)pos.method_10264() + (double)(py * scale), (double)pos.method_10260() + (double)(pz * scale), radius * scale));
        }
        if (sdf == null) {
            return false;
        }
        if (scale > 1.0f) {
            sdf = new SDFScale().setScale(scale).setSource(sdf);
        }
        sdf.setReplaceFunction(REPLACE).addPostProcess(info -> {
            if (EndBlocks.UMBRELLA_TREE.isTreeLog(info.getStateUp()) && EndBlocks.UMBRELLA_TREE.isTreeLog(info.getStateDown())) {
                return EndBlocks.UMBRELLA_TREE.getLog().method_9564();
            }
            if (info.getState().equals(membrane)) {
                Center min = (Center)centers.get(0);
                double d = Double.MAX_VALUE;
                class_2338 bpos = info.getPos();
                for (Center c : centers) {
                    double d2 = c.distance(bpos.method_10263(), bpos.method_10260());
                    if (!(d2 < d)) continue;
                    d = d2;
                    min = c;
                }
                int color = MHelper.floor((double)(d / (double)min.radius * 7.0));
                color = class_3532.method_15340((int)color, (int)1, (int)7);
                return (class_2680)info.getState().method_11657((class_2769)UmbrellaTreeMembraneBlock.COLOR, (Comparable)Integer.valueOf(color));
            }
            return info.getState();
        }).fillRecursive((class_5425)world, pos);
        this.makeRoots(world, pos, (size * 0.5f + 3.0f) * scale, random, wood);
        for (Center c : centers) {
            if (world.method_8320(new class_2338((int)c.px, (int)c.py, (int)c.pz)).method_26215()) continue;
            count = MHelper.floor((double)(MHelper.randRange((float)5.0f, (float)10.0f, (class_5819)random) * scale));
            float startAngle = random.method_43057() * ((float)Math.PI * 2);
            for (int i = 0; i < count; ++i) {
                float angle = (float)i / (float)count * ((float)Math.PI * 2) + startAngle;
                float dist = MHelper.randRange((float)1.5f, (float)2.5f, (class_5819)random) * scale;
                double px = c.px + Math.sin(angle) * (double)dist;
                double pz = c.pz + Math.cos(angle) * (double)dist;
                this.makeFruits(world, px, c.py - 1.0, pz, fruit);
            }
        }
        return true;
    }

    private void makeRoots(class_5281 world, class_2338 pos, float radius, class_5819 random, class_2680 wood) {
        int count = (int)(radius * 1.5f);
        for (int i = 0; i < count; ++i) {
            float angle = (float)i / (float)count * ((float)Math.PI * 2);
            float scale = radius * MHelper.randRange((float)0.85f, (float)1.15f, (class_5819)random);
            List branch = SplineHelper.copySpline(ROOT);
            SplineHelper.rotateSpline((List)branch, (float)angle);
            SplineHelper.scale((List)branch, (float)scale);
            Vector3f last = (Vector3f)branch.get(branch.size() - 1);
            if (!world.method_8320(pos.method_10069((int)last.x(), (int)last.y(), (int)last.z())).method_26164(CommonBlockTags.END_STONES)) continue;
            SplineHelper.fillSplineForce((List)branch, (class_5281)world, (class_2680)wood, (class_2338)pos, REPLACE);
        }
    }

    private SDF makeMembrane(float radius, class_5819 random, class_2680 membrane, class_2680 center) {
        SDFPrimitive sphere = new SDFSphere().setRadius(radius).setBlock(membrane);
        SDFUnary sub = new SDFTranslate().setTranslate(0.0f, -4.0f, 0.0f).setSource((SDF)sphere);
        sphere = new SDFSubtraction().setSourceA((SDF)sphere).setSourceB((SDF)sub);
        sphere = new SDFScale3D().setScale(1.0f, 0.5f, 1.0f).setSource((SDF)sphere);
        sphere = new SDFTranslate().setTranslate(0.0f, 1.0f - radius * 0.5f, 0.0f).setSource((SDF)sphere);
        float angle = random.method_43057() * ((float)Math.PI * 2);
        int count = (int)MHelper.randRange((float)radius, (float)(radius * 2.0f), (class_5819)random);
        if (count < 5) {
            count = 5;
        }
        sphere = new SDFFlatWave().setAngle(angle).setRaysCount(count).setIntensity(0.6f).setSource((SDF)sphere);
        SDFPrimitive cent = new SDFSphere().setRadius(2.5f).setBlock(center);
        sphere = new SDFUnion().setSourceA((SDF)sphere).setSourceB((SDF)cent);
        return sphere;
    }

    private void makeFruits(class_5281 world, double px, double py, double pz, class_2680 fruit) {
        class_2338.class_2339 mut = new class_2338.class_2339().method_10102(px, py, pz);
        for (int i = 0; i < 8; ++i) {
            mut.method_10098(class_2350.field_11033);
            if (!world.method_22347((class_2338)mut)) continue;
            class_2680 state = world.method_8320(mut.method_10084());
            if (!state.method_27852(EndBlocks.UMBRELLA_TREE_MEMBRANE) || (Integer)state.method_11654((class_2769)UmbrellaTreeMembraneBlock.COLOR) >= 2) break;
            BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)mut, (class_2680)fruit);
            break;
        }
    }

    static {
        SPLINE = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.1f, 0.35f, 0.0f), new Vector3f(0.2f, 0.5f, 0.0f), new Vector3f(0.3f, 0.55f, 0.0f), new Vector3f(0.42f, 0.7f, 0.0f), new Vector3f(0.5f, 1.0f, 0.0f)});
        ROOT = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.1f, 0.7f, 0.0f), new Vector3f(0.3f, 0.3f, 0.0f), new Vector3f(0.7f, 0.05f, 0.0f), new Vector3f(0.8f, -0.2f, 0.0f)});
        SplineHelper.offset(ROOT, (Vector3f)new Vector3f(0.0f, -0.45f, 0.0f));
        REPLACE = state -> {
            if (state.method_27852(EndBlocks.UMBRELLA_TREE_MEMBRANE)) {
                return true;
            }
            return BlocksHelper.replaceableOrPlant((class_2680)state);
        };
    }

    private static class Center {
        final double px;
        final double py;
        final double pz;
        final float radius;

        Center(double x, double y, double z, float radius) {
            this.px = x;
            this.py = y;
            this.pz = z;
            this.radius = radius;
        }

        double distance(float x, float z) {
            return MHelper.length((double)(this.px - (double)x), (double)(this.pz - (double)z));
        }
    }
}

