/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.structures.piece;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3532;
import net.minecraft.class_3773;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.world.structures.piece.BasePiece;

public abstract class MountainPiece
extends BasePiece {
    protected Map<Integer, Integer> heightmap = Maps.newHashMap();
    protected OpenSimplexNoise noise1;
    protected OpenSimplexNoise noise2;
    protected class_2338 center;
    protected float radius;
    protected float height;
    protected float r2;
    protected class_5321<class_1959> biomeID;
    protected int seed1;
    protected int seed2;

    public MountainPiece(class_3773 type, class_2338 center, float radius, float height, class_5819 random, class_6880<class_1959> biome) {
        super(type, random.method_43054(), null);
        this.center = center;
        this.radius = radius;
        this.height = height;
        this.r2 = radius * radius;
        this.seed1 = random.method_43054();
        this.seed2 = random.method_43054();
        this.noise1 = new OpenSimplexNoise(this.seed1);
        this.noise2 = new OpenSimplexNoise(this.seed2);
        this.biomeID = biome.method_40230().orElse(null);
        this.makeBoundingBox();
    }

    public MountainPiece(class_3773 type, class_2487 tag) {
        super(type, tag);
        this.makeBoundingBox();
    }

    @Override
    protected void addAdditionalSaveData(class_2487 tag) {
        tag.method_10566("center", class_2512.method_10692((class_2338)this.center));
        tag.method_10548("radius", this.radius);
        tag.method_10548("height", this.height);
        tag.method_10582("biome", this.biomeID.method_29177().toString());
        tag.method_10569("seed1", this.seed1);
        tag.method_10569("seed2", this.seed2);
    }

    @Override
    protected void fromNbt(class_2487 tag) {
        this.center = class_2512.method_10691((class_2487)tag, (String)"center").orElse(class_2338.field_10980);
        this.radius = tag.method_10583("radius");
        this.height = tag.method_10583("height");
        this.biomeID = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60654((String)tag.method_10558("biome")));
        this.r2 = this.radius * this.radius;
        this.seed1 = tag.method_10550("seed1");
        this.seed2 = tag.method_10550("seed2");
        this.noise1 = new OpenSimplexNoise(this.seed1);
        this.noise2 = new OpenSimplexNoise(this.seed2);
    }

    private int getHeight(class_5281 world, class_2338 pos) {
        int p = (pos.method_10263() & 0x7FF) << 11 | pos.method_10260() & 0x7FF;
        int h = this.heightmap.getOrDefault(p, Integer.MIN_VALUE);
        if (h > Integer.MIN_VALUE) {
            return h;
        }
        if (!world.method_23753(pos).method_40225(this.biomeID)) {
            this.heightmap.put(p, -10);
            return -10;
        }
        h = world.method_8624(class_2902.class_2903.field_13194, pos.method_10263(), pos.method_10260());
        if ((h = class_3532.method_15382((int)(h - this.center.method_10264()))) > 4) {
            h = 4 - h;
            this.heightmap.put(p, h);
            return h;
        }
        h = MHelper.floor((double)(this.noise2.eval((double)pos.method_10263() * 0.01, (double)pos.method_10260() * 0.01) * this.noise2.eval((double)pos.method_10263() * 0.002, (double)pos.method_10260() * 0.002) * 8.0 + 8.0));
        if (h < 0) {
            this.heightmap.put(p, 0);
            return 0;
        }
        this.heightmap.put(p, h);
        return h;
    }

    protected float getHeightClamp(class_5281 world, int radius, int posX, int posZ) {
        class_2338.class_2339 mut = new class_2338.class_2339();
        float height = 0.0f;
        float max = 0.0f;
        for (int x = -radius; x <= radius; ++x) {
            mut.method_33097(posX + x);
            int x2 = x * x;
            for (int z = -radius; z <= radius; ++z) {
                mut.method_33099(posZ + z);
                int z2 = z * z;
                float mult = 1.0f - (float)Math.sqrt(x2 + z2) / (float)radius;
                if (!(mult > 0.0f)) continue;
                max += mult;
                height += (float)this.getHeight(world, (class_2338)mut) * mult;
            }
        }
        return class_3532.method_15363((float)((height /= max) / (float)radius), (float)0.0f, (float)1.0f);
    }

    private void makeBoundingBox() {
        int minX = MHelper.floor((double)((float)this.center.method_10263() - this.radius));
        int minY = MHelper.floor((double)((float)this.center.method_10264() - this.radius));
        int minZ = MHelper.floor((double)((float)this.center.method_10260() - this.radius));
        int maxX = MHelper.floor((double)((float)this.center.method_10263() + this.radius + 1.0f));
        int maxY = MHelper.floor((double)((float)this.center.method_10264() + this.radius + 1.0f));
        int maxZ = MHelper.floor((double)((float)this.center.method_10260() + this.radius + 1.0f));
        this.field_15315 = new class_3341(minX, minY, minZ, maxX, maxY, maxZ);
    }
}

