/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.biome.cave;

import com.mojang.serialization.MapCodec;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2975;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7243;
import org.betterx.bclib.interfaces.SurfaceMaterialProvider;
import org.betterx.bclib.util.WeightedList;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.betterend.world.biome.EndBiomeBuilder;
import org.betterx.betterend.world.biome.EndBiomeKey;
import org.betterx.betterend.world.biome.cave.EndCaveBiome;
import org.betterx.wover.biome.api.BiomeKey;
import org.betterx.wover.biome.api.data.BiomeGenerationDataContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JadeCaveBiome
extends EndCaveBiome.Config<JadeCaveBiome> {
    public static final MapCodec<Biome> CODEC = EndCaveBiome.simpleCaveBiomeCodec(Biome::new);
    public static final class_7243<Biome> KEY_CODEC = class_7243.method_42116(CODEC);

    public JadeCaveBiome(EndBiomeKey<JadeCaveBiome, ?> key) {
        super(key);
    }

    @Override
    public void addCustomBuildData(EndBiomeBuilder builder) {
        super.addCustomBuildData(builder);
        ((EndBiomeBuilder)((EndBiomeBuilder)builder.fogColor(118, 150, 112)).fogDensity(2.0f)).waterAndFogColor(95, 223, 255);
    }

    @Override
    @NotNull
    public EndBiome instantiateBiome(float fogDensity, BiomeKey<?> key, @NotNull BiomeGenerationDataContainer generatorData, float terrainHeight, float genChance, int edgeSize, boolean vertical, @Nullable class_5321<class_1959> edge, @Nullable class_5321<class_1959> parent, boolean hasCave, SurfaceMaterialProvider surface) {
        return new Biome(fogDensity, (class_5321<class_1959>)key.key, generatorData, terrainHeight, genChance, edgeSize, vertical, edge, parent, hasCave, surface, new WeightedList(), new WeightedList());
    }

    public static class Biome
    extends EndCaveBiome {
        private static final OpenSimplexNoise WALL_NOISE = new OpenSimplexNoise("jade_cave".hashCode());
        private static final OpenSimplexNoise DEPTH_NOISE = new OpenSimplexNoise("depth_noise".hashCode());
        private static final class_2680[] JADE = new class_2680[3];

        public class_7243<? extends EndCaveBiome> codec() {
            return KEY_CODEC;
        }

        protected Biome(float fogDensity, @NotNull class_5321<class_1959> biome, @NotNull BiomeGenerationDataContainer generatorData, float terrainHeight, float genChance, int edgeSize, boolean vertical, @Nullable class_5321<class_1959> edge, @Nullable class_5321<class_1959> parent, boolean hasCaves, SurfaceMaterialProvider surface, WeightedList<class_6880<class_2975<?, ?>>> floorFeatures, WeightedList<class_6880<class_2975<?, ?>>> ceilFeatures) {
            super(fogDensity, biome, generatorData, terrainHeight, genChance, edgeSize, vertical, edge, parent, hasCaves, surface, floorFeatures, ceilFeatures);
        }

        @Override
        public class_2680 getWall(class_2338 pos) {
            double depth = DEPTH_NOISE.eval((double)pos.method_10263() * 0.02, (double)pos.method_10260() * 0.02) * 0.2 + 0.5;
            int index = class_3532.method_15357((double)(((double)pos.method_10264() + WALL_NOISE.eval((double)pos.method_10263() * 0.2, (double)pos.method_10260() * 0.2) * 1.5) * depth + 0.5));
            index = class_3532.method_15382((int)index) % 3;
            return JADE[index];
        }

        static {
            Biome.JADE[0] = EndBlocks.VIRID_JADESTONE.stone.method_9564();
            Biome.JADE[1] = EndBlocks.AZURE_JADESTONE.stone.method_9564();
            Biome.JADE[2] = EndBlocks.SANDY_JADESTONE.stone.method_9564();
        }
    }
}

