/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.registry;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.registry.EndTags;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.betterend.world.biome.EndBiomeBuilder;
import org.betterx.betterend.world.biome.EndBiomeKey;
import org.betterx.betterend.world.biome.air.BiomeIceStarfield;
import org.betterx.betterend.world.biome.cave.EmptyAuroraCaveBiome;
import org.betterx.betterend.world.biome.cave.EmptyEndCaveBiome;
import org.betterx.betterend.world.biome.cave.EmptySmaragdantCaveBiome;
import org.betterx.betterend.world.biome.cave.EndCaveBiome;
import org.betterx.betterend.world.biome.cave.JadeCaveBiome;
import org.betterx.betterend.world.biome.cave.LushAuroraCaveBiome;
import org.betterx.betterend.world.biome.cave.LushSmaragdantCaveBiome;
import org.betterx.betterend.world.biome.land.AmberLandBiome;
import org.betterx.betterend.world.biome.land.BlossomingSpiresBiome;
import org.betterx.betterend.world.biome.land.ChorusForestBiome;
import org.betterx.betterend.world.biome.land.CrystalMountainsBiome;
import org.betterx.betterend.world.biome.land.DragonGraveyardsBiome;
import org.betterx.betterend.world.biome.land.DryShrublandBiome;
import org.betterx.betterend.world.biome.land.DustWastelandsBiome;
import org.betterx.betterend.world.biome.land.FoggyMushroomlandBiome;
import org.betterx.betterend.world.biome.land.GlowingGrasslandsBiome;
import org.betterx.betterend.world.biome.land.LanternWoodsBiome;
import org.betterx.betterend.world.biome.land.MegalakeBiome;
import org.betterx.betterend.world.biome.land.MegalakeGroveBiome;
import org.betterx.betterend.world.biome.land.NeonOasisBiome;
import org.betterx.betterend.world.biome.land.PaintedMountainsBiome;
import org.betterx.betterend.world.biome.land.ShadowForestBiome;
import org.betterx.betterend.world.biome.land.SulphurSpringsBiome;
import org.betterx.betterend.world.biome.land.UmbraValleyBiome;
import org.betterx.betterend.world.biome.land.UmbrellaJungleBiome;
import org.betterx.betterend.world.generator.GeneratorOptions;
import org.betterx.wover.biome.api.data.BiomeCodecRegistry;
import org.betterx.wover.biome.api.data.BiomeData;
import org.betterx.wover.biome.api.data.BiomeDataRegistry;
import org.betterx.wover.events.api.Subscriber;
import org.betterx.wover.events.api.WorldLifecycle;
import org.betterx.wover.events.api.types.OnServerLevelReady;
import org.betterx.wover.generator.api.biomesource.WoverBiomePicker;
import org.betterx.wover.generator.impl.biomesource.end.WoverEndBiomeSource;
import org.betterx.wover.generator.impl.map.hex.HexBiomeMap;
import org.betterx.wover.state.api.WorldState;

public class EndBiomes {
    public static WoverBiomePicker CAVE_BIOMES = null;
    private static HexBiomeMap caveBiomeMap;
    private static long lastSeed;
    public static final EndBiomeKey<AmberLandBiome, ?> AMBER_LAND;
    public static final EndBiomeKey<BlossomingSpiresBiome, ?> BLOSSOMING_SPIRES;
    public static final EndBiomeKey<ChorusForestBiome, ?> CHORUS_FOREST;
    public static final EndBiomeKey<CrystalMountainsBiome, ?> CRYSTAL_MOUNTAINS;
    public static final EndBiomeKey<DragonGraveyardsBiome, ?> DRAGON_GRAVEYARDS;
    public static final EndBiomeKey<DryShrublandBiome, ?> DRY_SHRUBLAND;
    public static final EndBiomeKey<DustWastelandsBiome, ?> DUST_WASTELANDS;
    public static final EndBiomeKey<FoggyMushroomlandBiome, ?> FOGGY_MUSHROOMLAND;
    public static final EndBiomeKey<GlowingGrasslandsBiome, ?> GLOWING_GRASSLANDS;
    public static final EndBiomeKey<BiomeIceStarfield, ?> ICE_STARFIELD;
    public static final EndBiomeKey<LanternWoodsBiome, ?> LANTERN_WOODS;
    public static final EndBiomeKey<MegalakeBiome, ?> MEGALAKE;
    public static final EndBiomeKey<ShadowForestBiome, ?> SHADOW_FOREST;
    public static final EndBiomeKey<SulphurSpringsBiome, ?> SULPHUR_SPRINGS;
    public static final EndBiomeKey<UmbrellaJungleBiome, ?> UMBRELLA_JUNGLE;
    public static final EndBiomeKey<UmbraValleyBiome, ?> UMBRA_VALLEY;
    public static final EndBiomeKey<MegalakeGroveBiome, MegalakeBiome> MEGALAKE_GROVE;
    public static final EndBiomeKey<NeonOasisBiome, DustWastelandsBiome> NEON_OASIS;
    public static final EndBiomeKey<PaintedMountainsBiome, DustWastelandsBiome> PAINTED_MOUNTAINS;
    public static final EndBiomeKey<EmptyEndCaveBiome, ?> EMPTY_END_CAVE;
    public static final EndBiomeKey<EmptySmaragdantCaveBiome, ?> EMPTY_SMARAGDANT_CAVE;
    public static final EndBiomeKey<LushSmaragdantCaveBiome, ?> LUSH_SMARAGDANT_CAVE;
    public static final EndBiomeKey<EmptyAuroraCaveBiome, ?> EMPTY_AURORA_CAVE;
    public static final EndBiomeKey<LushAuroraCaveBiome, ?> LUSH_AURORA_CAVE;
    public static final EndBiomeKey<JadeCaveBiome, ?> JADE_CAVE;

    public static void register() {
        BiomeCodecRegistry.register((class_2960)BetterEnd.C.mk("biome"), EndBiome.KEY_CODEC);
        BiomeCodecRegistry.register((class_2960)BetterEnd.C.mk("cave_biome"), EndCaveBiome.KEY_CODEC);
        BiomeCodecRegistry.register((class_2960)BetterEnd.C.mk("empty_aurora_cave_biome"), EmptyAuroraCaveBiome.KEY_CODEC);
        BiomeCodecRegistry.register((class_2960)BetterEnd.C.mk("empty_end_cave_biome"), EmptyEndCaveBiome.KEY_CODEC);
        BiomeCodecRegistry.register((class_2960)BetterEnd.C.mk("empty_smaragdant_cave_biome"), EmptySmaragdantCaveBiome.KEY_CODEC);
        BiomeCodecRegistry.register((class_2960)BetterEnd.C.mk("jade_cave_biome"), JadeCaveBiome.KEY_CODEC);
        BiomeCodecRegistry.register((class_2960)BetterEnd.C.mk("lush_aurora_cave_biome"), LushAuroraCaveBiome.KEY_CODEC);
        BiomeCodecRegistry.register((class_2960)BetterEnd.C.mk("lush_smaragdant_cave_biome"), LushSmaragdantCaveBiome.KEY_CODEC);
        WorldLifecycle.SERVER_LEVEL_READY.subscribe((Subscriber)((OnServerLevelReady)EndBiomes::onServerLevelReady));
    }

    private static void onServerLevelReady(class_3218 level, class_5321<class_1937> levelResourceKey, class_5363 levelStem, long seed) {
        class_2378 registry = WorldState.allStageRegistryAccess().method_30530(class_7924.field_41236);
        class_2378 dataRegistry = (class_2378)WorldState.allStageRegistryAccess().method_33310(BiomeDataRegistry.BIOME_DATA_REGISTRY).orElseThrow();
        if (CAVE_BIOMES == null || EndBiomes.CAVE_BIOMES.biomeRegistry != registry) {
            CAVE_BIOMES = new WoverBiomePicker(class_1972.field_9442);
            registry.method_40266(EndTags.IS_END_CAVE).map(tag -> tag.method_40239().map(class_6880::method_40230).filter(Optional::isPresent).map(Optional::orElseThrow).map(k -> (BiomeData)dataRegistry.method_10223(k.method_29177())).filter(Objects::nonNull)).ifPresent(list -> list.forEach(data -> CAVE_BIOMES.addBiome(data)));
            CAVE_BIOMES.rebuild();
            caveBiomeMap = null;
        }
        if (caveBiomeMap == null || lastSeed != seed) {
            if (level.method_14178().method_12129().method_12098() instanceof WoverEndBiomeSource) {
                WoverEndBiomeSource biomeSource = (WoverEndBiomeSource)level.method_14178().method_12129().method_12098();
                caveBiomeMap = new HexBiomeMap(seed, GeneratorOptions.getBiomeSizeCaves(), CAVE_BIOMES);
            } else {
                caveBiomeMap = new HexBiomeMap(seed, GeneratorOptions.getBiomeSizeCaves(), CAVE_BIOMES);
            }
            lastSeed = seed;
        }
    }

    public static WoverBiomePicker.PickableBiome getCaveBiome(int x, int z) {
        return caveBiomeMap.getBiome((double)x, 5.0, (double)z);
    }

    static {
        AMBER_LAND = EndBiomeBuilder.createKey("amber_land");
        BLOSSOMING_SPIRES = EndBiomeBuilder.createKey("blossoming_spires");
        CHORUS_FOREST = EndBiomeBuilder.createKey("chorus_forest");
        CRYSTAL_MOUNTAINS = EndBiomeBuilder.createKey("crystal_mountains");
        DRAGON_GRAVEYARDS = EndBiomeBuilder.createKey("dragon_graveyards");
        DRY_SHRUBLAND = EndBiomeBuilder.createKey("dry_shrubland");
        DUST_WASTELANDS = EndBiomeBuilder.createKey("dust_wastelands");
        FOGGY_MUSHROOMLAND = EndBiomeBuilder.createKey("foggy_mushroomland");
        GLOWING_GRASSLANDS = EndBiomeBuilder.createKey("glowing_grasslands");
        ICE_STARFIELD = EndBiomeBuilder.createKey("ice_starfield");
        LANTERN_WOODS = EndBiomeBuilder.createKey("lantern_woods");
        MEGALAKE = EndBiomeBuilder.createKey("megalake");
        SHADOW_FOREST = EndBiomeBuilder.createKey("shadow_forest");
        SULPHUR_SPRINGS = EndBiomeBuilder.createKey("sulphur_springs");
        UMBRELLA_JUNGLE = EndBiomeBuilder.createKey("umbrella_jungle");
        UMBRA_VALLEY = EndBiomeBuilder.createKey("umbra_valley");
        MEGALAKE_GROVE = EndBiomeBuilder.createKey("megalake_grove", MEGALAKE);
        NEON_OASIS = EndBiomeBuilder.createKey("neon_oasis", DUST_WASTELANDS);
        PAINTED_MOUNTAINS = EndBiomeBuilder.createKey("painted_mountains", DUST_WASTELANDS);
        EMPTY_END_CAVE = EndBiomeBuilder.createKey("empty_end_cave");
        EMPTY_SMARAGDANT_CAVE = EndBiomeBuilder.createKey("empty_smaragdant_cave");
        LUSH_SMARAGDANT_CAVE = EndBiomeBuilder.createKey("lush_smaragdant_cave");
        EMPTY_AURORA_CAVE = EndBiomeBuilder.createKey("empty_aurora_cave");
        LUSH_AURORA_CAVE = EndBiomeBuilder.createKey("lush_aurora_cave");
        JADE_CAVE = EndBiomeBuilder.createKey("jade_cave");
    }
}

