/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks.basis;

import com.google.common.collect.Lists;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4917;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4970;
import net.minecraft.class_9062;
import org.betterx.bclib.blocks.BaseBlockNotFull;
import org.betterx.betterend.blocks.EndBlockProperties;
import org.betterx.betterend.blocks.InfusionPedestal;
import org.betterx.betterend.blocks.entities.InfusionPedestalEntity;
import org.betterx.betterend.blocks.entities.PedestalBlockEntity;
import org.betterx.betterend.client.models.EndModels;
import org.betterx.betterend.registry.EndTags;
import org.betterx.betterend.rituals.InfusionRitual;
import org.betterx.wover.block.api.BlockProperties;
import org.betterx.wover.block.api.BlockTagProvider;
import org.betterx.wover.block.api.model.BlockModelProvider;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PedestalBlock
extends BaseBlockNotFull
implements class_2343,
BlockTagProvider,
BlockModelProvider {
    public static final class_2754<EndBlockProperties.PedestalState> STATE = EndBlockProperties.PEDESTAL_STATE;
    public static final class_2746 HAS_ITEM = EndBlockProperties.HAS_ITEM;
    public static final class_2746 HAS_LIGHT = BlockProperties.HAS_LIGHT;
    private static final class_265 SHAPE_DEFAULT;
    private static final class_265 SHAPE_COLUMN;
    private static final class_265 SHAPE_PILLAR;
    private static final class_265 SHAPE_PEDESTAL_TOP;
    private static final class_265 SHAPE_COLUMN_TOP;
    private static final class_265 SHAPE_BOTTOM;
    protected final class_2248 parent;
    protected float height = 1.0f;
    private static final Map<EndBlockProperties.PedestalState, class_4942> PEDESTAL_MODELS;

    public PedestalBlock(class_2248 parent) {
        super(class_4970.class_2251.method_9630((class_4970)parent).method_9631(PedestalBlock.getLuminance(parent.method_9564())));
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.DEFAULT))).method_11657((class_2769)HAS_ITEM, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)HAS_LIGHT, (Comparable)Boolean.valueOf(false)));
        this.parent = parent;
    }

    private static ToIntFunction<class_2680> getLuminance(class_2680 parent) {
        int light = parent.method_26213();
        if (light > 0) {
            return state -> light;
        }
        return state -> (Boolean)state.method_11654((class_2769)HAS_LIGHT) != false ? 12 : 0;
    }

    public float getHeight(class_2680 state) {
        if (state.method_26204() instanceof PedestalBlock && state.method_11654(STATE) == EndBlockProperties.PedestalState.PEDESTAL_TOP) {
            return this.height - 0.2f;
        }
        return this.height;
    }

    @NotNull
    public class_9062 method_55765(class_1799 itemStack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!state.method_27852((class_2248)this) || !this.isPlaceable(state)) {
            return class_9062.field_47731;
        }
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof PedestalBlockEntity) {
            PedestalBlockEntity pedestal = (PedestalBlockEntity)blockEntity;
            if (pedestal.method_5442()) {
                if (itemStack.method_7960()) {
                    return class_9062.field_47729;
                }
                pedestal.method_5447(0, itemStack);
                level.method_8524(pos);
                this.checkRitual(level, player, pos);
                return class_9062.method_55644((boolean)level.method_8608());
            }
            class_1799 stack = pedestal.method_5438(0);
            if (player.method_7270(stack)) {
                pedestal.method_5441(0);
                level.method_8524(pos);
                this.checkRitual(level, player, pos);
                return class_9062.method_55644((boolean)level.method_8608());
            }
            return class_9062.field_47733;
        }
        return class_9062.field_47731;
    }

    public void method_9585(class_1936 levelAccessor, class_2338 blockPos, class_2680 blockState) {
        class_2338.class_2339 posMutable = new class_2338.class_2339();
        for (Point point : InfusionRitual.getMap()) {
            InfusionPedestalEntity pedestal;
            posMutable.method_10101((class_2382)blockPos).method_10100(point.x, 0, point.y);
            class_2680 state = levelAccessor.method_8320((class_2338)posMutable);
            if (!(state.method_26204() instanceof InfusionPedestal)) continue;
            class_2586 blockEntity = levelAccessor.method_8321((class_2338)posMutable);
            if (!(blockEntity instanceof InfusionPedestalEntity) || !(pedestal = (InfusionPedestalEntity)blockEntity).hasRitual()) break;
            pedestal.getRitual().setDirty();
            break;
        }
    }

    public void checkRitual(class_1937 world, class_1657 player, class_2338 pos) {
        class_2338.class_2339 posMutable = new class_2338.class_2339();
        for (Point point : InfusionRitual.getMap()) {
            posMutable.method_10101((class_2382)pos).method_10100(point.x, 0, point.y);
            class_2680 state = world.method_8320((class_2338)posMutable);
            if (!(state.method_26204() instanceof InfusionPedestal)) continue;
            ((InfusionPedestal)state.method_26204()).checkRitual(world, player, (class_2338)posMutable);
            break;
        }
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2680 upState = world.method_8320(pos.method_10084());
        class_2680 downState = world.method_8320(pos.method_10074());
        boolean upSideSolid = upState.method_26206((class_1922)world, pos.method_10084(), class_2350.field_11033) || upState.method_26164(class_3481.field_15504);
        boolean hasPedestalOver = upState.method_26204() instanceof PedestalBlock;
        boolean hasPedestalUnder = downState.method_26204() instanceof PedestalBlock;
        if (!hasPedestalOver && hasPedestalUnder && upSideSolid) {
            return (class_2680)this.method_9564().method_11657(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.COLUMN_TOP));
        }
        if (!hasPedestalOver && !hasPedestalUnder && upSideSolid) {
            return (class_2680)this.method_9564().method_11657(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.COLUMN));
        }
        if (hasPedestalUnder && hasPedestalOver) {
            return (class_2680)this.method_9564().method_11657(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.PILLAR));
        }
        if (hasPedestalUnder) {
            return (class_2680)this.method_9564().method_11657(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.PEDESTAL_TOP));
        }
        if (hasPedestalOver) {
            return (class_2680)this.method_9564().method_11657(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.BOTTOM));
        }
        return this.method_9564();
    }

    @NotNull
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 newState, class_1936 world, class_2338 pos, class_2338 posFrom) {
        class_2680 updated = this.getUpdatedState(state, direction, newState, world, pos, posFrom);
        if (!updated.method_27852((class_2248)this)) {
            return updated;
        }
        if (!this.isPlaceable(updated)) {
            this.moveStoredStack(world, updated, pos);
        }
        return updated;
    }

    private class_2680 getUpdatedState(class_2680 state, class_2350 direction, class_2680 newState, class_1936 world, class_2338 pos, class_2338 posFrom) {
        if (!state.method_27852((class_2248)this)) {
            return state.method_26191(direction, newState, world, pos, posFrom);
        }
        if (direction != class_2350.field_11036 && direction != class_2350.field_11033) {
            return state;
        }
        class_2680 upState = world.method_8320(pos.method_10084());
        class_2680 downState = world.method_8320(pos.method_10074());
        boolean upSideSolid = upState.method_26206((class_1922)world, pos.method_10084(), class_2350.field_11033) || upState.method_26164(class_3481.field_15504);
        boolean hasPedestalOver = upState.method_26204() instanceof PedestalBlock;
        boolean hasPedestalUnder = downState.method_26204() instanceof PedestalBlock;
        if (direction == class_2350.field_11036) {
            upSideSolid = newState.method_26206((class_1922)world, posFrom, class_2350.field_11033) || newState.method_26164(class_3481.field_15504);
            hasPedestalOver = newState.method_26204() instanceof PedestalBlock;
        } else {
            hasPedestalUnder = newState.method_26204() instanceof PedestalBlock;
        }
        class_2680 updatedState = !hasPedestalOver && hasPedestalUnder && upSideSolid ? (class_2680)state.method_11657(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.COLUMN_TOP)) : (!hasPedestalOver && !hasPedestalUnder && upSideSolid ? (class_2680)state.method_11657(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.COLUMN)) : (hasPedestalUnder && hasPedestalOver ? (class_2680)state.method_11657(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.PILLAR)) : (hasPedestalUnder ? (class_2680)state.method_11657(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.PEDESTAL_TOP)) : (hasPedestalOver ? (class_2680)state.method_11657(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.BOTTOM)) : (class_2680)state.method_11657(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.DEFAULT))))));
        if (!this.isPlaceable(updatedState)) {
            updatedState = (class_2680)((class_2680)updatedState.method_11657((class_2769)HAS_ITEM, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)HAS_LIGHT, (Comparable)Boolean.valueOf(false));
        }
        return updatedState;
    }

    @NotNull
    public List<class_1799> method_9560(@NotNull class_2680 state, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_8567.class_8568 builder) {
        ArrayList drop = Lists.newArrayList((Iterable)super.method_9560(state, builder));
        if (state.method_27852((class_2248)this)) {
            if (this.isPlaceable(state)) {
                PedestalBlockEntity pedestal;
                class_2586 blockEntity = (class_2586)builder.method_51876(class_181.field_1228);
                if (blockEntity instanceof PedestalBlockEntity && !(pedestal = (PedestalBlockEntity)blockEntity).method_5442()) {
                    drop.add(pedestal.method_5438(0));
                }
            } else {
                return drop;
            }
        }
        return drop;
    }

    private void moveStoredStack(class_1936 world, class_2680 state, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof PedestalBlockEntity) {
            class_1799 stack;
            PedestalBlockEntity pedestal = (PedestalBlockEntity)blockEntity;
            if (state.method_27852((class_2248)this) && !(stack = pedestal.method_5441(0)).method_7960()) {
                this.moveStoredStack(blockEntity, world, stack, pos.method_10084());
            }
        }
    }

    private void moveStoredStack(class_2586 blockEntity, class_1936 world, class_1799 stack, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        if (!state.method_27852((class_2248)this)) {
            this.dropStoredStack(blockEntity, stack, pos);
        } else if (((EndBlockProperties.PedestalState)((Object)state.method_11654(STATE))).equals((Object)EndBlockProperties.PedestalState.PILLAR)) {
            this.moveStoredStack(blockEntity, world, stack, pos.method_10084());
        } else if (!this.isPlaceable(state)) {
            this.dropStoredStack(blockEntity, stack, pos);
        } else if (blockEntity instanceof PedestalBlockEntity) {
            PedestalBlockEntity pedestal = (PedestalBlockEntity)blockEntity;
            if (pedestal.method_5442()) {
                pedestal.method_5447(0, stack);
            } else {
                this.dropStoredStack(blockEntity, stack, pos);
            }
        } else {
            this.dropStoredStack(blockEntity, stack, pos);
        }
    }

    private void dropStoredStack(class_2586 blockEntity, class_1799 stack, class_2338 pos) {
        if (blockEntity != null && blockEntity.method_10997() != null) {
            class_1937 world = blockEntity.method_10997();
            class_2248.method_9577((class_1937)world, (class_2338)this.getDropPos((class_1936)world, pos), (class_1799)stack);
        }
    }

    private class_2338 getDropPos(class_1936 world, class_2338 pos) {
        if (world.method_8320(pos).method_26215()) {
            return pos;
        }
        if (world.method_8320(pos.method_10084()).method_26215()) {
            return pos.method_10084();
        }
        for (int i = 2; i < class_2350.values().length; ++i) {
            class_2338 dropPos = pos.method_10093(class_2350.method_10143((int)i));
            if (!world.method_8320(dropPos).method_26215()) continue;
            return dropPos.method_10062();
        }
        return this.getDropPos(world, pos.method_10084());
    }

    public boolean isPlaceable(class_2680 state) {
        if (!state.method_27852((class_2248)this)) {
            return false;
        }
        EndBlockProperties.PedestalState currentState = (EndBlockProperties.PedestalState)((Object)state.method_11654(STATE));
        return currentState == EndBlockProperties.PedestalState.DEFAULT || currentState == EndBlockProperties.PedestalState.PEDESTAL_TOP;
    }

    @NotNull
    public class_265 method_9530(class_2680 state, @NotNull class_1922 world, @NotNull class_2338 pos, @NotNull class_3726 context) {
        if (state.method_27852((class_2248)this)) {
            return switch ((EndBlockProperties.PedestalState)((Object)state.method_11654(STATE))) {
                case EndBlockProperties.PedestalState.BOTTOM -> SHAPE_BOTTOM;
                case EndBlockProperties.PedestalState.PEDESTAL_TOP -> SHAPE_PEDESTAL_TOP;
                case EndBlockProperties.PedestalState.COLUMN_TOP -> SHAPE_COLUMN_TOP;
                case EndBlockProperties.PedestalState.PILLAR -> SHAPE_PILLAR;
                case EndBlockProperties.PedestalState.COLUMN -> SHAPE_COLUMN;
                default -> SHAPE_DEFAULT;
            };
        }
        return super.method_9530(state, world, pos, context);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
        stateManager.method_11667(new class_2769[]{STATE, HAS_ITEM, HAS_LIGHT});
    }

    public class_2586 method_10123(@NotNull class_2338 blockPos, @NotNull class_2680 blockState) {
        return new PedestalBlockEntity(blockPos, blockState);
    }

    public boolean hasUniqueEntity() {
        return false;
    }

    public boolean method_9498(class_2680 state) {
        return state.method_26204() instanceof PedestalBlock;
    }

    public int method_9572(class_2680 state, @NotNull class_1937 world, @NotNull class_2338 pos) {
        return (Boolean)state.method_11654((class_2769)HAS_ITEM) != false ? 15 : 0;
    }

    @Environment(value=EnvType.CLIENT)
    public void provideBlockModels(WoverBlockModelGenerators generator) {
        PedestalBlock.provideBlockModel(generator, this.createTextureMapping(), (class_2248)this);
    }

    @Environment(value=EnvType.CLIENT)
    public static void provideBlockModel(WoverBlockModelGenerators generator, class_4944 mapping, class_2248 pedestalBlock) {
        PedestalBlock.provideBlockModel(generator, mapping, pedestalBlock, PEDESTAL_MODELS);
    }

    @Environment(value=EnvType.CLIENT)
    public static void provideBlockModel(WoverBlockModelGenerators generator, class_4944 mapping, class_2248 pedestalBlock, Map<EndBlockProperties.PedestalState, class_4942> pdestalModels) {
        class_2960 id = class_4944.method_25860((class_2248)pedestalBlock);
        class_4926.class_4927 properties = class_4926.method_25783(STATE);
        for (Map.Entry<EndBlockProperties.PedestalState, class_4942> entry : pdestalModels.entrySet()) {
            String suffix = "_" + String.valueOf((Object)entry.getKey());
            class_2960 model = entry.getValue().method_25847(pedestalBlock, suffix, mapping, generator.modelOutput());
            properties.method_25793((Comparable)((Object)entry.getKey()), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model));
        }
        generator.acceptBlockState((class_4917)class_4925.method_25769((class_2248)pedestalBlock).method_25775((class_4926)properties));
        generator.delegateItemModel(pedestalBlock, id.method_48331("_default"));
    }

    @Environment(value=EnvType.CLIENT)
    protected class_4944 createTextureMapping() {
        class_2960 parentTexture = class_4944.method_25860((class_2248)this.parent);
        return new class_4944().method_25868(class_4945.field_23015, parentTexture.method_48331("_top")).method_25868(class_4945.field_23014, parentTexture.method_48331("_bottom")).method_25868(EndModels.BASE, parentTexture.method_48331("_base")).method_25868(EndModels.PILLAR, parentTexture.method_48331("_pillar"));
    }

    public void registerBlockTags(class_2960 location, TagBootstrapContext<class_2248> context) {
        context.add(EndTags.PEDESTALS, (Object[])new class_2248[]{this});
    }

    static {
        PEDESTAL_MODELS = Map.of(EndBlockProperties.PedestalState.DEFAULT, EndModels.PEDESTAL_DEFAULT, EndBlockProperties.PedestalState.PEDESTAL_TOP, EndModels.PEDESTAL_TOP, EndBlockProperties.PedestalState.COLUMN_TOP, EndModels.PEDESTAL_COLUMN_TOP, EndBlockProperties.PedestalState.COLUMN, EndModels.PEDESTAL_COLUMN, EndBlockProperties.PedestalState.BOTTOM, EndModels.PEDESTAL_BOTTOM, EndBlockProperties.PedestalState.PILLAR, EndModels.PEDESTAL_PILLAR);
        class_265 basinUp = class_2248.method_9541((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
        class_265 basinDown = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
        class_265 columnTopUp = class_2248.method_9541((double)1.0, (double)14.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
        class_265 columnTopDown = class_2248.method_9541((double)2.0, (double)13.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
        class_265 pedestalTop = class_2248.method_9541((double)1.0, (double)8.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0);
        class_265 pedestalDefault = class_2248.method_9541((double)1.0, (double)12.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
        class_265 pillar = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
        class_265 pillarDefault = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0);
        class_265 columnTop = class_259.method_1084((class_265)columnTopDown, (class_265)columnTopUp);
        class_265 basin = class_259.method_1084((class_265)basinDown, (class_265)basinUp);
        SHAPE_PILLAR = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
        SHAPE_DEFAULT = class_259.method_17786((class_265)basin, (class_265[])new class_265[]{pillarDefault, pedestalDefault});
        SHAPE_PEDESTAL_TOP = class_259.method_1084((class_265)pillar, (class_265)pedestalTop);
        SHAPE_COLUMN_TOP = class_259.method_1084((class_265)SHAPE_PILLAR, (class_265)columnTop);
        SHAPE_COLUMN = class_259.method_17786((class_265)basin, (class_265[])new class_265[]{SHAPE_PILLAR, columnTop});
        SHAPE_BOTTOM = class_259.method_1084((class_265)basin, (class_265)SHAPE_PILLAR);
    }
}

