/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import java.util.Iterator;
import java.util.LinkedList;
import org.betterx.betterend.blocks.Edge;
import org.betterx.betterend.blocks.Node;
import org.jetbrains.annotations.NotNull;

class Graph<T>
implements Iterable<Node<T>> {
    private final LinkedList<Node<T>> nodes = new LinkedList();

    public Node<T> add(T payload) {
        Node<T> node = new Node<T>(payload);
        this.nodes.add(node);
        return node;
    }

    public Edge<T> addEdge(T n1, T n2) {
        return this.addEdge(n1, n2, 1.0);
    }

    public Edge<T> addEdge(T n1, T n2, double weight) {
        Node<T> source = this.getForPayload(n1);
        Node<T> target = this.getForPayload(n2);
        if (source != null && target != null) {
            return source.addEdge(target, weight);
        }
        return null;
    }

    public Edge<T> addEdge(Node<T> source, Node<T> target) {
        return this.addEdge(source, target, 1.0);
    }

    public Edge<T> addEdge(Node<T> source, Node<T> target, double weight) {
        if (source != null && target != null) {
            return source.addEdge(target, weight);
        }
        return null;
    }

    public Node<T> getForPayload(T payload) {
        return this.nodes.stream().filter(n -> n.getPayload().equals(payload)).findFirst().orElse(null);
    }

    @Override
    @NotNull
    public Iterator<Node<T>> iterator() {
        return this.nodes.iterator();
    }
}

