/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.complexmaterials.entry;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_8790;
import org.betterx.bclib.complexmaterials.ComplexMaterial;
import org.betterx.bclib.complexmaterials.entry.BlockEntry;
import org.betterx.bclib.complexmaterials.entry.ItemEntry;
import org.betterx.bclib.complexmaterials.entry.MaterialSlot;
import org.betterx.bclib.complexmaterials.entry.RecipeEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleMaterialSlot<M extends ComplexMaterial>
extends MaterialSlot<M> {
    public SimpleMaterialSlot(@NotNull String suffix) {
        super(suffix);
    }

    @Override
    public void addBlockEntry(M parentMaterial, Consumer<BlockEntry> adder) {
        adder.accept(this.getBlockEntry(parentMaterial));
    }

    @Nullable
    protected BlockEntry getBlockEntry(M parentMaterial) {
        BlockEntry entry = new BlockEntry(this.suffix, (c, p) -> this.createBlock(parentMaterial, (class_4970.class_2251)p));
        this.modifyBlockEntry(parentMaterial, entry);
        return entry;
    }

    @NotNull
    protected abstract class_2248 createBlock(M var1, class_4970.class_2251 var2);

    protected void modifyBlockEntry(M parentMaterial, @NotNull BlockEntry entry) {
    }

    @Override
    public void addRecipeEntry(M parentMaterial, Consumer<RecipeEntry> adder) {
        adder.accept(this.getRecipeEntry(parentMaterial));
    }

    @Nullable
    protected RecipeEntry getRecipeEntry(M parentMaterial) {
        return new RecipeEntry(this.suffix, (context, parentMaterial1, id) -> this.makeRecipe((class_8790)context, (ComplexMaterial)parentMaterial1, (class_2960)id));
    }

    @Nullable
    protected abstract void makeRecipe(class_8790 var1, ComplexMaterial var2, class_2960 var3);

    @Override
    public void addItemEntry(M parentMaterial, Consumer<ItemEntry> adder) {
        ItemEntry item = this.getItemEntry(parentMaterial);
        if (item != null) {
            adder.accept(item);
        }
    }

    @Nullable
    protected ItemEntry getItemEntry(M parentMaterial) {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleMaterialSlot)) {
            return false;
        }
        SimpleMaterialSlot that = (SimpleMaterialSlot)o;
        return this.suffix.equals(that.suffix);
    }

    public int hashCode() {
        return Objects.hash(this.suffix);
    }

    public static <M extends ComplexMaterial> SimpleMaterialSlot<M> createBlockItem(@NotNull String suffix, final BiFunction<ComplexMaterial, class_4970.class_2251, class_2248> maker) {
        return new SimpleMaterialSlot(suffix){

            @NotNull
            protected class_2248 createBlock(ComplexMaterial parentMaterial, class_4970.class_2251 settings) {
                return (class_2248)maker.apply(parentMaterial, settings);
            }

            @Override
            @Nullable
            protected void makeRecipe(class_8790 context, ComplexMaterial parentMaterial, class_2960 id) {
            }
        };
    }

    public static <M extends ComplexMaterial> SimpleMaterialSlot<M> createBlockItem(@NotNull String suffix, final Supplier<class_2248> maker) {
        return new SimpleMaterialSlot(suffix){

            @NotNull
            protected class_2248 createBlock(ComplexMaterial parentMaterial, class_4970.class_2251 settings) {
                return (class_2248)maker.get();
            }

            @Override
            @Nullable
            protected void makeRecipe(class_8790 context, ComplexMaterial parentMaterial, class_2960 id) {
            }
        };
    }
}

