/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import de.ambertation.wunderlib.math.Bounds;
import de.ambertation.wunderlib.math.Float3;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2232;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2247;
import net.minecraft.class_2248;
import net.minecraft.class_2257;
import net.minecraft.class_2259;
import net.minecraft.class_2262;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2404;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2742;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3748;
import net.minecraft.class_3751;
import net.minecraft.class_5000;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7066;
import net.minecraft.class_7079;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.betterx.bclib.api.v2.levelgen.structures.StructureNBT;
import org.betterx.bclib.commands.PlaceCommand;
import org.betterx.bclib.commands.arguments.ConnectorArgument;
import org.betterx.bclib.commands.arguments.Float3ArgumentType;
import org.betterx.bclib.commands.arguments.PlacementDirections;
import org.betterx.bclib.commands.arguments.TemplatePlacementArgument;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.wover.state.api.WorldState;

class PlaceCommandBuilder {
    public static final String PATH = "path";
    public static final String NBT = "nbt";
    public static final String EMPTY = "empty";
    public static final String PLACEMENT = "placement";
    public static final String POS = "pos";
    public static final String RECURSION_DEPTH = "recursion_depth";
    public static final String SPAN = "span";
    public static final String BORDER = "border";
    public static final String ADD_CONTROLL_BLOCKS = "controller";
    public static final String FILL_VOID = "replaceair";
    public static final String JIGSAW = "jigsaw";
    public static final String CONNECTOR_NAME = "connector_name";
    public static final String REPLACE_WITH = "replace_with";
    public static final String ROLLABLE = "rollable";
    public static final String REPLACE_FROM_WORLD = "fromWorld";
    public static final String BLOCKS = "blocks";
    private static final DynamicCommandExceptionType ERROR_PLACE_TAG_INVALID = new DynamicCommandExceptionType(object -> class_2561.method_54159((String)"commands.place.tag.invalid", (Object[])new Object[]{object}));

    PlaceCommandBuilder() {
    }

    public void register(class_7157 ctx, LiteralArgumentBuilder<class_2168> command) {
        Supplier<RequiredArgumentBuilder> path = () -> class_2170.method_9244((String)PATH, (ArgumentType)class_2232.method_9441());
        Supplier<RequiredArgumentBuilder> placement = () -> class_2170.method_9244((String)PLACEMENT, (ArgumentType)TemplatePlacementArgument.templatePlacement());
        Supplier<RequiredArgumentBuilder> pos = () -> class_2170.method_9244((String)POS, (ArgumentType)class_2262.method_9698());
        Supplier<RequiredArgumentBuilder> recursionDepth = () -> class_2170.method_9244((String)RECURSION_DEPTH, (ArgumentType)IntegerArgumentType.integer((int)0, (int)16));
        Function<Boolean, RequiredArgumentBuilder> placeIt = hasRecursionArg -> (RequiredArgumentBuilder)((RequiredArgumentBuilder)placement.get()).then(this.addOptionalsAndExecute(ctx, (RequiredArgumentBuilder)((RequiredArgumentBuilder)pos.get()), (boolean)hasRecursionArg, PlaceCommandBuilder::placeNBT));
        LiteralArgumentBuilder nbtTree = (LiteralArgumentBuilder)class_2170.method_9247((String)NBT).then(((RequiredArgumentBuilder)path.get().then(recursionDepth.get().then((ArgumentBuilder)placeIt.apply(true)))).then((ArgumentBuilder)placeIt.apply(false)));
        LiteralArgumentBuilder emptyTree = (LiteralArgumentBuilder)class_2170.method_9247((String)EMPTY).then(path.get().then(placement.get().then(pos.get().then(this.addOptionalsAndExecute(ctx, class_2170.method_9244((String)SPAN, (ArgumentType)Float3ArgumentType.int3(0, 64)), false, PlaceCommandBuilder::placeEmpty)))));
        Supplier<RequiredArgumentBuilder> replace = () -> class_2170.method_9244((String)REPLACE_WITH, (ArgumentType)class_2257.method_9653((class_7157)ctx));
        Supplier<LiteralArgumentBuilder> replace_source = () -> class_2170.method_9247((String)REPLACE_FROM_WORLD);
        Supplier<LiteralArgumentBuilder> rotate = () -> class_2170.method_9247((String)ROLLABLE);
        LiteralArgumentBuilder jigsawTree = (LiteralArgumentBuilder)class_2170.method_9247((String)JIGSAW).then(class_2170.method_9244((String)"pool", (ArgumentType)class_7079.method_41224((class_5321)class_7924.field_41249)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)CONNECTOR_NAME, (ArgumentType)ConnectorArgument.id()).then(((RequiredArgumentBuilder)replace.get().then(rotate.get().then(pos.get().executes(cc -> PlaceCommandBuilder.placeJigsaw((CommandContext<class_2168>)cc, true, true, false))))).then(pos.get().executes(cc -> PlaceCommandBuilder.placeJigsaw((CommandContext<class_2168>)cc, true, false, false))))).then(((LiteralArgumentBuilder)replace_source.get().then(rotate.get().then(pos.get().executes(cc -> PlaceCommandBuilder.placeJigsaw((CommandContext<class_2168>)cc, false, true, true))))).then(pos.get().executes(cc -> PlaceCommandBuilder.placeJigsaw((CommandContext<class_2168>)cc, false, false, true))))).then(rotate.get().then(pos.get().executes(cc -> PlaceCommandBuilder.placeJigsaw((CommandContext<class_2168>)cc, false, true, false))))).then(pos.get().executes(cc -> PlaceCommandBuilder.placeJigsaw((CommandContext<class_2168>)cc, false, false, false)))));
        LiteralArgumentBuilder blocksTree = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)BLOCKS).then(class_2170.method_9247((String)"location").then(class_2170.method_9244((String)"namespace", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)PATH, (ArgumentType)StringArgumentType.string()).then(pos.get().executes(this::placeBlocksMatchingLocation)))))).then(class_2170.method_9247((String)"tag").then(class_2170.method_9244((String)"blocktag", (ArgumentType)class_7066.method_41170((class_5321)class_7924.field_41254)).then(pos.get().executes(this::placeBlocksMatchingTag))));
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)command.then((ArgumentBuilder)nbtTree)).then((ArgumentBuilder)emptyTree)).then((ArgumentBuilder)jigsawTree)).then((ArgumentBuilder)blocksTree);
    }

    private int placeBlocksMatchingLocation(CommandContext<class_2168> cc) {
        String namespace = StringArgumentType.getString(cc, (String)"namespace");
        String path = StringArgumentType.getString(cc, (String)PATH);
        return this.placeMatchingBlocks(cc, blocks -> blocks.method_40270().filter(holder -> {
            Optional okey = holder.method_40230();
            if (okey.isPresent()) {
                class_2960 key = ((class_5321)okey.get()).method_29177();
                return !(!namespace.trim().equals("*") && !key.method_12836().contains(namespace) || !path.trim().equals("*") && !key.method_12832().contains(path));
            }
            return false;
        }).map(h -> h));
    }

    private int placeBlocksMatchingTag(CommandContext<class_2168> cc) {
        try {
            class_7066.class_7068 tagResult = class_7066.method_41166(cc, (String)"blocktag", (class_5321)class_7924.field_41254, (DynamicCommandExceptionType)ERROR_PLACE_TAG_INVALID);
            class_6862 tag = tagResult.method_41173().right().orElse(null);
            if (tag == null) {
                return -1;
            }
            return this.placeMatchingBlocks(cc, blocks -> {
                LinkedList<class_6880> blockHolders = new LinkedList<class_6880>();
                for (class_6880 bl : blocks.method_40286(tag)) {
                    blockHolders.add(bl);
                }
                return blockHolders.stream();
            });
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private int placeMatchingBlocks(CommandContext<class_2168> cc, Function<class_2378<class_2248>, Stream<class_6880<class_2248>>> blockSupplier) {
        try {
            class_2338 pos = class_2262.method_9696(cc, (String)POS);
            int LENGTH = 16;
            int HEIGHT = 16;
            class_2378 blocks = WorldState.registryAccess().method_33310(class_7924.field_41254).orElse(null);
            LinkedList blockHolders = new LinkedList();
            blockSupplier.apply((class_2378<class_2248>)blocks).forEach(blockHolders::add);
            class_3218 world = ((class_2168)cc.getSource()).method_9225();
            class_3222 player = ((class_2168)cc.getSource()).method_9207();
            if (blocks == null) {
                return -1;
            }
            int x = pos.method_10263();
            int y = pos.method_10264();
            int z = pos.method_10260();
            for (class_6880 entry : blockHolders) {
                class_2960 key = ((class_5321)entry.method_40230().orElseThrow()).method_29177();
                class_2248 block = (class_2248)entry.comp_349();
                class_2338 test = new class_2338(x, y, z);
                while (!world.method_22347(test)) {
                    if (++x - pos.method_10263() > 16) {
                        x = pos.method_10263();
                        if (++y - pos.method_10264() > 16) {
                            y = pos.method_10264();
                            z += 4;
                        }
                    }
                    test = new class_2338(x, y, z);
                }
                PlaceCommandBuilder.place(world, player, block, block.method_9564(), test);
            }
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
        return 0;
    }

    private static void place(class_3218 world, class_3222 player, class_2248 bl, class_2680 state, class_2338 blockPos) {
        if (!(bl instanceof class_2404)) {
            if (bl instanceof class_2323) {
                BlocksHelper.setWithoutUpdate((class_1936)world, blockPos, (class_2680)state.method_11657((class_2769)class_2323.field_10946, (Comparable)class_2756.field_12607));
                BlocksHelper.setWithoutUpdate((class_1936)world, blockPos.method_10084(), (class_2680)state.method_11657((class_2769)class_2323.field_10946, (Comparable)class_2756.field_12609));
            } else if (bl instanceof class_2244) {
                BlocksHelper.setWithoutUpdate((class_1936)world, blockPos, (class_2680)state.method_11657((class_2769)class_2244.field_9967, (Comparable)class_2742.field_12557));
                BlocksHelper.setWithoutUpdate((class_1936)world, blockPos.method_10093((class_2350)state.method_11654((class_2769)class_2244.field_11177)), (class_2680)state.method_11657((class_2769)class_2244.field_9967, (Comparable)class_2742.field_12560));
            } else {
                BlocksHelper.setWithoutUpdate((class_1936)world, blockPos, state);
            }
        }
    }

    private <T> RequiredArgumentBuilder<class_2168, T> addOptionalsAndExecute(class_7157 commandBuildContext, RequiredArgumentBuilder<class_2168, T> root, boolean hasRecursionArgs, Executor runner) {
        Supplier<LiteralArgumentBuilder> addControllers = () -> class_2170.method_9247((String)ADD_CONTROLL_BLOCKS);
        Supplier<LiteralArgumentBuilder> replaceAir = () -> class_2170.method_9247((String)FILL_VOID);
        Supplier<RequiredArgumentBuilder> addBorder = () -> class_2170.method_9244((String)BORDER, (ArgumentType)class_2257.method_9653((class_7157)commandBuildContext));
        return (RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)root.executes(c -> runner.exec((CommandContext<class_2168>)c, false, false, false, hasRecursionArgs))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)addBorder.get().executes(c -> runner.exec((CommandContext<class_2168>)c, true, false, false, hasRecursionArgs))).then(addControllers.get().executes(c -> runner.exec((CommandContext<class_2168>)c, true, true, false, hasRecursionArgs)))).then(addControllers.get().then(replaceAir.get().executes(c -> runner.exec((CommandContext<class_2168>)c, true, true, true, hasRecursionArgs)))))).then(addControllers.get().executes(c -> runner.exec((CommandContext<class_2168>)c, false, true, false, hasRecursionArgs)))).then(addControllers.get().then(replaceAir.get().executes(c -> runner.exec((CommandContext<class_2168>)c, false, true, true, hasRecursionArgs))));
    }

    protected static int placeNBT(CommandContext<class_2168> ctx, boolean hasBorderArg, boolean controlBlocks, boolean replaceAir, boolean hasRecursionArg) throws CommandSyntaxException {
        class_2960 id = class_2232.method_9443(ctx, (String)PATH);
        PlacementDirections searchDir = TemplatePlacementArgument.getPlacement(ctx, PLACEMENT);
        class_2247 blockInput = hasBorderArg ? class_2257.method_9655(ctx, (String)BORDER) : null;
        class_2338 pos = class_2262.method_9696(ctx, (String)POS);
        int recursionDepth = hasRecursionArg ? IntegerArgumentType.getInteger(ctx, (String)RECURSION_DEPTH) : 1;
        List<StructureNBT> structures = StructureNBT.createResourcesFrom(id, recursionDepth);
        if (structures != null) {
            Bounds b = Bounds.of((class_2338)pos);
            Bounds all = Bounds.of((class_2338)pos);
            class_2338 pNew = pos;
            class_2338 rowStart = pos;
            String lastPrefix = null;
            for (StructureNBT s : structures) {
                String prefix;
                String string = prefix = s.location.method_12832().contains("/") ? s.location.method_12832().replaceAll("/[^/]*$", "") : "";
                if (lastPrefix != null && !lastPrefix.equals(prefix)) {
                    rowStart = pNew = searchDir.resetStart(b, pNew, 10);
                    b = Bounds.of((class_2338)pNew);
                }
                lastPrefix = prefix;
                Bounds bb = Bounds.of((class_3341)Objects.requireNonNull(PlaceCommand.placeBlocks((class_2168)ctx.getSource(), rowStart, searchDir.getOffset(), blockInput, controlBlocks, replaceAir, true, s.location, p -> s.getBoundingBox((class_2338)p, class_2470.field_11467, class_2415.field_11302), (level, p) -> s.generateAt((class_5425)level, (class_2338)p, class_2470.field_11467, class_2415.field_11302))));
                rowStart = searchDir.advanceStart(bb, rowStart);
                b = b.encapsulate(bb);
                all = all.encapsulate(bb);
                if (searchDir.sizeInDirection(b) <= 160) continue;
                rowStart = pNew = searchDir.resetStart(b, pNew);
                b = Bounds.of((class_2338)pNew);
            }
            Bounds finalAll = all;
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Placed " + structures.size() + " NBTs: " + finalAll.toString())).method_10862(class_2583.field_24360.method_10977(class_124.field_1076)), true);
            return 0;
        }
        StructureNBT structureNBT = StructureNBT.create(id);
        return PlaceCommand.placeBlocks((class_2168)ctx.getSource(), pos, searchDir.getOffset(), blockInput, controlBlocks, replaceAir, true, structureNBT.location, p -> structureNBT.getBoundingBox((class_2338)p, class_2470.field_11467, class_2415.field_11302), (level, p) -> structureNBT.generateAt((class_5425)level, (class_2338)p, class_2470.field_11467, class_2415.field_11302)) == null ? 1 : -1;
    }

    protected static int placeEmpty(CommandContext<class_2168> ctx, boolean hasBorderArg, boolean controlBlocks, boolean replaceAir, boolean hasRecursionArg) throws CommandSyntaxException {
        class_2960 id = class_2232.method_9443(ctx, (String)PATH);
        PlacementDirections searchDir = TemplatePlacementArgument.getPlacement(ctx, PLACEMENT);
        class_2247 blockInput = hasBorderArg ? class_2257.method_9655(ctx, (String)BORDER) : null;
        class_2338 span = Float3ArgumentType.getFloat3(ctx, SPAN).toBlockPos();
        return PlaceCommand.placeBlocks((class_2168)ctx.getSource(), class_2262.method_9696(ctx, (String)POS), searchDir == null || searchDir.dir == Float3.ZERO ? null : searchDir.dir.toBlockPos(), blockInput, controlBlocks, replaceAir, false, id, p -> class_3341.method_34390((class_2382)p, (class_2382)p.method_10081((class_2382)span)), (level, p) -> {
            class_3341 box = class_3341.method_34390((class_2382)p, (class_2382)p.method_10081((class_2382)span));
            PlaceCommand.fillStructureVoid((class_1937)level, box);
            if (blockInput != null) {
                PlaceCommand.fill((class_1937)level, new class_3341(box.method_35415(), box.method_35416() - 1, box.method_35417(), box.method_35418(), box.method_35416() - 1, box.method_35420()), blockInput.method_9494());
            }
        }) == null ? 1 : -1;
    }

    public static int placeJigsaw(CommandContext<class_2168> ctx, boolean hasReplaceArg, boolean rotate, boolean replaceFromWorld) throws CommandSyntaxException {
        class_2338 pos = class_2262.method_9696(ctx, (String)POS);
        class_6880.class_6883 pool = class_7079.method_43780(ctx, (String)"pool");
        class_2960 connector = class_2232.method_9443(ctx, (String)CONNECTOR_NAME);
        if (connector.method_12836().equals("-")) {
            connector = class_2960.method_60655((String)pool.method_40237().method_29177().method_12836(), (String)connector.method_12832());
        }
        class_2680 replaceWith = hasReplaceArg ? class_2257.method_9655(ctx, (String)REPLACE_WITH).method_9494() : class_2246.field_10124.method_9564();
        class_3218 level = ((class_2168)ctx.getSource()).method_9225();
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        int deltaY = player.method_31478() - pos.method_10264();
        class_2680 state = class_2246.field_16540.method_9564();
        state = deltaY < 2 && deltaY > -2 && !rotate ? (class_2680)state.method_11657((class_2769)class_3748.field_23262, (Comparable)class_5000.method_26425((class_2350)player.method_5735().method_10153(), (class_2350)class_2350.field_11036)) : (deltaY < 0 ? (class_2680)state.method_11657((class_2769)class_3748.field_23262, (Comparable)class_5000.method_26425((class_2350)class_2350.field_11033, (class_2350)player.method_5735().method_10153())) : (class_2680)state.method_11657((class_2769)class_3748.field_23262, (Comparable)class_5000.method_26425((class_2350)class_2350.field_11036, (class_2350)player.method_5735().method_10153())));
        if (replaceFromWorld) {
            replaceWith = level.method_8320(pos);
        }
        level.method_8652(pos, state, 18);
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof class_3751) {
            class_3751 entity = (class_3751)class_25862;
            entity.method_16379(connector);
            entity.method_16378(connector);
            entity.method_26398(pool.method_40237());
            entity.method_16377(class_2259.method_9685((class_2680)replaceWith));
            if (rotate) {
                entity.method_26396(class_3751.class_4991.field_23329);
            } else {
                entity.method_26396(class_3751.class_4991.field_23330);
            }
        }
        return 1;
    }

    public static int placeSpawner(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2338 pos = class_2262.method_9696(ctx, (String)POS);
        class_3218 level = ((class_2168)ctx.getSource()).method_9225();
        level.method_8652(pos, class_2246.field_10260.method_9564(), 18);
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof class_2636) {
            class_2636 entity = (class_2636)class_25862;
            class_2487 tag = class_2522.method_10718((String)"{SpawnData:{entity:{id:wither_skeleton,PersistenceRequired:1,HandItems:[{Count:1,id:netherite_sword},{Count:1,id:shield}],ArmorItems:[{Count:1,id:netherite_boots,tag:{Enchantments:[{id:protection,lvl:1}]}},{Count:1,id:netherite_leggings,tag:{Enchantments:[{id:protection,lvl:1}]}},{Count:1,id:netherite_chestplate,tag:{Enchantments:[{id:protection,lvl:1},{id:thorns,lvl:3}]}},{Count:1,id:netherite_helmet,tag:{Enchantments:[{id:protection,lvl:1}]}}],HandDropChances:[0.0f,0.0f],ArmorDropChances:[0.0f,0.0f,0.0f,0.0f]}, custom_spawn_rules:{sky_light_limit:{max_inclusive:13},block_light_limit:{max_inclusive:11}}},SpawnRange:4,SpawnCount:8,MaxNearbyEntities:18,Delay:499,MinSpawnDelay:300,MaxSpawnDelay:1600,RequiredPlayerRange:20}");
            entity.method_58691(tag, (class_7225.class_7874)((class_2168)ctx.getSource()).method_30497());
        }
        return 1;
    }

    static interface Executor {
        public int exec(CommandContext<class_2168> var1, boolean var2, boolean var3, boolean var4, boolean var5) throws CommandSyntaxException;
    }
}

