/*
 * Decompiled with CFR 0.152.
 */
package mod.linguardium.badgebox.common.screen;

import java.util.function.Supplier;
import mod.linguardium.badgebox.common.registration.ModScreenHandlerTypes;
import mod.linguardium.badgebox.common.screen.slot.LockPredicateSlot;
import mod.linguardium.badgebox.common.screen.slot.TagLimitedSlot;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3545;
import net.minecraft.class_3917;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class BadgeBoxContainerScreenHandler
extends class_1703 {
    private final class_1263 inventory;
    public static final int INVENTORY_COLUMNS = 4;
    public static final int INVENTORY_ROWS = 2;
    private static final int PLAYER_INVENTORY_COLUMNS = 9;
    private final int playerInventoryRows = (36 - class_1661.method_7368()) / 9;
    private final class_1661 playerInventory;
    final int boxSlot;
    boolean hasRibbonSlot;

    public static int getInventorySlotCount() {
        return 8;
    }

    public BadgeBoxContainerScreenHandler(int syncId, class_1661 playerInventory, class_1263 inventory, boolean hasRibbonSlotStack, int boxSlot) {
        super((class_3917)ModScreenHandlerTypes.BADGE_BOX_SCREEN_HANDLER_TYPE.get(), syncId);
        this.inventory = inventory;
        this.playerInventory = playerInventory;
        this.boxSlot = boxSlot;
        this.hasRibbonSlot = hasRibbonSlotStack;
        this.addBadgeSlots();
        this.addPlayerHotbarSlots();
        this.addPlayerInventorySlots();
    }

    public static BadgeBoxContainerScreenHandler create(int syncId, class_1661 playerInventory, class_2540 buf) {
        ExtendedScreenHandlerData data = (ExtendedScreenHandlerData)ExtendedScreenHandlerData.PACKET_CODEC.decode((Object)buf);
        return new BadgeBoxContainerScreenHandler(syncId, playerInventory, data);
    }

    public BadgeBoxContainerScreenHandler(int syncId, class_1661 playerInventory, ExtendedScreenHandlerData data) {
        this(syncId, playerInventory, BadgeBoxContainerScreenHandler.createClientsideInventory(data), data.ribbon, data.boxSlot());
    }

    private static class_1263 createClientsideInventory(ExtendedScreenHandlerData data) {
        int slots = 8;
        if (data.ribbon()) {
            ++slots;
        }
        return new class_1277(slots);
    }

    private boolean isBoxSlot(Integer index) {
        return this.boxSlot == index;
    }

    private void addBadgeSlots() {
        int offset = 0;
        int ribbonOffsetX = 29;
        int ribbonOffsetY = 9;
        if (this.hasRibbonSlot()) {
            offset = -13;
        }
        for (int y = 0; y < 2; ++y) {
            for (int x = 0; x < 4; ++x) {
                this.method_7621(TagLimitedSlot.badge(this.inventory, x + y * 4, offset + 57 + x * 18, 28 + y * 18));
            }
        }
        if (this.hasRibbonSlot()) {
            this.method_7621(TagLimitedSlot.ribbon(this.inventory, this.inventory.method_5439() - 1, ribbonOffsetX + 93, ribbonOffsetY + 28));
        }
    }

    private void addPlayerInventorySlots() {
        int hotbarSize = class_1661.method_7368();
        for (int y = 0; y < this.playerInventoryRows; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.method_7621(new LockPredicateSlot((class_1263)this.playerInventory, hotbarSize + x + y * 9, 12 + x * 18, 84 + y * 18, this::isBoxSlot));
            }
        }
    }

    private void addPlayerHotbarSlots() {
        for (int x = 0; x < class_1661.method_7368(); ++x) {
            this.method_7621(new LockPredicateSlot((class_1263)this.playerInventory, x, 12 + x * 18, 142, this::isBoxSlot));
        }
    }

    private int getInventorySlots() {
        return this.inventory.method_5439();
    }

    public boolean method_7613(class_1799 stack, class_1735 slot) {
        return super.method_7613(stack, slot) && slot.method_7680(stack);
    }

    public boolean method_7597(class_1657 player) {
        return this.inventory.method_5443(player);
    }

    private boolean isBadgeSlot(int slotIndex) {
        return slotIndex < this.getInventorySlots();
    }

    private boolean isHotbarSlot(int slotIndex) {
        int playerSlot = this.getPlayerSlotInventoryIndex(slotIndex);
        return class_1661.method_7380((int)playerSlot);
    }

    private class_3545<Integer, Integer> getPlayerMainSlotRange() {
        int start = this.getInventorySlots() + class_1661.method_7368();
        int end = this.field_7761.size();
        return new class_3545((Object)start, (Object)end);
    }

    private class_3545<Integer, Integer> getPlayerHotbarSlotRange() {
        int start = this.getInventorySlots();
        int end = start + class_1661.method_7368();
        return new class_3545((Object)start, (Object)end);
    }

    private class_3545<Integer, Integer> getInventorySlotRange() {
        return new class_3545((Object)0, (Object)this.getInventorySlots());
    }

    private boolean insertIntoBadgeSlots(class_1799 stack) {
        return this.insertIntoRange(stack, this::getInventorySlotRange);
    }

    private boolean insertIntoPlayerSlots(class_1799 stack) {
        return this.insertIntoRange(stack, this::getPlayerMainSlotRange);
    }

    private boolean insertIntoHotbarSlots(class_1799 stack) {
        return this.insertIntoRange(stack, this::getPlayerHotbarSlotRange);
    }

    private boolean insertIntoRange(class_1799 stack, Supplier<class_3545<Integer, Integer>> rangeProvider) {
        class_3545<Integer, Integer> range = rangeProvider.get();
        return this.method_7616(stack, (Integer)range.method_15442(), (Integer)range.method_15441(), false);
    }

    private boolean isValidScreenSlot(int slotIndex) {
        return slotIndex < this.field_7761.size() && slotIndex >= 0;
    }

    public class_1799 method_7601(class_1657 player, int slotIndex) {
        if (!this.method_40442(slotIndex)) {
            return class_1799.field_8037;
        }
        if (!this.isValidScreenSlot(slotIndex)) {
            return class_1799.field_8037;
        }
        class_1735 moveSlot = (class_1735)this.field_7761.get(slotIndex);
        if (!moveSlot.method_7681()) {
            return class_1799.field_8037;
        }
        class_1799 moveStack = moveSlot.method_7677();
        class_1799 returnStack = moveStack.method_7972();
        if (this.isBadgeSlot(slotIndex) ? !this.insertIntoHotbarSlots(moveStack) && !this.insertIntoPlayerSlots(moveStack) : (this.isHotbarSlot(slotIndex) ? !this.insertIntoBadgeSlots(moveStack) && !this.insertIntoPlayerSlots(moveStack) : !this.insertIntoBadgeSlots(moveStack) && !this.insertIntoHotbarSlots(moveStack))) {
            return class_1799.field_8037;
        }
        if (moveStack.method_7960()) {
            moveSlot.method_53512(class_1799.field_8037);
        } else {
            moveSlot.method_7668();
        }
        return returnStack;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.inventory.method_5432(player);
    }

    public class_1263 getInventory() {
        return this.inventory;
    }

    public boolean hasRibbonSlot() {
        return this.hasRibbonSlot;
    }

    private int getPlayerSlotInventoryIndex(int slotIndex) {
        int newIdx = slotIndex - this.getInventorySlots();
        if (newIdx < 0) {
            newIdx = -1;
        }
        return newIdx;
    }

    public record ExtendedScreenHandlerData(boolean ribbon, int boxSlot) {
        public static final class_9139<class_2540, ExtendedScreenHandlerData> PACKET_CODEC = class_9139.method_56435((class_9139)class_9135.field_48547, ExtendedScreenHandlerData::ribbon, (class_9139)class_9135.field_49675, ExtendedScreenHandlerData::boxSlot, ExtendedScreenHandlerData::new);
    }
}

