/*
 * Decompiled with CFR 0.152.
 */
package mod.linguardium.badgebox.common.item.components;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import mod.linguardium.badgebox.common.item.ComponentStorageInventory;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class BadgeInventoryComponent {
    public static final BadgeInventoryComponent EMPTY = new BadgeInventoryComponent((ImmutableList<class_1799>)ImmutableList.copyOf((Collection)class_2371.method_10213((int)8, (Object)class_1799.field_8037)), Optional.empty());
    public static final MapCodec<BadgeInventoryComponent> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("Size").forGetter(BadgeInventoryComponent::getSize), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)class_1799.field_24671).fieldOf("Items").forGetter(BadgeInventoryComponent::getNonEmptySlotMap), (App)Codec.BOOL.fieldOf("RibbonSlotEnabled").forGetter(BadgeInventoryComponent::hasRibbonSlot), (App)class_1799.field_24671.optionalFieldOf("RibbonSlot", (Object)class_1799.field_8037).forGetter(BadgeInventoryComponent::getRibbonSlot)).apply((Applicative)instance, BadgeInventoryComponent::decode));
    public static final class_9139<class_9129, BadgeInventoryComponent> PACKET_CODEC = class_9139.method_56905((class_9139)class_9135.field_49675, BadgeInventoryComponent::getSize, (class_9139)class_9135.method_56377(Maps::newHashMapWithExpectedSize, (class_9139)class_9135.field_48554, (class_9139)class_1799.field_48349), BadgeInventoryComponent::getNonEmptySlotMap, (class_9139)class_9135.field_48547, BadgeInventoryComponent::hasRibbonSlot, (class_9139)class_1799.field_49268, BadgeInventoryComponent::getRibbonSlot, BadgeInventoryComponent::decode);
    ImmutableList<class_1799> badgeInventory;
    Optional<class_1799> ribbonSlot;
    int hashCode = 0;

    private BadgeInventoryComponent(ImmutableList<class_1799> badgeInventory, Optional<class_1799> ribbonSlot) {
        this.badgeInventory = badgeInventory;
        this.ribbonSlot = ribbonSlot;
        this.hashCode = this.hashCode();
    }

    public ComponentStorageInventory asInventory(class_1799 stack) {
        return ComponentStorageInventory.fromBadgeInventoryComponent(stack, this);
    }

    public ImmutableList<class_1799> getItemStackList() {
        return this.badgeInventory;
    }

    public class_1799 get(int slot) {
        if (slot < this.badgeInventory.size() && slot >= 0) {
            return (class_1799)this.badgeInventory.get(slot);
        }
        return class_1799.field_8037;
    }

    public BadgeInventoryComponent setInventory(ImmutableList<class_1799> newStackList) {
        class_2371 newItemList = class_2371.method_10213((int)Math.max(newStackList.size(), this.badgeInventory.size()), (Object)class_1799.field_8037);
        for (int i = 0; i < newStackList.size(); ++i) {
            newItemList.set(i, (Object)((class_1799)newStackList.get(i)).method_7972());
        }
        return new BadgeInventoryComponent((ImmutableList<class_1799>)ImmutableList.copyOf((Collection)newItemList), this.ribbonSlot);
    }

    public BadgeInventoryComponent setRibbonSlot(Optional<class_1799> newRibbonSlot) {
        return new BadgeInventoryComponent(this.badgeInventory, newRibbonSlot);
    }

    public int getSize() {
        return this.badgeInventory.size();
    }

    public boolean hasRibbonSlot() {
        return this.ribbonSlot.isPresent();
    }

    public class_1799 getRibbonSlot() {
        return this.ribbonSlot.orElse(class_1799.field_8037);
    }

    private Map<String, class_1799> getNonEmptySlotMap() {
        HashMap<String, class_1799> map = new HashMap<String, class_1799>();
        for (int idx = 0; idx < this.badgeInventory.size(); ++idx) {
            class_1799 stack = (class_1799)this.badgeInventory.get(idx);
            if (stack.method_7960()) continue;
            map.put(String.valueOf(idx), stack);
        }
        return map;
    }

    public int hashCode() {
        int hashcode = class_1799.method_57361(this.badgeInventory);
        return this.ribbonSlot.map(Object::hashCode).map(hash -> hashcode * 31 + hash).orElse(hashcode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BadgeInventoryComponent) {
            BadgeInventoryComponent badgeInventoryComponent = (BadgeInventoryComponent)o;
            return badgeInventoryComponent.hashCode == this.hashCode;
        }
        return false;
    }

    private static BadgeInventoryComponent decode(int size, Map<String, class_1799> nonEmptySlotMap, Boolean ribbonSlotEnabled, class_1799 ribbonSlot) {
        class_2371 newItemList = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
        nonEmptySlotMap.forEach((key, value) -> newItemList.set(Integer.parseInt(key), value));
        Optional<class_1799> optionalRibbonSlot = Optional.empty();
        if (ribbonSlotEnabled.booleanValue()) {
            optionalRibbonSlot = Optional.of(ribbonSlot);
        }
        return new BadgeInventoryComponent((ImmutableList<class_1799>)ImmutableList.copyOf((Collection)newItemList), optionalRibbonSlot);
    }
}

