/*
 * Decompiled with CFR 0.152.
 */
package mod.linguardium.badgebox.common.item;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Optional;
import mod.linguardium.badgebox.common.item.components.BadgeInventoryComponent;
import mod.linguardium.badgebox.common.registration.ModDataComponentType;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_9331;
import org.jetbrains.annotations.NotNull;

public class ComponentStorageInventory
extends class_1277 {
    class_1799 holder;
    boolean hasRibbonSlot = false;
    int listSize;
    BadgeInventoryComponent backingComponent;

    private ComponentStorageInventory(class_1799 holder, int size, @NotNull BadgeInventoryComponent backingComponent) {
        super(size);
        this.holder = holder;
        this.backingComponent = backingComponent;
        this.listSize = this.backingComponent.getSize();
        for (int idx = 0; idx < this.listSize; ++idx) {
            this.method_54454().set(idx, (Object)this.backingComponent.get(idx));
        }
        this.hasRibbonSlot = this.backingComponent.hasRibbonSlot();
        if (this.backingComponent.hasRibbonSlot()) {
            this.method_54454().set(this.listSize, (Object)this.backingComponent.getRibbonSlot());
        }
    }

    public static ComponentStorageInventory fromBadgeInventoryComponent(class_1799 holder, @NotNull BadgeInventoryComponent backingComponent) {
        int size = backingComponent.getSize();
        if (backingComponent.hasRibbonSlot()) {
            ++size;
        }
        return new ComponentStorageInventory(holder, size, backingComponent);
    }

    public void saveInventory() {
        BadgeInventoryComponent component = this.backingComponent.setInventory((ImmutableList<class_1799>)ImmutableList.copyOf((Collection)this.method_54454()).subList(0, this.listSize));
        if (this.hasRibbonSlot) {
            component = component.setRibbonSlot(Optional.of((class_1799)this.method_54454().get(this.listSize)));
        }
        this.updateBackingStackComponent(component);
    }

    public void updateBackingStackComponent(BadgeInventoryComponent component) {
        this.holder.method_57379((class_9331)ModDataComponentType.BADGEBOX_INVENTORY_COMPONENT.get(), (Object)component);
        this.backingComponent = component;
    }

    public void method_5431() {
        super.method_5431();
        this.saveInventory();
    }

    public void method_5432(class_1657 player) {
        super.method_5432(player);
        this.saveInventory();
    }
}

