/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterfortresses.module;

import com.yungnickyoung.minecraft.betterfortresses.BetterFortressesCommon;
import com.yungnickyoung.minecraft.betterfortresses.config.BNFConfigFabric;
import com.yungnickyoung.minecraft.betterfortresses.world.ItemFrameChances;
import com.yungnickyoung.minecraft.yungsapi.io.JSON;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1269;

public class ConfigModuleFabric {
    public static final String CUSTOM_CONFIG_PATH = "betterfortresses";
    public static final String VERSION_PATH = "fabric-1_21";

    public static void init() {
        ConfigModuleFabric.initCustomFiles();
        AutoConfig.register(BNFConfigFabric.class, Toml4jConfigSerializer::new);
        AutoConfig.getConfigHolder(BNFConfigFabric.class).registerSaveListener(ConfigModuleFabric::bakeConfig);
        AutoConfig.getConfigHolder(BNFConfigFabric.class).registerLoadListener(ConfigModuleFabric::bakeConfig);
        ConfigModuleFabric.bakeConfig((BNFConfigFabric)AutoConfig.getConfigHolder(BNFConfigFabric.class).get());
        ServerLifecycleEvents.SERVER_STARTED.register(server -> ConfigModuleFabric.reloadJSON());
    }

    private static class_1269 bakeConfig(ConfigHolder<BNFConfigFabric> configHolder, BNFConfigFabric configFabric) {
        ConfigModuleFabric.bakeConfig(configFabric);
        ConfigModuleFabric.reloadJSON();
        return class_1269.field_5812;
    }

    private static void initCustomFiles() {
        ConfigModuleFabric.createDirectory();
        ConfigModuleFabric.createBaseReadMe();
        ConfigModuleFabric.createJsonReadMe();
        ConfigModuleFabric.reloadJSON();
    }

    private static void reloadJSON() {
        ConfigModuleFabric.loadItemFramesJSON();
    }

    private static void createDirectory() {
        File parentDir = new File(FabricLoader.getInstance().getConfigDir().toString(), CUSTOM_CONFIG_PATH);
        File customConfigDir = new File(parentDir, VERSION_PATH);
        try {
            String filePath = customConfigDir.getCanonicalPath();
            if (customConfigDir.mkdirs()) {
                BetterFortressesCommon.LOGGER.info("Creating directory for additional Better Nether Fortresses configuration at {}", (Object)filePath);
            }
        }
        catch (IOException e) {
            BetterFortressesCommon.LOGGER.error("ERROR creating Better Nether Fortresses config directory: {}", (Object)e.toString());
        }
    }

    private static void createBaseReadMe() {
        Path path = Paths.get(FabricLoader.getInstance().getConfigDir().toString(), CUSTOM_CONFIG_PATH, "README.txt");
        File readme = new File(path.toString());
        if (!readme.exists()) {
            String readmeText = "This directory is for a few additional options for YUNG's Better Nether Fortresses.\nOptions provided may vary by version.\nThis directory contains subdirectories for supported versions. The first time you run Better Nether Fortresses, a version subdirectory will be created if that version supports advanced options.\nFor example, the first time you use Better Nether Fortresses for MC 1.21 on Fabric, the 'fabric-1_21' subdirectory will be created in this folder.\nIf no subdirectory for your version is created, then that version probably does not support the additional options.\nNOTE -- Most of this mod's config settings can be found in a config file outside this folder!\nFor example, on Fabric 1.21 the file is 'betterfortresses-fabric-1_21.toml'.\nAlso note that many of the structure's settings such as spawn rate & spawn conditions can only be modified via data pack.";
            try {
                Files.write(path, readmeText.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                BetterFortressesCommon.LOGGER.error("Unable to create README file!");
            }
        }
    }

    private static void createJsonReadMe() {
        Path path = Paths.get(FabricLoader.getInstance().getConfigDir().toString(), CUSTOM_CONFIG_PATH, VERSION_PATH, "README.txt");
        File readme = new File(path.toString());
        if (!readme.exists()) {
            String readmeText = "######################################\n#          itemframes.json          #\n######################################\n  This file contains ItemRandomizers describing the probability distribution of items in item frames.\nItem frames only spawn in certain rooms and hallway pieces.\nFor information on ItemRandomizers, see the bottom of this README.\n######################################\n#         ItemRandomizers           #\n######################################\nDescribes a set of items and the probability of each item being chosen.\n - entries: An object where each entry's key is an item, and each value is that item's probability of being chosen.\n      The total sum of all probabilities SHOULD NOT exceed 1.0!\n - defaultItem: The item used for any leftover probability ranges.\n      For example, if the total sum of all the probabilities of the entries is 0.6, then\n      there is a 0.4 chance of the defaultItem being selected.\nHere's an example ItemRandomizer:\n{\n  \"entries\": {\n    \"minecraft:cobblestone\": 0.25,\n    \"minecraft:air\": 0.2,\n    \"minecraft:stone_sword\": 0.1\n  },\n  \"defaultItem\": \"minecraft:iron_axe\"\n}\nThis randomizer has a 25% chance of returning cobblestone, 20% chance of choosing air,\n10% chance of choosing a stone sword, and a 100 - (25 + 20 + 10) = 45% chance of choosing iron axe (since it's the default item).\n";
            try {
                Files.write(path, readmeText.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                BetterFortressesCommon.LOGGER.error("Unable to create item frames README file!");
            }
        }
    }

    private static void loadItemFramesJSON() {
        Path jsonPath = Paths.get(FabricLoader.getInstance().getConfigDir().toString(), CUSTOM_CONFIG_PATH, VERSION_PATH, "itemframes.json");
        File jsonFile = new File(jsonPath.toString());
        if (!jsonFile.exists()) {
            try {
                JSON.createJsonFileFromObject((Path)jsonPath, (Object)ItemFrameChances.get());
            }
            catch (IOException e) {
                BetterFortressesCommon.LOGGER.error("Unable to create itemframes.json file: {}", (Object)e.toString());
            }
        } else {
            if (!jsonFile.canRead()) {
                BetterFortressesCommon.LOGGER.error("Better Nether Fortresses itemframes.json file not readable! Using default configuration...");
                return;
            }
            try {
                ItemFrameChances.instance = (ItemFrameChances)JSON.loadObjectFromJsonFile((Path)jsonPath, ItemFrameChances.class);
            }
            catch (IOException e) {
                BetterFortressesCommon.LOGGER.error("Error loading Better Nether Fortresses itemframes.json file: {}", (Object)e.toString());
                BetterFortressesCommon.LOGGER.error("Using default configuration...");
            }
        }
    }

    private static void bakeConfig(BNFConfigFabric configFabric) {
        BetterFortressesCommon.CONFIG.general.disableVanillaFortresses = configFabric.general.disableVanillaFortresses;
    }
}

