/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.services;

import com.yungnickyoung.minecraft.yungsapi.YungsApiCommon;
import com.yungnickyoung.minecraft.yungsapi.api.autoregister.AutoRegister;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegisterField;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegisterFieldRouter;
import com.yungnickyoung.minecraft.yungsapi.module.BlockEntityTypeModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.module.BlockModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.module.CommandModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.module.CreativeModeTabModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.module.CriteriaModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.module.EntityDataSerializerModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.module.EntityTypeModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.module.FeatureModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.module.ItemModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.module.MobEffectModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.module.ParticleTypeModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.module.PlacementModifierTypeModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.module.PotionModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.module.SoundEventModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.module.StructurePieceTypeModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.module.StructurePlacementTypeModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.module.StructurePoolElementTypeModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.module.StructureProcessorTypeModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.module.StructureTypeModuleFabric;
import com.yungnickyoung.minecraft.yungsapi.services.IAutoRegisterHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.registry.CompostingChanceRegistry;
import net.fabricmc.fabric.api.registry.FabricBrewingRecipeRegistryBuilder;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

public class FabricAutoRegisterHelper
implements IAutoRegisterHelper {
    @Override
    public void collectAllAutoRegisterFieldsInPackage(String packageName) {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().forPackage(packageName, new ClassLoader[0]).filterInputsBy((Predicate)new FilterBuilder().includePackage(packageName)).setScanners(new Scanner[]{Scanners.TypesAnnotated}));
        Set annotatedClasses = reflections.getTypesAnnotatedWith(AutoRegister.class);
        annotatedClasses.forEach(clazz -> {
            String modId = clazz.getAnnotation(AutoRegister.class).value();
            Arrays.stream(clazz.getDeclaredFields()).filter(field -> field.isAnnotationPresent(AutoRegister.class)).forEach(field -> {
                Object o;
                field.setAccessible(true);
                String name = field.getAnnotation(AutoRegister.class).value();
                try {
                    o = field.get(null);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                class_2960 resourceLocation = class_2960.method_60655((String)modId, (String)name);
                AutoRegisterField autoRegisterField = new AutoRegisterField(o, resourceLocation);
                AutoRegisterFieldRouter.queueField(autoRegisterField);
            });
        });
    }

    @Override
    public void invokeAllAutoRegisterMethods(String packageName) {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().forPackage(packageName, new ClassLoader[0]).filterInputsBy((Predicate)new FilterBuilder().includePackage(packageName)).setScanners(new Scanner[]{Scanners.TypesAnnotated}));
        Set annotatedClasses = reflections.getTypesAnnotatedWith(AutoRegister.class);
        annotatedClasses.forEach(clazz -> Arrays.stream(clazz.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(AutoRegister.class)).forEach(method -> {
            method.setAccessible(true);
            try {
                method.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                YungsApiCommon.LOGGER.error("Unable to invoke method {} - make sure it's static and has no args!", (Object)method.getName());
                throw new RuntimeException(e);
            }
        }));
    }

    @Override
    public void processQueuedAutoRegEntries() {
        SoundEventModuleFabric.processEntries();
        StructurePieceTypeModuleFabric.processEntries();
        StructurePoolElementTypeModuleFabric.processEntries();
        CriteriaModuleFabric.processEntries();
        StructureTypeModuleFabric.processEntries();
        FeatureModuleFabric.processEntries();
        PlacementModifierTypeModuleFabric.processEntries();
        ItemModuleFabric.processEntries();
        BlockModuleFabric.processEntries();
        CreativeModeTabModuleFabric.processEntries();
        BlockEntityTypeModuleFabric.processEntries();
        StructureProcessorTypeModuleFabric.processEntries();
        StructurePlacementTypeModuleFabric.processEntries();
        ParticleTypeModuleFabric.processEntries();
        EntityTypeModuleFabric.processEntries();
        EntityDataSerializerModuleFabric.processEntries();
        MobEffectModuleFabric.processEntries();
        PotionModuleFabric.processEntries();
        CommandModuleFabric.processEntries();
    }

    @Override
    public void registerBrewingRecipe(class_6880<class_1842> inputPotion, Supplier<class_1792> ingredient, class_6880<class_1842> outputPotion) {
        FabricBrewingRecipeRegistryBuilder.BUILD.register(builder -> builder.method_59705(inputPotion, (class_1792)ingredient.get(), outputPotion));
    }

    @Override
    public void addCompostableItem(Supplier<class_1792> ingredient, float compostChance) {
        CompostingChanceRegistry.INSTANCE.add((class_1935)ingredient.get(), (Object)Float.valueOf(compostChance));
    }
}

