/*
 * Decompiled with CFR 0.152.
 */
package dragomordor.simpletms;

import com.cobblemon.mod.common.config.constraint.IntConstraint;
import com.mojang.logging.LogUtils;
import dragomordor.simpletms.SimpleTMsItems;
import dragomordor.simpletms.config.DoubleConstraint;
import dragomordor.simpletms.config.SimpleTMsConfig;
import dragomordor.simpletms.events.CobblemonPokemonSpeciesListener;
import dragomordor.simpletms.events.MoveLearnItemDropEventListeners;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KCallablesJvm;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u000f\u0010\u0007\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0003J\u000f\u0010\b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\u0003R\u0014\u0010\n\u001a\u00020\t8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\f\u0010\u000bR\u0014\u0010\r\u001a\u00020\t8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000bR\u0014\u0010\u000f\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\"\u0010\u0012\u001a\u00020\u00118\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Ldragomordor/simpletms/SimpleTMs;", "", "<init>", "()V", "", "preinit", "init", "loadConfig", "saveConfig", "", "MOD_ID", "Ljava/lang/String;", "VERSION", "CONFIG_PATH", "Lorg/slf4j/Logger;", "LOGGER", "Lorg/slf4j/Logger;", "Ldragomordor/simpletms/config/SimpleTMsConfig;", "config", "Ldragomordor/simpletms/config/SimpleTMsConfig;", "getConfig", "()Ldragomordor/simpletms/config/SimpleTMsConfig;", "setConfig", "(Ldragomordor/simpletms/config/SimpleTMsConfig;)V", "common"})
@SourceDebugExtension(value={"SMAP\nSimpleTMs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleTMs.kt\ndragomordor/simpletms/SimpleTMs\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,110:1\n1863#2:111\n1864#2:114\n13346#3,2:112\n*S KotlinDebug\n*F\n+ 1 SimpleTMs.kt\ndragomordor/simpletms/SimpleTMs\n*L\n62#1:111\n62#1:114\n65#1:112,2\n*E\n"})
public final class SimpleTMs {
    @NotNull
    public static final SimpleTMs INSTANCE = new SimpleTMs();
    @NotNull
    public static final String MOD_ID = "simpletms";
    @NotNull
    public static final String VERSION = "2.1.0";
    @NotNull
    public static final String CONFIG_PATH = "config/simpletms/main.json";
    @JvmField
    @NotNull
    public static final Logger LOGGER;
    public static SimpleTMsConfig config;

    private SimpleTMs() {
    }

    @NotNull
    public final SimpleTMsConfig getConfig() {
        SimpleTMsConfig simpleTMsConfig = config;
        if (simpleTMsConfig != null) {
            return simpleTMsConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        return null;
    }

    public final void setConfig(@NotNull SimpleTMsConfig simpleTMsConfig) {
        Intrinsics.checkNotNullParameter((Object)simpleTMsConfig, (String)"<set-?>");
        config = simpleTMsConfig;
    }

    public final void preinit() {
        this.loadConfig();
    }

    public final void init() {
        LOGGER.info("Using SimpleTMs (2.1.0)");
        SimpleTMsItems.INSTANCE.registerModItems();
        MoveLearnItemDropEventListeners.INSTANCE.registerListeners();
        CobblemonPokemonSpeciesListener.INSTANCE.registerListeners();
    }

    private final void loadConfig() {
        File configFile = new File(CONFIG_PATH);
        configFile.getParentFile().mkdirs();
        if (configFile.exists()) {
            try {
                FileReader fileReader = new FileReader(configFile);
                this.setConfig((SimpleTMsConfig)SimpleTMsConfig.Companion.getGSON().fromJson((Reader)fileReader, SimpleTMsConfig.class));
                fileReader.close();
            }
            catch (Exception exception) {
                LOGGER.error("Failed to load config file for simpletms. Using default config until the following has been addressed:");
                this.setConfig(new SimpleTMsConfig());
                exception.printStackTrace();
            }
            SimpleTMsConfig defaultConfig = new SimpleTMsConfig();
            Iterable $this$forEach$iv = KClasses.getMemberProperties((KClass)Reflection.getOrCreateKotlinClass(SimpleTMsConfig.class));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Field field;
                KProperty1 it = (KProperty1)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)ReflectJvmMapping.getJavaField((KProperty)((KProperty)it)));
                KCallablesJvm.setAccessible((KCallable)((KCallable)it), (boolean)true);
                Annotation[] annotationArray = field.getAnnotations();
                Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"getAnnotations(...)");
                Object[] $this$forEach$iv2 = annotationArray;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Object value;
                    Annotation it2 = (Annotation)element$iv2;
                    boolean bl2 = false;
                    Annotation annotation = it2;
                    if (annotation instanceof IntConstraint) {
                        value = field.get(INSTANCE.getConfig());
                        if (!(value instanceof Integer)) continue;
                        value = RangesKt.coerceIn((int)((Number)value).intValue(), (int)((IntConstraint)it2).min(), (int)((IntConstraint)it2).max());
                        field.set(INSTANCE.getConfig(), value);
                        continue;
                    }
                    if (!(annotation instanceof DoubleConstraint) || !((value = field.get(INSTANCE.getConfig())) instanceof Double)) continue;
                    value = RangesKt.coerceIn((double)((Number)value).doubleValue(), (double)((DoubleConstraint)it2).min(), (double)((DoubleConstraint)it2).max());
                    field.set(INSTANCE.getConfig(), value);
                }
            }
        } else {
            this.setConfig(new SimpleTMsConfig());
        }
        this.saveConfig();
    }

    private final void saveConfig() {
        try {
            File configFile = new File(CONFIG_PATH);
            FileWriter fileWriter = new FileWriter(configFile);
            SimpleTMsConfig.Companion.getGSON().toJson((Object)this.getConfig(), (Appendable)fileWriter);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception exception) {
            LOGGER.error("Failed to save config file for simpletms. The following exception occurred:");
            exception.printStackTrace();
        }
    }

    static {
        Logger logger = LogUtils.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
    }
}

