/*
 * Decompiled with CFR 0.152.
 */
package fuzs.resourcepackoverrides.client.handler;

import fuzs.resourcepackoverrides.client.data.ResourceOverridesManager;
import fuzs.resourcepackoverrides.services.ClientAbstractions;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_309;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_368;
import net.minecraft.class_372;
import net.minecraft.class_437;
import net.minecraft.class_521;
import net.minecraft.class_5375;
import org.jetbrains.annotations.Nullable;

public class PackActionsHandler {
    private static final Int2ObjectMap<PackAction> PACK_ACTIONS = new Int2ObjectOpenHashMap();
    private static boolean debugTooltips;

    public static void onScreen$Render$Post(class_310 minecraft, class_5375 screen, class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (debugTooltips && screen.field_25468.field_25626 == minecraft.method_1520()) {
            PackActionsHandler.getHoveredPackId(screen, mouseX, mouseY).map(class_2561::method_43470).ifPresent(component -> guiGraphics.method_51438(ClientAbstractions.INSTANCE.getScreenFont((class_437)screen), (class_2561)component, mouseX, mouseY));
        }
    }

    private static Optional<String> getHoveredPackId(class_5375 screen, int mouseX, int mouseY) {
        if (screen == null) {
            return Optional.empty();
        }
        for (class_364 guiEventListener : screen.method_25396()) {
            if (!(guiEventListener instanceof class_521)) continue;
            class_521 selectionList = (class_521)guiEventListener;
            class_521.class_4271 hovered = null;
            for (class_521.class_4271 packEntry : selectionList.method_25396()) {
                if (!packEntry.method_25405((double)mouseX, (double)mouseY)) continue;
                hovered = packEntry;
                break;
            }
            if (hovered == null) continue;
            return Optional.of(hovered.method_48279().replace("\u00a7", "\\u00A7"));
        }
        return Optional.empty();
    }

    public static void onClientTick$End(class_310 minecraft) {
        PACK_ACTIONS.values().forEach(action -> action.tick(minecraft));
    }

    public static void onKeyPressed$Post(class_310 minecraft, class_5375 screen, int keyCode, int scanCode, int modifiers) {
        PackAction packAction;
        if (screen.field_25468.field_25626 == minecraft.method_1520() && (packAction = (PackAction)PACK_ACTIONS.get(keyCode)) != null) {
            packAction.update();
        }
    }

    static {
        PACK_ACTIONS.put(67, (Object)new PackAction((class_2561)class_2561.method_43471((String)"packAction.copyId.title"), (class_2561)class_2561.method_43469((String)"packAction.copyId.description", (Object[])new Object[]{class_2561.method_43470((String)"C").method_27692(class_124.field_1067)}), (class_2561)class_2561.method_43471((String)"packAction.copyId.success")){

            @Override
            boolean execute(class_310 minecraft, class_5375 screen) {
                class_312 mouseHandler = minecraft.field_1729;
                class_1041 window = minecraft.method_22683();
                int mouseX = (int)(mouseHandler.method_1603() * (double)window.method_4486() / (double)window.method_4480());
                int mouseY = (int)(mouseHandler.method_1604() * (double)window.method_4502() / (double)window.method_4507());
                Optional<String> hoveredPackId = PackActionsHandler.getHoveredPackId(screen, mouseX, mouseY);
                hoveredPackId.ifPresent(arg_0 -> ((class_309)minecraft.field_1774).method_1455(arg_0));
                return hoveredPackId.isPresent();
            }
        });
        PACK_ACTIONS.put(68, (Object)new PackAction((class_2561)class_2561.method_43471((String)"packAction.toggleDebug.title"), (class_2561)class_2561.method_43469((String)"packAction.toggleDebug.description", (Object[])new Object[]{class_2561.method_43470((String)"D").method_27692(class_124.field_1067)}), (class_2561)class_2561.method_43471((String)"packAction.toggleDebug.success")){

            @Override
            boolean execute(class_310 minecraft, class_5375 screen) {
                debugTooltips = !debugTooltips;
                return true;
            }
        });
        PACK_ACTIONS.put(82, (Object)new PackAction((class_2561)class_2561.method_43471((String)"packAction.reloadSettings.title"), (class_2561)class_2561.method_43469((String)"packAction.reloadSettings.description", (Object[])new Object[]{class_2561.method_43470((String)"R").method_27692(class_124.field_1067)}), (class_2561)class_2561.method_43471((String)"packAction.reloadSettings.success")){

            @Override
            boolean execute(class_310 minecraft, class_5375 screen) {
                ResourceOverridesManager.load();
                screen.method_25423(minecraft, minecraft.method_22683().method_4486(), minecraft.method_22683().method_4502());
                return true;
            }
        });
        PACK_ACTIONS.put(84, (Object)new PackAction((class_2561)class_2561.method_43471((String)"packAction.restoreDefaults.title"), (class_2561)class_2561.method_43469((String)"packAction.restoreDefaults.description", (Object[])new Object[]{class_2561.method_43470((String)"T").method_27692(class_124.field_1067)}), (class_2561)class_2561.method_43471((String)"packAction.restoreDefaults.success")){

            @Override
            boolean execute(class_310 minecraft, class_5375 screen) {
                minecraft.method_1520().method_14447(ResourceOverridesManager.getDefaultResourcePacks(true));
                screen.field_25468.field_25455.clear();
                screen.field_25468.field_25455.addAll(minecraft.method_1520().method_14444());
                Collections.reverse(screen.field_25468.field_25455);
                screen.method_25423(minecraft, minecraft.method_22683().method_4486(), minecraft.method_22683().method_4502());
                return true;
            }
        });
    }

    private static abstract class PackAction {
        private final class_2561 title;
        private final class_2561 description;
        private final class_2561 success;
        @Nullable
        private class_372 toast;
        @Nullable
        private class_372 successToast;
        private int successTicks;
        private int pressTime;
        private int lastPressTime;
        private int decreaseTimeDelay;
        private boolean wasExecuted;

        public PackAction(class_2561 title, class_2561 description, class_2561 success) {
            this.title = title;
            this.description = description;
            this.success = success;
        }

        public void tick(class_310 minecraft) {
            if (this.pressTime == this.lastPressTime && this.pressTime > 0 && --this.decreaseTimeDelay < 0) {
                if (this.wasExecuted) {
                    this.reset();
                } else {
                    --this.pressTime;
                }
            }
            this.lastPressTime = this.pressTime;
            if (this.pressTime > 0) {
                class_437 class_4372;
                if (this.toast == null) {
                    this.toast = new class_372(class_372.class_373.field_2230, this.title, this.description, true);
                    minecraft.method_1566().method_1999((class_368)this.toast);
                }
                if (this.pressTime < 20) {
                    this.toast.method_1992(class_3532.method_15363((float)((float)this.pressTime / 20.0f), (float)0.0f, (float)1.0f));
                } else if (!this.wasExecuted && (class_4372 = minecraft.field_1755) instanceof class_5375) {
                    class_5375 screen = (class_5375)class_4372;
                    if (screen.field_25468.field_25626 == minecraft.method_1520()) {
                        if (this.execute(minecraft, screen)) {
                            this.finish(minecraft);
                        }
                        this.wasExecuted = true;
                        this.toast.method_1992(1.0f);
                    }
                }
            } else {
                this.reset();
            }
            if (this.successTicks > 0) {
                --this.successTicks;
                this.successToast.method_1992((float)this.successTicks / 80.0f);
            } else if (this.successToast != null) {
                this.successToast.method_1993();
                this.successToast = null;
            }
        }

        private void reset() {
            if (this.toast != null) {
                this.toast.method_1993();
                this.toast = null;
            }
            this.lastPressTime = 0;
            this.pressTime = 0;
            this.wasExecuted = false;
        }

        abstract boolean execute(class_310 var1, class_5375 var2);

        private void finish(class_310 minecraft) {
            if (this.successToast != null) {
                this.successToast.method_1993();
            }
            this.successToast = new class_372(class_372.class_373.field_2230, this.title, this.success, true);
            minecraft.method_1566().method_1999((class_368)this.successToast);
            this.successTicks = 80;
            this.successToast.method_1992(1.0f);
        }

        public void update() {
            ++this.pressTime;
            this.resetDelay();
        }

        public void resetDelay() {
            this.decreaseTimeDelay = 10;
        }
    }
}

