/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.attachment.builder;

import fuzs.puzzleslib.api.attachment.v4.DataAttachmentRegistry;
import fuzs.puzzleslib.api.event.v1.entity.player.AfterChangeDimensionCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerCopyEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerNetworkEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerTrackingEvents;
import fuzs.puzzleslib.api.network.v3.PlayerSet;
import fuzs.puzzleslib.impl.attachment.AttachmentTypeAdapter;
import fuzs.puzzleslib.impl.attachment.ClientboundEntityDataAttachmentMessage;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public interface EntityDataAttachmentBuilder<V>
extends DataAttachmentRegistry.EntityBuilder<V> {
    @Nullable
    default public BiConsumer<class_1297, V> getSynchronizer(class_2960 resourceLocation, AttachmentTypeAdapter<class_1297, V> attachmentType, @Nullable class_9139<? super class_9129, V> streamCodec, @Nullable Function<class_1297, PlayerSet> synchronizationTargets) {
        if (streamCodec == null) {
            return null;
        }
        class_8710.class_9154 type = new class_8710.class_9154(resourceLocation);
        this.registerPayloadHandlers(resourceLocation, attachmentType, type, streamCodec);
        this.registerEventHandlers(attachmentType, type, synchronizationTargets);
        return this.getDefaultSynchronizer(type, synchronizationTargets);
    }

    public void registerPayloadHandlers(class_2960 var1, AttachmentTypeAdapter<class_1297, V> var2, class_8710.class_9154<ClientboundEntityDataAttachmentMessage<V>> var3, @Nullable class_9139<? super class_9129, V> var4);

    private void registerEventHandlers(AttachmentTypeAdapter<class_1297, V> attachmentType, class_8710.class_9154<ClientboundEntityDataAttachmentMessage<V>> type, @Nullable Function<class_1297, PlayerSet> synchronizationTargets) {
        PlayerNetworkEvents.LOGGED_IN.register(serverPlayer -> this.broadcast(type, serverPlayer, attachmentType));
        AfterChangeDimensionCallback.EVENT.register((serverPlayer, from, to) -> this.broadcast(type, serverPlayer, attachmentType));
        PlayerCopyEvents.RESPAWN.register((serverPlayer, originalStillAlive) -> this.broadcast(type, serverPlayer, attachmentType));
        if (synchronizationTargets != null) {
            PlayerTrackingEvents.START.register((trackedEntity, serverPlayer) -> this.broadcast(type, trackedEntity, PlayerSet.ofPlayer(serverPlayer), (V)attachmentType));
        }
    }

    private BiConsumer<class_1297, V> getDefaultSynchronizer(class_8710.class_9154<ClientboundEntityDataAttachmentMessage<V>> type, @Nullable Function<class_1297, PlayerSet> synchronizationTargets) {
        return (entity, value) -> {
            PlayerSet playerSet = synchronizationTargets != null ? (PlayerSet)synchronizationTargets.apply((class_1297)entity) : PlayerSet.ofEntity(entity);
            this.broadcast(type, (class_1297)entity, playerSet, (V)value);
        };
    }

    private void broadcast(class_8710.class_9154<ClientboundEntityDataAttachmentMessage<V>> type, class_3222 serverPlayer, AttachmentTypeAdapter<class_1297, V> attachmentType) {
        this.broadcast(type, (class_1297)serverPlayer, PlayerSet.ofPlayer(serverPlayer), (V)attachmentType);
    }

    private void broadcast(class_8710.class_9154<ClientboundEntityDataAttachmentMessage<V>> type, class_1297 entity, PlayerSet playerSet, AttachmentTypeAdapter<class_1297, V> attachmentType) {
        if (attachmentType.hasData(entity)) {
            this.broadcast(type, entity, playerSet, attachmentType.getData(entity));
        }
    }

    private void broadcast(class_8710.class_9154<ClientboundEntityDataAttachmentMessage<V>> type, class_1297 entity, PlayerSet playerSet, @Nullable V value) {
        ClientboundEntityDataAttachmentMessage<V> message = new ClientboundEntityDataAttachmentMessage<V>(type, entity.method_5628(), Optional.ofNullable(value));
        playerSet.broadcast(type, (class_2596<?>)new class_2658(message));
    }
}

