/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.item.v2;

import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import fuzs.puzzleslib.impl.item.TierImpl;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1738;
import net.minecraft.class_1832;
import net.minecraft.class_1856;
import net.minecraft.class_2248;
import net.minecraft.class_3481;
import net.minecraft.class_6862;

public final class ItemEquipmentFactories {
    private static final class_1738.class_8051[] ARMOR_TYPES = new class_1738.class_8051[]{class_1738.class_8051.field_41937, class_1738.class_8051.field_41936, class_1738.class_8051.field_41935, class_1738.class_8051.field_41934, class_1738.class_8051.field_48838};

    private ItemEquipmentFactories() {
    }

    public static class_1832 registerTier(int miningLevel, int itemDurability, float miningSpeed, float attackDamageBonus, int enchantability, Supplier<class_1856> repairIngredient) {
        return ItemEquipmentFactories.registerTier(ItemEquipmentFactories.getVanillaMiningLevelBlockTag(miningLevel), itemDurability, miningSpeed, attackDamageBonus, enchantability, repairIngredient);
    }

    public static class_6862<class_2248> getVanillaMiningLevelBlockTag(int miningLevel) {
        return switch (miningLevel) {
            case 0 -> class_3481.field_49930;
            case 1 -> class_3481.field_49928;
            case 2 -> class_3481.field_49927;
            case 3 -> class_3481.field_49926;
            case 4 -> class_3481.field_49925;
            default -> throw new IllegalArgumentException("Unsupported mining level: " + miningLevel);
        };
    }

    public static class_1832 registerTier(class_6862<class_2248> incorrectBlocksForDrops, int itemDurability, float miningSpeed, float attackDamageBonus, int enchantability, Supplier<class_1856> repairIngredient) {
        return new TierImpl(incorrectBlocksForDrops, itemDurability, miningSpeed, attackDamageBonus, enchantability, (Supplier<class_1856>)Suppliers.memoize(repairIngredient::get));
    }

    public static Map<class_1738.class_8051, Integer> toArmorTypeMap(int ... protectionAmounts) {
        return ItemEquipmentFactories.toArmorTypeMapWithFallback(0, protectionAmounts);
    }

    public static Map<class_1738.class_8051, Integer> toArmorTypeMapWithFallback(int protectionAmountFallback, int ... protectionAmounts) {
        EnumMap<class_1738.class_8051, Integer> map = new EnumMap<class_1738.class_8051, Integer>(class_1738.class_8051.class);
        for (int i = 0; i < ARMOR_TYPES.length; ++i) {
            map.put(ARMOR_TYPES[i], i < protectionAmounts.length ? protectionAmounts[i] : protectionAmountFallback);
        }
        return Maps.immutableEnumMap(map);
    }
}

