/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.init.v3.override;

import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.entity.ServerEntityLevelEvents;
import fuzs.puzzleslib.api.event.v1.server.ServerLifecycleEvents;
import fuzs.puzzleslib.impl.PuzzlesLibMod;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.class_1291;
import net.minecraft.class_3176;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;

public final class CommandOverrides {
    private static final String KEY_PLAYER_SEEN_WORLD = PuzzlesLibMod.id("has_seen_world").method_42094();
    private static final Map<CommandEnvironment, Collection<String>> COMMAND_OVERRIDES = Maps.newEnumMap(CommandEnvironment.class);

    private CommandOverrides() {
    }

    public static void registerServerCommand(String command, boolean onlyDedicated) {
        CommandEnvironment commandEnvironment = onlyDedicated ? CommandEnvironment.DEDICATED_SERVER : CommandEnvironment.SERVER;
        COMMAND_OVERRIDES.computeIfAbsent(commandEnvironment, $ -> new LinkedHashSet()).add(command);
    }

    public static void registerEffectCommand(class_6880<class_1291> holder) {
        CommandOverrides.registerPlayerCommand("effect give @s " + holder.method_55840() + " infinite 127 true", false);
    }

    public static void registerPlayerCommand(String command, boolean onlyDedicated) {
        CommandEnvironment commandEnvironment = onlyDedicated ? CommandEnvironment.DEDICATED_PLAYER : CommandEnvironment.PLAYER;
        COMMAND_OVERRIDES.computeIfAbsent(commandEnvironment, $ -> new LinkedHashSet()).add(command);
    }

    @ApiStatus.Internal
    public static void registerHandlers() {
        ServerLifecycleEvents.STARTED.register(server -> {
            if (server.method_30002().method_8510() == 0L) {
                CommandOverrides.executeCommandOverrides(server, CommandEnvironment.SERVER, CommandEnvironment.DEDICATED_SERVER, UnaryOperator.identity());
            }
        });
        ServerEntityLevelEvents.LOAD.register((entity, level) -> {
            class_3222 serverPlayer;
            if (entity instanceof class_3222 && !(serverPlayer = (class_3222)entity).method_5752().contains(KEY_PLAYER_SEEN_WORLD)) {
                serverPlayer.method_5780(KEY_PLAYER_SEEN_WORLD);
                String playerName = serverPlayer.method_7334().getName();
                CommandOverrides.executeCommandOverrides(serverPlayer.field_13995, CommandEnvironment.PLAYER, CommandEnvironment.DEDICATED_PLAYER, s -> s.replaceAll("@[sp]", playerName));
            }
            return EventResult.PASS;
        });
    }

    private static void executeCommandOverrides(MinecraftServer server, CommandEnvironment commandEnvironment, CommandEnvironment dedicatedCommandEnvironment, UnaryOperator<String> formatter) {
        for (String command : (Collection)COMMAND_OVERRIDES.getOrDefault((Object)commandEnvironment, Collections.emptySet())) {
            server.method_3734().method_44252(server.method_3739(), (String)formatter.apply(command));
        }
        if (server instanceof class_3176) {
            for (String command : (Collection)COMMAND_OVERRIDES.getOrDefault((Object)dedicatedCommandEnvironment, Collections.emptySet())) {
                server.method_3734().method_44252(server.method_3739(), (String)formatter.apply(command));
            }
        }
    }

    private static enum CommandEnvironment {
        DEDICATED_SERVER,
        SERVER,
        DEDICATED_PLAYER,
        PLAYER;

    }
}

