/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.paxi;

import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import com.yungnickyoung.minecraft.paxi.PaxiCommon;
import com.yungnickyoung.minecraft.paxi.PaxiPackSource;
import com.yungnickyoung.minecraft.paxi.mixin.accessor.FolderRepositorySourceAccessor;
import com.yungnickyoung.minecraft.yungsapi.io.JSON;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_3258;
import net.minecraft.class_3259;
import net.minecraft.class_3264;
import net.minecraft.class_3279;
import net.minecraft.class_3288;
import net.minecraft.class_9224;
import net.minecraft.class_9225;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaxiRepositorySource
extends class_3279 {
    private static final FileFilter PACK_FILTER = file -> {
        boolean isValidPackZip = file.isFile() && file.getName().endsWith(".zip");
        boolean isValidPackFolder = file.isDirectory() && new File(file, "pack.mcmeta").isFile();
        return isValidPackZip || isValidPackFolder;
    };
    private final File orderingFile;
    public List<String> orderedPaxiPacks = new ArrayList<String>();
    public List<String> unorderedPaxiPacks = new ArrayList<String>();

    public PaxiRepositorySource(Path packsFolder, class_3264 packType, File orderingFile) {
        super(packsFolder, packType, PaxiPackSource.PACK_SOURCE_PAXI, null);
        this.orderingFile = orderingFile;
    }

    public void method_14453(@NotNull Consumer<class_3288> packAdder) {
        File folder = ((FolderRepositorySourceAccessor)((Object)this)).getFolder().toFile();
        if (!folder.isDirectory()) {
            folder.mkdirs();
        }
        if (this.orderingFile != null && !this.orderingFile.isFile()) {
            PackOrdering emptyPackOrdering = new PackOrdering(new String[0]);
            try {
                JSON.createJsonFileFromObject((Path)this.orderingFile.toPath(), (Object)emptyPackOrdering);
            }
            catch (IOException e) {
                PaxiCommon.LOGGER.error("Unable to create default pack ordering file! This shouldn't happen.");
                PaxiCommon.LOGGER.error(e.toString());
            }
        }
        List<Path> packPathsToLoad = PaxiRepositorySource.toPaths(this.loadPacksFromFiles());
        for (Path packPath : packPathsToLoad) {
            String packName = packPath.getFileName().toString();
            class_9224 packLocationInfo = new class_9224(packName, (class_2561)class_2561.method_43470((String)packName), PaxiPackSource.PACK_SOURCE_PAXI, Optional.empty());
            class_9225 packSelectionConfig = new class_9225(true, class_3288.class_3289.field_14280, false);
            class_3288 pack = class_3288.method_45275((class_9224)packLocationInfo, (class_3288.class_7680)this.createPackResourcesSupplier(packPath), (class_3264)((FolderRepositorySourceAccessor)((Object)this)).getPackType(), (class_9225)packSelectionConfig);
            if (pack == null) continue;
            packAdder.accept(pack);
        }
    }

    private List<File> loadPacksFromFiles() {
        File[] paxiPacks;
        this.orderedPaxiPacks.clear();
        this.unorderedPaxiPacks.clear();
        ArrayList<File> allPacks = new ArrayList<File>();
        if (PaxiCommon.CONFIG.loadFromBaseDatapacksDirectory && ((FolderRepositorySourceAccessor)((Object)this)).getPackType() == class_3264.field_14190) {
            File[] basePacks;
            File basePacksFolder = new File(PaxiCommon.BASE_GAME_DIRECTORY, "datapacks");
            if (!basePacksFolder.exists()) {
                basePacksFolder.mkdirs();
            }
            if ((basePacks = basePacksFolder.listFiles(PACK_FILTER)) != null) {
                allPacks.addAll(Arrays.asList(basePacks));
            }
        }
        if ((paxiPacks = ((FolderRepositorySourceAccessor)((Object)this)).getFolder().toFile().listFiles(PACK_FILTER)) != null) {
            allPacks.addAll(Arrays.asList(paxiPacks));
        }
        if (this.orderingFile != null) {
            PackOrdering packOrdering = null;
            try {
                packOrdering = (PackOrdering)JSON.loadObjectFromJsonFile((Path)this.orderingFile.toPath(), PackOrdering.class);
            }
            catch (JsonIOException | JsonSyntaxException | IOException e) {
                PaxiCommon.LOGGER.error("Error loading Paxi ordering JSON file {}: {}", (Object)this.orderingFile.getName(), (Object)e.toString());
            }
            if (packOrdering == null) {
                PaxiCommon.LOGGER.error("Unable to load ordering JSON file {}! Is it proper JSON formatting? Ignoring load order...", (Object)this.orderingFile.getName());
                allPacks.forEach(file -> this.unorderedPaxiPacks.add(file.getName()));
                return allPacks;
            }
            if (packOrdering.getOrderedPackNames() == null) {
                PaxiCommon.LOGGER.error("Unable to find entry with name 'loadOrder' in load ordering JSON file {}! Ignoring load order...", (Object)this.orderingFile.getName());
                allPacks.forEach(file -> this.unorderedPaxiPacks.add(file.getName()));
                return allPacks;
            }
            List<File> orderedPacks = this.filesFromNames(packOrdering.getOrderedPackNames(), PACK_FILTER);
            List<File> unorderedPacks = allPacks.stream().filter(file -> !orderedPacks.contains(file)).toList();
            orderedPacks.forEach(file -> this.orderedPaxiPacks.add(file.getName()));
            unorderedPacks.forEach(file -> this.unorderedPaxiPacks.add(file.getName()));
            return Stream.of(unorderedPacks, orderedPacks).flatMap(Collection::stream).toList();
        }
        allPacks.forEach(file -> this.unorderedPaxiPacks.add(file.getName()));
        return allPacks;
    }

    private List<File> filesFromNames(String[] packFileNames, @Nullable FileFilter filter) {
        ArrayList<File> packFiles = new ArrayList<File>();
        for (String fileName : packFileNames) {
            File packFile = new File(PaxiCommon.BASE_GAME_DIRECTORY, fileName);
            if (!packFile.exists()) {
                packFile = new File(((FolderRepositorySourceAccessor)((Object)this)).getFolder().toFile().toString(), fileName);
            }
            if (!packFile.exists()) {
                PaxiCommon.LOGGER.error("Unable to find pack with name {} specified in load ordering JSON file {}! Skipping...", (Object)fileName, (Object)this.orderingFile.getName());
                continue;
            }
            if (filter != null && !filter.accept(packFile)) {
                PaxiCommon.LOGGER.error("Attempted to load pack {} but it is not a valid pack format! It may be missing a pack.mcmeta file. Skipping...", (Object)fileName);
                continue;
            }
            packFiles.add(packFile);
        }
        return packFiles;
    }

    private class_3288.class_7680 createPackResourcesSupplier(Path path) {
        File file = path.toFile();
        if (file.isFile() && file.getName().endsWith(".zip")) {
            return new class_3258.class_8615(path);
        }
        if (file.isDirectory() && new File(file, "pack.mcmeta").isFile()) {
            return new class_3259.class_8619(path);
        }
        throw new IllegalArgumentException("Invalid Paxi pack file: " + String.valueOf(file));
    }

    private static List<Path> toPaths(List<File> files) {
        return files.stream().map(File::toPath).toList();
    }

    public boolean hasPacks() {
        return !this.unorderedPaxiPacks.isEmpty() || !this.orderedPaxiPacks.isEmpty();
    }

    private static class PackOrdering {
        @SerializedName(value="loadOrder")
        private String[] orderedPackNames;

        public PackOrdering(String[] orderedPackNames) {
            this.orderedPackNames = orderedPackNames;
        }

        public String[] getOrderedPackNames() {
            return this.orderedPackNames;
        }
    }
}

