/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure.lake;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_4076;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6626;
import net.minecraft.class_7138;
import net.minecraft.class_7151;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.BWGStructureTypes;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.lake.LargeLakeConfig;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.lake.LargeLakePiece;
import org.jetbrains.annotations.NotNull;

public class LargeLakeStructure
extends class_3195 {
    public static final MapCodec<LargeLakeStructure> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)LargeLakeStructure.method_42697((RecordCodecBuilder.Instance)builder), (App)LargeLakeConfig.CODEC.fieldOf("config").forGetter(largeLakeStructure -> largeLakeStructure.largeLakeConfig)).apply((Applicative)builder, LargeLakeStructure::new));
    private final LargeLakeConfig largeLakeConfig;

    public LargeLakeStructure(class_3195.class_7302 settings, LargeLakeConfig largeLakeConfig) {
        super(settings);
        this.largeLakeConfig = largeLakeConfig;
    }

    @NotNull
    protected Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        class_5539 levelHeightAccessor;
        class_1923 chunkPos = context.comp_568();
        class_2919 random = context.comp_566();
        int blockX = chunkPos.method_33939(random.method_43048(16));
        int blockZ = chunkPos.method_33941(random.method_43048(16));
        int lakeRadius = random.method_39332(96, 128);
        class_7138 randomState = context.comp_564();
        class_2794 chunkGenerator = context.comp_562();
        int baseHeight = chunkGenerator.method_16397(blockX, blockZ, class_2902.class_2903.field_13195, levelHeightAccessor = context.comp_569(), randomState);
        if (baseHeight <= chunkGenerator.method_16398() || baseHeight < chunkGenerator.method_16397(blockX, blockZ, class_2902.class_2903.field_13194, levelHeightAccessor, randomState)) {
            return Optional.empty();
        }
        return LargeLakeStructure.method_41612((class_3195.class_7149)context, (class_2902.class_2903)class_2902.class_2903.field_13195, piecesBuilder -> {
            class_2338 lakeOrigin = new class_2338(blockX, baseHeight, blockZ);
            this.createLakePieces(context, (class_6626)piecesBuilder, lakeRadius, lakeOrigin, this.largeLakeConfig.depth().method_35008((class_5819)random), levelHeightAccessor);
        });
    }

    private void createLakePieces(class_3195.class_7149 context, class_6626 piecesBuilder, int arenaFloorRadius, class_2338 arenaOrigin, int lakeDepth, class_5539 levelHeightAccessor) {
        for (int chunkX = -(class_4076.method_18675((int)arenaFloorRadius) + 1); chunkX <= class_4076.method_18675((int)arenaFloorRadius) + 1; ++chunkX) {
            for (int chunkZ = -(class_4076.method_18675((int)arenaFloorRadius) + 1); chunkZ <= class_4076.method_18675((int)arenaFloorRadius) + 1; ++chunkZ) {
                class_2338 chunkWorldPos = new class_2338(class_4076.method_18688((int)(context.comp_568().field_9181 + chunkX)), arenaOrigin.method_10264(), class_4076.method_18688((int)(context.comp_568().field_9180 + chunkZ)));
                class_3341 boundingBox = new class_3341(chunkWorldPos.method_10263(), levelHeightAccessor.method_31607(), chunkWorldPos.method_10260(), chunkWorldPos.method_10263() + 15, levelHeightAccessor.method_31600(), chunkWorldPos.method_10260() + 15);
                piecesBuilder.method_35462((class_3443)new LargeLakePiece(arenaOrigin, arenaFloorRadius, 20, boundingBox, this.largeLakeConfig.features()));
            }
        }
    }

    @NotNull
    public class_7151<?> method_41618() {
        return BWGStructureTypes.LARGE_LAKE.get();
    }
}

